#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2003-2009 Free Software Foundation
#
# FILE:
# PageSizes.py
#
# DESCRIPTION:
# Common page sizes in points
#
# NOTES:
# This list created from information in the comp.lang.postscript FAQ:
#   ftp://wilma.cs.brown.edu/pub/comp.lang.postscript/FAQ.txt
#
# Sizes are in Postscript points (72 pts = 1")


PageSizes = {
  "Comm #10 Envelope": (297,684),
  "C5 Envelope": (461,648),
  "DL Envelope": (312,624),
  "Folio": (595,935),
  "Executive": (522,756),
  "Letter": (612,792),
  "Legal": (612,1008),
  "Ledger": (1224,792),
  "Tabloid": (792,1224),
  "A0": (2384,3370),
  "A1": (1684,2384),
  "A2": (1191,1684),
  "A3": (842,1191),
  "A4": (595,842),
  "A5": (420,595),
  "A6": (297,420),
  "A7": (210,297),
  "A8": (148,210),
  "A9": (105,148),
  "B0": (2920,4127),
  "B1": (2064,2920),
  "B2": (1460,2064),
  "B3": (1032,1460),
  "B4": (729,1032),
  "B5": (516,729),
  "B6": (363,516),
  "B7": (258,363),
  "B8": (181,258),
  "B9": (127,181),
  "B10": (91,127),
}
