Tutorial de Emacs.  Vea al final las condiciones de copiado.

Generalmente los comandos de Emacs involucran la tecla CONTROL
(algunas veces llamada CTRL O CTL) o la tecla meta (algunas veces
llamada EDIT o ALT).  En lugar de escribir completamente esto en cada
ocasin, usaremos las siguientes abreviaturas.

 C-<car> significa mantener presionada la tecla CONTROL mientras
         teclea el carcter <car>.  Por lo tanto C-f ser: Mantenga
         presionada la tecla CONTROL y teclee f.
 M-<car> significa mantener presionada la tecla META o EDIT o ALT
 	 mientras teclea <car>.  Si no hay teclas META, EDIT o ALT, en
 	 su lugar presione y libere la tecla ESC y luego teclee
 	 <car>.  Escribimos <ESC> para referirnos a la tecla ESC.

Nota importante: para terminar la sesin de Emacs teclee C-x C-c (dos
caracteres).  Para cancelar un comando parcialmente introducido,
teclee C-g.
Los caracteres ">>" en el margen izquierdo indican instrucciones para
que usted trate de usar un comando.  Por ejemplo:
<<Blank lines inserted around following line by help-with-tutorial>>
[Mitad de pgina en blanco para propsitos didcticos.  El texto contina abajo]
>> Ahora teclee C-v (ver la prxima pantalla) para desplazarse a la
	siguiente pantalla (hgalo manteniendo la tecla control
	oprimida mientras teclea v).  Desde ahora debera hacer esto
	cada vez que termine de leer la pantalla.

Note que se superponen dos lneas cuando se mueve de pantalla en
pantalla; esto provee una continuidad para que pueda seguir leyendo el
texto.

Lo primero que necesita saber es como moverse de un lugar a otro en el
texto.  Ya sabe como avanzar una pantalla, con C-v.  Para retroceder
una pantalla teclee M-v (mantenga oprimida la tecla META y teclee v, o
teclee <ESC>v si no tiene las teclas META, EDIT o ALT).

>> Intente teclear M-v y luego C-v, varias veces.


* RESUMEN
---------

Los siguientes comandos son tiles para ver pantallas completas:

	C-v 	Avanzar una pantalla completa
	M-v 	Retroceder una pantalla completa
	C-l 	Limpiar la pantalla y mostrar todo el texto de nuevo,
 		 moviendo el texto alrededor del cursor al centro de la
		 pantalla (Esto es CONTROL-L, no CONTROL-1.)

>> Encuentre el cursor, y fjese qu texto hay cerca de ste.
   Luego teclee C-l.  Encuentre el cursor otra vez y note que el mismo
   texto est todava cerca del cursor, pero ahora est en el centro
   de la pantalla.
   Si vuelve teclear C-l, ese texto se mover al principio de la
   pantalla.  Al teclear C-l otra vez, se mover al final de la
   pantalla.

Si su terminal las soporta, tambin puede usar las teclas AvPg o
RegPg para moverse por pantallas completas, pero puede editar ms
eficientemente si usa C-v y M-v.

* MOVIMIENTO BSICO DE CURSOR
-----------------------------

Es til moverse de una pantalla completa a otra pero, cmo moverse a
un lugar especfico dentro del texto en la pantalla?

Puede hacerlo de diversas formas.  Puede usar las teclas de flechas,
pero es mas eficiente mantener las manos en la posicin estndar y
usar los comandos C-p, C-b, C-f, y C-n.  Estos caracteres son
equivalentes a las cuatro teclas de flechas, de esta manera:

		        Lnea anterior, C-P
				:
				:
   Atrs, C-b.... Posicin actual del cursor .... Adelante, C-f
				:
				:
			Lnea siguiente, C-n

>> Mueva el cursor a la lnea en la mitad del diagrama
   usando C-n o C-p.  Luego teclee C-l para ver el
   diagrama completo centrado en la pantalla.

Le resultar fcil recordar estas letras por las palabras que
representan: P de Previous (anterior), N de Next (siguiente), B de
Backward (atrs) y F de Forward (adelante).  Estar usando estos
comandos de posicionamiento bsico del cursor todo el tiempo.

>> Teclee algunos C-n para traer el cursor a esta lnea.

>> Muvase a la lnea con C-f y hacia arriba con algunos C-p.  Observe
   lo que hace C-p cuando el cursor est en medio de la lnea.

Cada lnea de texto termina con un carcter de nueva lnea (Newline),
que sirve para separarla de la lnea siguiente.  (Normalmente, la
ltima lnea de un archivo termina con un carcter de nueva lnea,
pero Emacs no requiere que sea as.)

>> Intente usar C-b al comienzo de una lnea.  Debera moverse al
   final de la lnea previa.  Esto sucede porque retrocede a travs
   del carcter de nueva lnea.

C-f puede moverse a travs de una nueva lnea igual que C-b.

>> Teclee algunos C-b ms para que sienta por donde se encuentra el
   cursor.
   Luego teclee C-f para regresar al final de la lnea.
   Luego teclee otro C-f ms para moverse a la lnea siguiente.

Cuando pase el tope o el final de la pantalla, se mostrar el texto
ms all del borde de la pantalla.  Esto recibe el nombre de
"desplazamiento".  Esto le permite a Emacs mover el cursor al lugar
especificado en el texto sin moverlo fuera de la pantalla.

>> Intente mover el cursor fuera del borde de la pantalla con C-n, y
   observe lo que sucede.

Si moverse por caracteres es muy lento, puede moverse por palabras.
M-f (META-f) mueve adelante una palabra y M-b mueva atrs una palabra.

>> Teclee algunos M-f y M-b

Cuando est en la mitad de una palabra, M-f mueve al final de la
palabra.  Cuando est en un espacio entre dos palabras, M-f mueve al
final de la siguiente palabra.  M-b trabaja de la misma forma en la
direccin opuesta.

>> Teclee algunos M-f y M-b, intercaladas con C-f y C-b de tal forma
   que observe la accin de M-f y M-b desde varios sitios dentro y
   entre palabras.

Note el paralelo entre C-f y C-b de un lado y M-f y M-b del otro.  Muy
frecuentemente los caracteres Meta se usan para operaciones
relacionadas, con las unidades definidas por el lenguaje (palabras,
oraciones y prrafos), mientras los caracteres Control operan sobre
unidades bsicas que son independientes de lo que est editando
(caracteres, lneas, etc).

Este paralelo se aplica entre lneas y oraciones: C-a y C-e para
moverse al comienzo o al final de la lnea; y M-a y M-e para mover al
comienzo o al final de una oracin.

>> Intente algunos C-a, y despus unos cuantos C-e.
>> Intente algunos M-a, y despus unos cuantos M-e.

Vea cmo la repeticin de C-a no hace nada, pero la repeticin de M-a
sigue moviendo una oracin ms.  Aunque no son muy anlogas, cada una
parece natural.

La ubicacin del cursor en el texto se llama tambin "punto".  En
otras palabras, el cursor muestra sobre la pantalla donde est
situado el punto dentro del texto.

Aqu hay un resumen de operaciones simples de movimiento del cursor,
incluyendo los comandos de movimiento por palabra y oracin:

	C-f 	Avanzar un carcter
	C-b 	Retroceder un carcter

	M-f 	Avanzar una palabra
	M-b 	Retroceder una palabra

	C-n 	Avanzar a la lnea siguiente
	C-p 	Retroceder a la lnea anterior

	C-a 	Retroceder al comienzo de la lnea
	C-e 	Avanzar al final de la lnea

	M-a 	Retroceder al comienzo de la oracin
	M-e 	Avanzar al final de la oracin

>> Ahora pruebe todos estos comandos algunas veces para practicar.
   Estos comandos son los ms frecuentemente usados.

Otros dos comandos importantes de movimiento del cursor son M-< (META
Menor que), el cual se mueve al comienzo del texto entero, y M-> (META
Mayor que), el cual se mueve al final del texto entero.

En la mayora de las terminales, el "<" est sobre la coma, por lo
tanto tiene que usar la tecla shift para teclearlo.  En estas
terminales tendr que usar la tecla shift tambin al teclear M-<; sin
la tecla shift, usted estara escribiendo M-coma.

>> Ahora pruebe M-<, para moverse al comienzo del tutorial.
   Despus use C-v repetidamente para regresar aqu.

>> Ahora pruebe M->, para moverse al final del tutorial.
   Despus use M-v repetidamente para regresar aqu.

Tambin puede mover el cursor con las teclas de flecha si su terminal
dispone de ellas.  Recomendamos aprender C-b, C-f, C-n y C-p por tres
razones.  Primero, funcionan en todo tipo de terminales.  Segundo, una
vez que gane prctica usando Emacs, encontrar que teclear estos
caracteres Control es ms rpido que usar teclas de flecha (porque no
tendr que mover las manos de la posicin para mecanografiar).
Tercero, una vez tenga el hbito de usar estos comandos Control,
tambin puede aprender a usar otros comandos avanzados de movimiento
del cursor fcilmente.

La mayora de comandos de Emacs aceptan un argumento numrico; para la
mayora de comandos esto sirve como un factor de repeticin.  La
manera de pasarle un factor de repeticin a un comando es tecleando
C-u y luego los dgitos antes de introducir los comandos.  Si tiene
una tecla META (o EDIT o ALT), hay una manera alternativa para
ingresar un argumento numrico: teclear los dgitos mientras presiona
la tecla META.  Recomendamos aprender el mtodo C-u porque ste
funciona en cualquier terminal.  El argumento numrico es tambin
llamado un "argumento prefijo", porque usted teclea el argumento antes
del comando al que se aplica.

Por ejemplo, C-u 8 C-f mueve hacia adelante ocho caracteres.

>> Pruebe usar C-n o C-p con un argumento numrico, para mover el
   cursor a una lnea cercana a sta con un solo comando.

La mayora de comandos usan el argumento numrico como un factor de
repeticin, pero algunos comandos le dan otros usos.  Varios comandos
(pero ninguno de los que ha aprendido hasta ahora) lo usan como una
bandera: la presencia de un argumento prefijo, sin tener en cuenta su
valor, hace que el comando acte de forma diferente.

C-v y M-v son otro tipo de excepcin.  Cuando se les da un argumento,
desplazan la pantalla arriba o abajo esa cantidad de lneas, en vez de
una pantalla completa.  Por ejemplo, C-u 8 C-v desplaza la pantalla 8
lneas.

>> Pruebe tecleando C-u 8 C-v ahora.

Esto debi haber desplazado la pantalla hacia arriba 8 lneas.  Si
quisiera desplazarla hacia abajo de nuevo, puede dar un argumento a
M-v.

Si est usando un entorno grfico, como X o MS-Windows, debe
haber una larga rea rectangular llamada una barra de desplazamiento
en el lado izquierdo de la ventana de Emacs.  Puede desplazar el texto
al oprimir el botn del ratn en la barra de desplazamiento.

Si su ratn tiene un botn de rueda, tambin puede utilizarlo para
desplazar el texto.


* SI EMACS DEJA DE RESPONDER
----------------------------

Si Emacs dejara de responder a sus comandos, puede detenerlo con
seguridad al teclear C-g.  Puede usar C-g para detener un comando que
est tomando mucho tiempo para ejecutarse.

Tambin puede usar C-g para descartar un argumento numrico o el
comienzo de un comando que no quiere finalizar.

>> Escriba C-u 100 para hacer un argumento numrico de 100, y luego
   pruebe C-g.
   Ahora pruebe C-f.  Esto deber mover slo un carcter, ya que
   cancel el argumento con C-g.

Si ha tecleado <ESC> por error, puede desecharlo con un C-g.


* COMANDOS DESACTIVADOS
-----------------------

Algunos comandos de Emacs estn "desactivados" de manera que los
usuarios principiantes no puedan usarlos accidentalmente.

Si teclea uno de los comandos desactivados, Emacs muestra un mensaje
informando acerca de qu comando era, y preguntndole si quiere
continuar y ejecutar el comando.

Si realmente quiere intentar el comando, teclee Espacio como repuesta
a la pregunta.  Normalmente, si no quiere ejecutar el comando
desactivado, conteste la pregunta con "n".

>> Escriba C-x C-l (que es un comando desactivado), a continuacin
   escriba n para responder la pregunta.


* VENTANAS
----------

Emacs puede tener varias "ventanas", cada una mostrando su propio texto.
Explicaremos despus como usar mltiples ventanas.  Ahora mismo
queremos explicar cmo deshacerse de ventanas adicionales y volver a
la edicin bsica en una ventana.  Es sencillo:

	C-x 1 	Una ventana (p.ej.,  elimina todas las otras ventanas).

Esto es CONTROL-x seguido por el dgito 1.  C-x 1 expande la ventana que
contiene el cursor, para ocupar toda la pantalla.  Esto borra todas las
dems ventanas.

>> Mueva el cursor a esta lnea y escriba C-u 0 C-l.
>> Escriba C-h k C-f.
   Vea como esta ventana se encoge, mientras una nueva aparece y
   muestra documentacin sobre el comando C-f.

>> Escriba C-x 1 y vea que la ventana de listado de documentacin
   desaparece.

Este comando es diferente a los otros que ha aprendido en que ste
consiste de dos caracteres.  Comienza con el carcter CONTROL-x.  Hay
toda una serie de comandos que comienzan con CONTROL-x; muchos de
ellos tienen que ver con ventanas, archivos, buffers y cosas
relacionadas.  Estos comandos son de una longitud de dos, tres o
cuatro caracteres.


* INSERTAR Y BORRAR
-------------------

Si quiere insertar un texto, basta con que lo teclee.  Los caracteres
normales, como A, 7, *, etc. se insertan nada ms teclearlos.  Teclee
<Return> (la tecla "Enter" o "Intro") para insertar un carcter de
nueva lnea.

Para borrar el carcter que precede al cursor, oprima <DEL>. Es una
tecla alargada, normalmente etiquetada como "Backspace" o "Del", o con
una flecha apuntando a la izquierda; la misma que suele utilizar fuera
de Emacs para borrar el ltimo carcter introducido.

Puede haber otra tecla llamada "Del" o "Supr" en otra parte, pero sa
no es <DEL>.

>> Haga esto ahora: teclee unos pocos caracteres, despus brrelos
   tecleando <DEL> varias veces.  No se preocupe si este archivo
   cambia, no alterar el tutorial principal.  sta es su copia
   personal de l.

Cuando una lnea de texto se hace muy grande para una sola lnea de la
pantalla, la lnea de texto "contina" en una segunda lnea en la
pantalla. Si est usando un entorno grfico, se mostrarn pequeas
flechas curvas en las estrechas franjas vacas (los "mrgenes" derecho
e izquierdo) a cada lado del rea de texto, para indicar que la lnea
contina. Si est utilizando una terminal, la continuacin se seala
mediante una barra invertida ("\") en la ltima columna de la derecha.

>> Inserte texto hasta que llegue al margen derecho, y siga
   insertando.  Ver aparecer una lnea de continuacin.

>> Use <DEL> para borrar el texto hasta que la lnea de nuevo
   quepa en la pantalla.  La lnea de continuacin se pierde.

Puede borrar un carcter de nueva lnea como cualquier otro carcter.
Al borrar el carcter de nueva lnea entre dos lneas las junta en una
sola lnea.  Si el resultado de la combinacin de lneas es demasiado
largo para caber en el ancho de la pantalla, se mostrar con una lnea
de continuacin.

>> Mueva el cursor al comienzo de una lnea y teclee <DEL>.  Esto
   juntar esa lnea con la lnea anterior.

>> Teclee <Return> para reinsertar la nueva lnea que borr.

Recuerde que a la mayora de los comandos de Emacs se les puede dar un
factor de repeticin; esto incluye los caracteres de texto.  Repetir
un carcter de texto lo inserta varias veces.

>> Intntelo ahora: teclee C-u 8 * para insertar ********.

Ya ha aprendido la manera ms bsica de teclear algo en Emacs y
corregir errores.  Puede borrar por palabras o por lneas.  He aqu un
resumen de las operaciones de borrado:

	<DEL>   	borra el carcter justo antes que el cursor
	C-d		borra el siguiente carcter despus del cursor

	M-<DEL> 	Elimina la palabra inmediatamente antes del
                         cursor
	M-d        	Elimina la siguiente palabra despus del cursor

	C-k  		Elimina desde el cursor hasta el fin de la lnea
	M-k  		Elimina hasta el final de la oracin actual

Note que <DEL> y C-d, comparados con M-<DEL> y M-d, extienden el
paralelismo iniciado por C-f y M-f (bien, <DEL> no es realmente una
tecla de control, pero no nos preocuparemos de eso ahora).  C-k y M-k,
en ciertas forma, son como C-e y M-e, en que las lneas de unos
corresponden a sentencias en los otros.

Tambin puede eliminar un segmento contiguo de texto con un mtodo
uniforme.  Muvase a un extremo de ese segmento de texto, y teclee C-@
o C-SPC (cualquiera de los dos).  (SPC es la barra espaciadora.)
Luego, mueva el cursor al otro extremo del texto que desea eliminar.
Al hacerlo, Emacs resaltar el texto situado entre el cursor y la
posicin en la que tecle C-SPC.  Finalmente, teclee C-w.  Eso elimina
todo el texto entre las dos posiciones.

>> Mueva el cursor a la letra T del inicio del prrafo anterior.
>> Teclee C-SPC.  Emacs debe mostrar el mensaje "Mark set" en la parte
   de abajo de la pantalla.
>> Mueva el cursor a la x en "extremo", en la segunda lnea del
   prrafo.
>> Teclee C-w.  Esto eliminar el texto que comienza desde la T, y
   termina justo antes de la x.

La diferencia entre "eliminar" y "borrar" es que el texto "eliminado"
puede ser reinsertado (en cualquier posicin), mientras que las cosas
"borradas" no pueden ser reinsertadas (sin embargo, es posible
deshacer el borrado; ver ms abajo).  La reinsercin de texto
eliminado se llama "yanking" o "pegar".  Generalmente, los comandos
que pueden quitar mucho texto lo eliminan (para que pueda pegarlo de
nuevo) mientras que los comandos que quitan solo un carcter, o solo
lneas en blanco y espacios, borran (y por tanto no se puede pegar lo
borrado).  Si se normalmente, sin pasar un argumento, <DEL> y C-d
borran.  Con un argumento, eliminan.

>> Mueva el cursor al comienzo de una lnea que no est vaca.
   Luego teclee C-k para eliminar el texto de esa lnea.
>> Teclee C-k por segunda vez.  Ver que elimina la nueva lnea que
   sigue a esa lnea.

Note que al teclear C-k una sola vez elimina el contenido de la lnea,
y un segundo C-k elimina la lnea misma, y hace que todas las otras
lneas se muevan hacia arriba.  C-k trata un argumento numrico
especialmente: Elimina ese nmero de lneas y TAMBIN sus
contenidos.  Esto no es una simple repeticin.  C-u 2 C-k elimina dos
lneas y sus nuevas lneas, tecleando C-k dos veces no hace esto.

Reinsertar texto eliminado se denomina "yanking" o "pegar".  (Piense
en ello como pegar de nuevo, o traer de vuelta, algn texto que le fue
quitado.)  Puede pegar el texto eliminado, ya sea el lugar en que fue
eliminado, o en otra parte del buffer, o hasta en un archivo
diferente.  Puede pegar el texto varias veces, lo que hace varias
copias de l.  Algunos editores se refieren a eliminar y reinsertar
como "cortar" y "pegar" (consulte el Glosario en el manual de Emacs).

El comando para pegar es C-y.  Reinserta el ltimo texto eliminado, en
la posicin actual del cursor.

>> Intntelo; teclee C-y para pegar de nuevo el texto.

Si hace varios C-k seguidos, todo el texto eliminado se guarda junto,
de manera que un C-y pegar todas las lneas al mismo tiempo.

>> Haga esto ahora, teclee C-k varias veces.

Ahora para recuperar ese texto eliminado:

>> Teclee C-y.  Luego baje el cursor unas pocas lneas y teclee C-y de
   nuevo.  De esta forma puede copiar un texto.

Qu hacer si tiene algn texto que quiere pegar, y entonces elimina
otra cosa?  C-y pegara la eliminacin ms reciente.  Pero el texto
previo no est perdido.  Puede regresar a ste usando el comando M-y.
Despus de haber tecleado C-y para conseguir la eliminacin ms
reciente, tecleando M-y reemplaza el texto pegado con la eliminacin
previa.  Tecleando M-y una y otra vez traer las eliminaciones
anteriores.  Cuando haya encontrado el texto que buscaba, no tiene que
hacer nada para conservarlo.  Slo siga con su edicin, dejando el
texto pegado en donde est.

Si teclea M-y suficientes veces, regresa al punto inicial (la
eliminacin ms reciente).

>> Elimine una lnea, muvase un poco, elimine otra lnea.
   Luego teclee C-y para recuperar la segunda lnea eliminada.
   Luego teclee M-y y ser reemplazado por la primera lnea eliminada.
   Teclee ms veces M-y y vea lo que obtiene.  Siga hacindolo hasta
   que la segunda lnea eliminada regrese, y entonces unas pocas
   ms.  Si quiere, puede tratar de darle a M-y argumentos positivos y
   negativos.


* DESHACER
----------

Si hace un cambio al texto, y luego decide que fue un error,
puede deshacer el cambio con el comando deshacer, C-/.

Normalmente, C-/ deshace los cambios hechos por un comando; si repite
varias veces seguidas C-/, cada repeticin deshar un comando
adicional.

Pero hay dos excepciones: los comandos que no cambian el texto no
cuentan (esto incluye los comandos de movimiento del cursor y de
desplazamiento), y los caracteres de autoinsercin se manejan
usualmente en grupos de hasta 20 caracteres.  (Esto es para reducir el
numero de C-/ que tenga que teclear para deshacer una insercin en
el texto.)

>> Elimine esta lnea con C-k, despus teclee C-/ y debera
   reaparecer.

C-_ es un comando alternativo para deshacer; funciona igual que C-/.
En algunas terminales, al teclear C-/ en realidad enva C-_ a Emacs.
Tambin existe la alternativa de usar C-x u, que funciona exactamente
igual que C-/, pero es menos cmodo de teclear.

Un argumento numrico para C-/, C-_ o C-x u acta como un factor de
repeticin.

Puede deshacer un texto borrado justo como puede deshacer el texto
eliminado.  La distincin entre eliminar algo y borrar algo afecta en
si puede pegarlo con C-y; no hay diferencia alguna para deshacer.


* ARCHIVOS
----------

Para que pueda hacer permanente el texto que edite, lo debe colocar en
un archivo.  De otra manera, ste se perder cuando cierre Emacs.
Para poder poner su texto en un archivo, debe "encontrar" el archivo
antes de ingresar el texto.  (Esto se llama tambin "visitar" el
archivo.)

Encontrar un archivo significa que puede ver su contenido dentro de
Emacs.  En cierta forma, es como si estuviera editando el archivo
mismo.  Sin embargo los cambios que haga mediante Emacs no sern
permanentes hasta que "guarde" el archivo.  Esto es para evitar dejar
un archivo a medio cambiar en el sistema cuando no quiera.  Incluso
cuando guarde, Emacs dejar el archivo original bajo un nombre
cambiado en caso de que luego decida que sus cambios fueron un error.

Si mira cerca del final de la pantalla podr ver una lnea que
comienza con guiones, y empieza con " -:--- TUTORIAL.es" o algo as.
Esta parte de la pantalla normalmente muestra el nombre del archivo
que est visitando.  En este momento est visitando su propia copia
del tutorial de Emacs, que se llama "TUTORIAL.es".  Cuando encuentre
un archivo con Emacs, el nombre de ese archivo aparecer en ese mismo
punto.

Una cosa especial acerca del comando para encontrar un archivo, es que
tendr que decir que nombre de archivo desea.  Decimos que el comando
"lee un argumento" (en este caso, el argumento es el nombre del
archivo).  Despus de teclear el comando:

	C-x C-f   Encontrar un archivo

Emacs le pide que teclee el nombre del archivo.  El nombre de archivo
que teclee aparece en la lnea final de la pantalla.  A la lnea final
de la pantalla se la denomina minibuffer cuando se utiliza para este
tipo de entradas.  Puede usar comandos de edicin ordinarios de Emacs
para editar el nombre del archivo.

Mientras est ingresando el nombre del archivo (o cualquier otra
entrada al minibuffer) puede cancelar el comando con C-g.

>> Teclee C-x C-f, luego teclee C-g.  Esto cancela el minibuffer, y
   tambin cancela el comando C-x C-f que estaba usando el minibuffer.
   As que no encontrar archivo alguno.

Cuando haya finalizado de ingresar el nombre del archivo, teclee
<Return> para terminarlo.  El minibuffer desaparece, y el comando C-x
C-f trabaja para encontrar el archivo que escogi.

En seguida aparecer el contenido del archivo en la pantalla, y puede
editarlo.  Cuando quiera que sus cambios sean permanentes, teclee el
comando

	C-x C-s   Guardar el archivo

Esto copia el texto dentro de Emacs al archivo.  La primera vez que
haga esto, Emacs renombrar el archivo original con un nuevo nombre
para que ste no se pierda.  El nuevo nombre se hace agregando "~" al
final del nombre del archivo original.

Cuando guardar haya terminado, Emacs mostrar el nombre del archivo
escrito.  Deber guardar frecuentemente, para que no pierda mucho
trabajo si el sistema falla (vea la seccin "AUTO GUARDADO", ms
adelante).

>> Teclee C-x C-s TUTORIAL.es <Return>
   Esto guardar el tutorial en un archivo llamado TUTORIAL.es, y
   mostrar "Wrote ...TUTORIAL.es" al final de la pantalla.

Puede encontrar un archivo existente, para verlo o editarlo.  Tambin
puede hacerlo con un archivo que no exista.  sta es la forma de crear
un archivo en Emacs: encuentre el archivo, que comenzar vaco, luego
comience a insertar el texto para ese archivo.  Cuando invoque
"guardar" el archivo, Emacs crear realmente el archivo con el texto
que ha insertado.  De ah en adelante, puede considerarse estar
editando un archivo existente.


* BUFFERS
---------

Si visita un segundo archivo con C-x C-f, el primer archivo permanece
dentro de Emacs.  Puede volver a el encontrndolo de nuevo con C-x
C-f.  De esta forma puede mantener un gran nmero de archivos dentro
de Emacs.

Emacs almacena cada texto del archivo dentro de un objeto llamado
"buffer".  Al encontrar un archivo se crea un nuevo buffer dentro de
Emacs.  Para mirar la lista de los buffers que existen actualmente,
teclee:

	C-x C-b   Lista de buffers

>> Pruebe C-x C-b ahora.

Vea como cada buffer tiene un nombre, y adems puede tener un nombre
de archivo para el archivo que contiene.  CUALQUIER texto que vea en
una ventana de Emacs es siempre parte de algn buffer.

>> Teclee C-x 1 para deshacerse de la lista de buffers.

Cuando tenga varios buffers, solo uno de ellos es "actual" en algn
momento.  Ese buffer es el que actualmente edita.  Si quiere editar
otro buffer, necesita "cambiar" a l.  Si quiere cambiar a un buffer
que corresponde a un archivo, puede hacerlo visitando el archivo de
nuevo con C-x C-f.  Pero existe una manera ms rpida: use el comando
C-x b.  En ese comando, necesita teclear el nombre de buffer.

>> Cree un archivo llamado "foo" tecleando C-x C-f foo <Return>.
   Despus teclee C-x b TUTORIAL.es <Return> para regresar a este
   tutorial.

La mayora del tiempo el nombre del buffer es el mismo que el nombre
del archivo (sin la parte del directorio del archivo).  Sin embargo,
esto no es as siempre.  La lista de buffers que hace con C-x C-b
muestra el nombre de cada buffer y de su archivo correspondiente.

Algunos buffers no corresponden a un archivo.  El buffer llamado
"*Buffer List*", que contiene la lista de buffers que ha creado con
C-x C-b, no tiene archivo.  Este buffer TUTORIAL.es al principio no
tena archivo, pero ahora ya s, porque en la seccin anterior tecle
C-x C-s y lo guard en un archivo.

El buffer llamado "*Messages*" tampoco tiene un archivo
correspondiente.  Este buffer contiene los mensajes que han aparecido
en la lnea de abajo durante su sesin de Emacs.

>> Teclee C-x b *Messages* <Return> para ver el buffer de mensajes.
   Luego teclee C-x b TUTORIAL <Return> para regresar a este tutorial.

Si hace cambios al texto de un archivo, y luego encuentra otro
archivo, esto no guarda el primer archivo.  Sus cambios permanecern
dentro de Emacs en ese buffer del archivo.  La creacin o edicin del
segundo buffer de archivo no afecta al primero.  Esto es muy til,
pero tambin significa que necesita una forma conveniente para guardar
el archivo del primer buffer.  Sera una molestia tener que volver a
ste con C-x C-f para guardarlo con C-x C-s.  As tenemos

	C-x s 	Guardar algunos buffers

C-x s le pregunta sobre cada buffer que contenga cambios que no haya
guardada.  Le pregunta, por cada buffer, si quiere guardarlo o no.

>> Inserte una lnea de texto, luego teclee C-x s.
   Debera preguntarle si desea guardar el buffer llamado TUTORIAL.es.
   Conteste si a la pregunta tecleando "y".


* EXTENDER EL CONJUNTO DE COMANDOS
----------------------------------

Hay muchsimos ms comandos de Emacs que los que podran asignarse a
todos los caracteres control y meta.  Emacs puede darle la vuelta a
esto usando el comando X (eXtendido).  ste viene de dos formas:

	C-x 	Carcter eXtendido.  Seguido por un carcter.
        M-x 	Comando eXtendido por nombre.  Seguido por un nombre
                largo.

Estos comandos son generalmente tiles pero menos usados que los
comandos que ha aprendido hasta ahora.  Ya ha visto dos: los comandos
de archivo C-x C-f para Encontrar y C-x C-s para Guardar.  Otro
ejemplo es el comando para terminar la sesin de Emacs: se trata del
comando C-x C-c.  (No se preocupe por perder los cambios que haya
hecho; C-x C-c ofrece guardar cada archivo alterado antes de finalizar
Emacs.)

Si est utilizando una pantalla grfica, no necesita ningn comando
especial para cambiar de Emacs a otra aplicacin.  Puede hacerlo con
el ratn, o mediante el gestor de ventanas.  Sin embargo, si est
usando una terminal que solo puede mostrar una aplicacin a la vez,
tendr que "suspender" Emacs para poder acceder a otros programas.

C-z es el comando para salir de Emacs *temporalmente*: para que pueda
regresar a la misma sesin de Emacs despus.  Cuando Emacs est
ejecutndose en una terminal, C-z "suspende" Emacs; esto es, se
regresa al intrprete de comandos pero no se destruye Emacs.  En los
intrpretes de comandos ms comunes, puede reanudar Emacs con el
comando `fg' o con `%emacs'.

El momento para usar C-x C-c es cuando est listo para salir del
sistema.  Es adems el paso correcto para salir de un Emacs llamado
bajo programas de gestin de correo y otras utilidades diversas.

Existen muchos comandos C-x.  He aqu la lista de los que ya ha
aprendido:

	C-x C-f		Encontrar archivo
	C-x C-s		Guardar archivo
	C-x s		Guardar varios buffers
	C-x C-b		Lista de buffers
	C-x b		Cambiar a otro buffer
	C-x C-c		Salir de Emacs
	C-x 1		Borrar todo menos una ventana
	C-x u		Deshacer

Los comandos eXtendidos por nombre son comandos que se utilizan an
con menos frecuencia, o nicamente en ciertos modos.  Un ejemplo es el
comando replace-string, el cual substituye globalmente una cadena de
caracteres por otra.  Cuando teclea M-x, Emacs le pregunta al final de
la pantalla con M-x y debe escribir el nombre del comando; en este
caso "replace-string".  Solo teclee "repl s<TAB>" y Emacs completar
el nombre.  (<TAB> es la tecla del tabulador, que habitualment est
situada sobre la tecla de bloquear maysculas o la de shift, en el
lado izquierdo del teclado.)  Para aceptar el comando y ejecutarlo,
pulse <Return>.

El comando replace-string requiere dos argumentos: la cadena de
caracteres a reemplazar, y la cadena de caracteres para reemplazarla.
Debe terminar cada argumento con <Return>.

>> Mueva el cursor hacia la lnea en blanco dos lneas abajo de sta.
   A continuacin escriba
   M-x repl s<Return>cambiado<Return>alterado<Return>.

   Note cmo esta lnea ha cambiado: ha substituido la palabra
   c-a-m-b-i-a-d-o por "alterado" en cada ocurrencia, despus de la
   posicin inicial del cursor.


* AUTO GUARDADO
---------------

Si ha hecho cambios en un archivo, pero no los ha guardado, stos
podran perderse si su computadora falla.  Para protegerlo de esto,
Emacs peridicamente escribe un archivo "auto guardado" para cada
archivo que est editando.  El nombre del archivo auto guardado tiene
un # al principio y al final; por ejemplo, si su archivo se llama
"hola.c", su archivo auto guardado es "#hola.c#".  Cuando guarda por
la va normal, Emacs borra su archivo de auto guardado.

Si la computadora falla, puede recuperar su edicin de auto guardado
encontrando el archivo normal (el archivo que estuvo editando, no el
archivo de auto guardar) y entonces tecleando M-x recover-file
<Return>.  Cuando le pregunte por la confirmacin, teclee yes<Return>
para seguir adelante y recuperar la informacin de auto guardado.


* REA DE ECO
-------------

Si Emacs ve que usted est tecleando comandos de multicaracteres
lentamente, se los muestra al final de la pantalla en un rea llamada
"rea de eco".  El rea de eco contiene la lnea final de la pantalla.


* LNEA DE MODO
---------------

La lnea inmediatamente encima del rea de eco recibe el nombre de
"lnea de modo" o "mode line".  La lnea de modo dice algo as:

 -:**-  TUTORIAL.es       63% L749    (Fundamental)

Esta lnea da informacin til acerca del estado de Emacs y del texto
que est editando.

Ya sabe qu significa el nombre del archivo: es el archivo que usted
ha encontrado.  NN% indica su posicin actual en el texto; esto
significa que NN por ciento del texto est encima de la parte superior
de la pantalla.  Si el principio del archivo est en la pantalla, ste
dir "Top" en vez de " 0%".  Si el final del texto est en la
pantalla, dir "Bot".  Si est mirando un texto tan pequeo que cabe
entero en la pantalla, el modo de lnea dir "All".

La L y los dgitos sealan la posicin de otra forma: indican el
nmero de lnea actual del punto.

Los asteriscos cerca del frente significan que usted ha hecho cambios
al texto.  Inmediatamente despus que visite o guarde un archivo, esa
parte de la lnea de modo no muestra asteriscos, solo guiones.

La parte de la lnea de modo dentro de los parntesis es para
indicarle en qu modo de edicin est.  El modo por omisin es
Fundamental, el cual est usando ahora.  ste es un ejemplo de un
"modo mayor".

Emacs tiene diferentes modos mayores.  Algunos estn hechos para
editar diferentes lenguajes y/o clases de texto, tales como modo de
Lisp, modo de Texto, etc.  En cualquier momento uno y solo un modo
mayor est activo, y su nombre siempre se puede encontrar en la lnea
de modo, justo en donde "Fundamental" est ahora.

Cada modo mayor hace que algunos comandos acten diferente.  Por
ejemplo, hay comandos para crear comentarios en un programa, y como
cada lenguaje de programacin tiene una idea diferente de cmo debe
verse un comentario, cada modo mayor tiene que insertar comentarios de
forma distinta.  Cada modo mayor es el nombre de un comando extendido,
que es como puede cambiar a ese modo.  Por ejemplo, M-x
fundamental-mode es un comando para cambiar al modo fundamental.

Si va a editar un texto de algn lenguaje humano, como este archivo,
debera usar el modo de texto.

>> Teclee M-x text-mode <Return>.

No se preocupe, ninguno de los comandos de Emacs que ha aprendido
cambia de manera significativa.  Pero puede observar que M-f y M-b
tratan los apstrofes como parte de las palabras.  Previamente, en
modo Fundamental, M-f y M-b trataban los apstrofes como separadores
de palabras.

Los modos mayores normalmente hacen cambios sutiles como el anterior:
la mayora de comandos hacen "el mismo trabajo" en cada modo mayor,
pero funcionan de forma un poco diferente.

Para ver la documentacin del modo mayor actual, teclee C-h m.

>> Use C-l C-l para traer esta lnea en la parte superior de la
   pantalla.

>> Teclee C-h m, para ver como el modo de Texto difiere del modo
   Fundamental.

>> Teclee C-x 1 para eliminar la documentacin de la pantalla.

Los modos mayores se llaman as porque tambin hay modos menores.  Los
modos menores no son alternativas para los modos mayores, solo
modificaciones menores de stos.  Cada modo menor puede ser activado o
desactivado por s mismo, independiente de todos los otros modos
menores, e independiente de su modo mayor.  Por tanto, puede no usar
modos menores, o solamente uno, o cualquier combinacin de varios
modos menores.

Un modo menor que es muy til, especialmente para editar textos en
espaol, es el modo Auto Fill.  Cuando este modo est activado, Emacs
rompe la lnea entre palabras automticamente siempre que inserte
texto y la lnea sea demasiado ancha.

Puede activar el modo Auto Fill al hacer M-x auto-fill-mode <Return>.
Cuando el modo est activado, puede desactivarlo nuevamente usando M-x
auto-fill-mode <Return>.  Si el modo est desactivado, este comando lo
activa, y si el modo est activado, este comando lo desactiva.
Decimos que el comando "cambia el modo".

>> teclee M-x auto-fill-mode <Return> ahora.  Luego inserte una lnea
   de "asdf " repetidas veces hasta que la vea dividida en dos lneas.
   Debe intercalar espacios porque Auto Fill slo rompe lneas en los
   espacios.

El margen est normalmente puesto en 70 caracteres, pero puede
cambiarlo con el comando C-x f.  Debe indicar el margen deseado como
un argumento numrico.

>> Teclee C-x f con un argumento de 20.  (C-u 2 0 C-x f).  Luego
   teclee algn texto y vea como Emacs lo parte en lneas de 20
   caracteres.  A continuacin ponga de nuevo el margen a 70 usando
   otra vez C-x f.

Si hace cambios en el medio de un prrafo, el modo Auto Fill no lo
rellenar por usted.
Para rellenar el prrafo, teclee M-q (META-q) con el cursor dentro de
ese prrafo.

>> Mueva el cursor al prrafo anterior y teclee M-q.


* BUSCAR
--------

Emacs puede hacer bsquedas de cadenas (una "cadena" es un grupo de
caracteres contiguos) hacia adelante a travs del texto o hacia atrs
en el mismo.  La bsqueda de una cadena es un comando de movimiento de
cursor; mueve el cursor al prximo lugar donde esa cadena aparece.

El comando de bsqueda de Emacs es "incremental".  Esto significa que
la bsqueda ocurre mientras teclea la cadena para buscarla.

El comando para iniciar una bsqueda es C-s para bsqueda hacia
adelante, y C-r para la bsqueda hacia atrs.  PERO ESPERE!  No los
intente an.

Cuando teclee C-s ver que la cadena "I-search" aparece como una
peticin en el rea de eco.  Esto le indica que Emacs est en lo que
se conoce como bsqueda incremental, esperando que teclee lo que
quiere buscar.  <Return> termina una bsqueda.

>> Ahora teclee C-s para comenzar la bsqueda.  LENTAMENTE, una letra
   a la vez, teclee la palabra 'cursor', haciendo pausa despus de
   cada carcter para notar lo que pasa con el cursor.
   Ahora ha buscado "cursor", una vez.
>> Teclee C-s de nuevo, para buscar la siguiente ocurrencia de
   "cursor".
>> Ahora teclee <DEL> cuatro veces y vea como se mueve el cursor.
>> Teclee <Return> para terminar la bsqueda.

Vi lo que ocurri?  Emacs, en una bsqueda incremental, trata de ir
a la ocurrencia de la cadena que ha tecleado hasta el momento.  Para
ir a la prxima ocurrencia de 'cursor' solo teclee C-s de nuevo.  Si
tal ocurrencia no existe, Emacs pita y le dice que la bsqueda actual
est fallando ("failing").  C-g tambin termina la bsqueda.

Si se encuentra en medio de una bsqueda incremental y teclea <DEL>,
la bsqueda "vuelve" a un punto anterior.  Si teclea <DEL> justo
despus de teclear C-s para avanzar hasta la siguiente ocurrencia de
la cadena buscada, el cursor retrocede a una ocurrencia previa.  Si no
hay ocurrencias previas, <DEL> borra el ltimo carcter de la cadena
buscada.  Por ejemplo, suponga que ha tecleado "c", para buscar la
primera ocurrencia de "c".  Ahora, si teclea "u", el cursor se mover
a la primera ocurrencia de "cu".  Ahora teclee <DEL>.  Esto borra la
"u" de la cadena buscada, y el cursor vuelve a la primera ocurrencia
de "c".

Si est en medio de una bsqueda y teclea un carcter control o meta
(con algunas pocas excepciones: los caracteres que son especiales en
una bsqueda, tales como C-s y C-r), la bsqueda termina.

C-s inicia una exploracin que busca alguna ocurrencia de la cadena
buscada DESPUS de la posicin actual del cursor.  Si quiere buscar
algo anterior en el texto, teclee en cambio C-r.  Todo lo que hemos
dicho sobre C-s tambin se aplica a C-r, excepto que la direccin de
la bsqueda se invierte.


* MLTIPLES VENTANAS
--------------------

Una de las caractersticas agradables de Emacs es que se puede mostrar
ms de una ventana en la pantalla al mismo tiempo.  (Note que Emacs
usa el trmino "marcos", descrito en la siguiente seccin, para
referirse a lo que otras aplicaciones llaman "ventanas".  El manual de
Emacs contiene un Glosario de trminos.)

>> Mueva el cursor a esta lnea y teclee C-l C-l.

>> Ahora teclee C-x 2 que divide la pantalla en dos ventanas.
   Ambas ventanas muestran este tutorial.  El cursor de edicin
   permanece en la ventana superior.

>> Teclee C-M-v para desplazar la ventana inferior.
   (Si no tiene una tecla META real, teclee ESC C-v.)

>> Teclee C-x o ("o" para "otro") para mover el cursor a la ventana
   inferior.
>> Use C-v y M-v en la ventana inferior para desplazarla.
   Siga leyendo estas direcciones en la ventana superior.

>> Teclee C-x o de nuevo para mover el cursor de vuelta a la ventana
   superior.
   El cursor en la ventana superior est justo donde estaba antes.

Puede continuar usando C-x o para cambiar entre las ventanas.  La
"ventana seleccionada", donde tiene lugar casi toda la edicin, es la
que tiene un cursor muy visible que parpadea cuando usted no est
tecleando.  Las otras ventanas tienen sus propia posicin del cursor;
si est ejecutando Emacs en una pantalla grfica, esos cursores se
muestran como rectngulos vacos que no parpadean.

El comando C-M-v es muy til cuando est editando un texto en una
ventana y usando la otra ventana como referencia.  Sin moverse de la
ventana seleccionada, puede desplazar el texto de la otra ventana con
C-M-v.

C-M-v es un ejemplo de un carcter CONTROL-META.  Si tiene una tecla
META (o Alt), puede teclear C-M-v pulsando a la vez CONTROL y META
mientras teclea v.  No importa qu tecla "vaya primero", CONTROL o
META, porque las dos teclas actan modificando los caracteres que
teclea.

Si no tiene una tecla META, y en vez de eso usa ESC, el orden s
importa: debe teclear ESC seguido de Control-v, porque Control-ESC v
no funcionar.  Esto es porque ESC es un carcter que tiene valor por
s mismo, no es una tecla modificadora.

>> Teclee C-x 1 (en la ventana de arriba) para deshacerse de la
   ventana de abajo.

(Si hubiera tecleado C-x 1 en la ventana inferior, esto eliminara la
superior.  Piense en este comando como "mantener slo una
ventana--aquella en la cual estoy.")

No tiene por qu mostrarse el mismo buffer en ambas ventanas.  Si usa
C-x C-f para encontrar un archivo en una ventana, la otra ventana no
cambia.  Puede encontrar un archivo en cada ventana
independientemente.

Aqu hay otra forma para usar dos ventanas para mostrar dos cosas
diferentes:

>> Teclee C-x 4 C-f seguido del nombre de uno de sus archivos.
   Finalice con <Return>.  Vea que el archivo especificado aparece en
   la ventana inferior.  El cursor v all tambin.

>> Teclee C-x o para regresar a la ventana superior, y C-x 1 para
   borrar la ventana inferior.


* MLTIPLES MARCOS
------------------

Emacs puede crear tambin mltiples "marcos".  Marco es como
denominamos a un grupo de ventanas, junto con sus menus, barras de
desplazamiento, reas de eco, etc.  En entornos grficos, lo que Emacs
denomina "marco" es lo que otras aplicaciones llaman "ventana".  En
entornos grficos, es posible mostrar varios marcos al mismo tiempo.
En una terminal, solo se puede mostrar un marco a la vez.

>> Teclee M-x make-frame <Return>.
   En la pantalla aparecer un nuevo marco.

En el nuevo marco puede hacer todo lo que haca en el marco original.
El primer marco no tiene nada de especial.

>> Teclee M-x delete-frame <Return>.
   Esto destruye el marco seleccionado.

Tambin puede destruir un marco mediante el mtodo normal que ofrezca
el entorno grfico (a menudo, pinchando con el ratn en un botn
etiquetado como "X" en alguna de las esquinas superiores del marco).
Si al hacer eso destruye el ltimo marco de Emacs, la aplicacin
termina.


* NIVELES RECURSIVOS DE EDICIN
--------------------------------

Algunas veces entrar a lo que es llamado un "nivel recursivo de
edicin".  Esto se indica en la lnea de modo mediante corchetes en la
lnea de modo, rodeando los parntesis del nombre del modo mayor.  Por
ejemplo, probablemente vea [(Fundamental)] en vez de (Fundamental).

Para salir de los niveles recursivos de edicin, teclee ESC ESC ESC.
ste es un comando de "salida" para todo propsito.  Tambin lo puede
usar para eliminar ventanas extras, y salir del minibuffer.

>> Teclee M-x para entrar a un minibuffer; luego teclee ESC ESC ESC
   para salir.

No se puede usar C-g para salir de los "niveles recursivos de
edicin".  Esto es porque C-g es usado para cancelar comandos y
argumentos DENTRO del nivel recursivo de edicin.


* CONSEGUIR MAS AYUDA
---------------------

En este tutorial hemos tratado de ofrecer suficiente informacin para
que empiece a usar Emacs.  Hay tanto disponible en Emacs que sera
imposible explicar todo aqu.  Sin embargo, quiz desee aprender ms
sobre Emacs, ya que tiene muchas otras caractersticas tiles.  Emacs
provee comandos para leer documentacin acerca de los comandos de
Emacs.  Todos estos comandos de "ayuda" comienzan con el carcter
Control-h, que es llamado "el carcter de Ayuda (Help)".

Para usar las funciones de ayuda, teclee el carcter C-h, y luego un
carcter que especifica qu tipo de ayuda quiere.  Si est REALMENTE
perdido teclee C-h ? y Emacs le dir qu tipo de ayuda puede
ofrecerle.  Si ha tecleado C-h y decide que no quiere ninguna ayuda,
teclee C-g para cancelarlo.

(Si C-h no muestra un mensaje de ayuda en el final de la pantalla,
intente teclear la tecla F1 o, en su lugar, M-x help <Return>.)

La funcin de AYUDA ms bsica es C-h c.  Teclee C-h, el carcter c y
un carcter de comando o secuencia de comando; Emacs le mostrar
una descripcin muy breve del comando.

>> Teclee C-h c C-p.
   El mensaje debe ser algo como

	  C-p runs the command previous-line

Esto le dice el "nombre de la funcin".  Ya que los nombres de las
funciones se eligen para indicar lo que hace el comando, pueden servir
como una breve documentacin: suficiente para recordarle los comandos
que ha aprendido.

Los comandos de mltiples caracteres tales como C-x C-s y (s no tiene
las teclas META o EDIT o ALT) <ESC>v tambin estn permitidos despus
de C-h c.

Para conseguir ms informacin sobre un comando use C-h k en vez de
C-h c.

>> Teclee C-h k C-p.

Esto muestra la documentacin de la funcin, al igual que el nombre,
en una ventana de Emacs.  Cuando haya terminado de leer el resultado,
teclee C-x 1 para deshacerse de la ventana.  No tiene que hacer esto
ahora.  Puede hacer algunas ediciones mientras se refiere al texto de
ayuda, y entonces teclear C-x 1.

Aqu hay algunas otras opciones tiles de C-h:

   C-h f	Describe una funcin.  Usted teclea el nombre de la
		funcin.

>> Intente teclear C-h f previous-line <Return>.
   Esto muestra toda la informacin que Emacs tiene sobre la funcin
   que implementa el comando C-p

Un comando similar, C-h v, muestra documentacin de las variables,
incluyendo los valores que pueda poner para adaptar el comportamiento
de Emacs.  Deber teclear el nombre de la variable cuando Emacs
pregunte por ella.

   C-h a 	Comando Apropos.  Teclee una palabra y Emacs har una
		lista de todos los comandos que contengan esa palabra.
		Todos estos comandos pueden ser invocados con META-x.
		Para algunos comandos, el Comando Apropos tambin
		listar una secuencia de uno o dos caracteres la cual
		ejecutar el mismo comando.

>> Teclee C-h a file <Return>.

Esto muestra en otra ventana una lista de todos los comandos M-x con
la palabra "file" en sus nombres.  Ver comandos de caracteres como
C-x C-f listados adems de los nombres de los comandos
correspondientes tales como find-file.

>> Teclee C-M-v para desplazar la ventana de ayuda.  Haga esto unas
   cuantas veces.

>> Teclee C-x 1 para borrar la ventana de ayuda.

   C-h i        Leer los manuales incluidos (alias Info).  Este comando
                lo pone en un buffer especial llamado `*info*' donde
                puede leer manuales de los paquetes instalados en su
                sistema. Teclee m emacs <Return> para leer el manual
                de Emacs.  Si nunca ha usado Info, teclee ? y Emacs y
                lo llevar por una visita guiada de los servicios del
                modo de Info.  Una vez que haya terminado este
                tutorial, debera considerar el manual Info de Emacs
                como su documentacin primaria.


* MS CARACTERSTICAS
---------------------

Puede aprender ms acerca de Emacs leyendo su manual, ya sea como
libro o en el propio Emacs (use el men Ayuda, "Help", o teclee C-h
r).  Dos caractersticas que pueden gustarle son la completacin, que
ahorra teclear, y dired, que simplifica el manejo de archivos.

La completacin es una manera de ahorrar teclear innecesariamente.
Por ejemplo, si quiere cambiarse al buffer "*Messages*", puede teclear
C-x b *M<Tab> y emacs encontrar el resto del nombre del buffer tan
lejos como pueda determinar de lo que ya haya tecleado.  La
completacin tambin funciona con nombres de comandos y de archivos.
La completacin se describe en el Info del manual de Emacs en el nodo
llamado "Completion".

Dired le permite listar los archivos en un directorio (y opcionalmente
sus subdirectorios), moverse alrededor de esa lista, visitar,
renombrar, borrar y aparte de eso operar en los archivos.  Dired est
descrito en el manual de Emacs en el nodo llamado "Dired".

El manual tambin describe otras caractersticas de Emacs.


* CONCLUSIN
------------

Para salir permanentemente de Emacs use C-x C-c.

Este tutorial intenta ser comprensible para todos los usuarios nuevos,
as que si encuentra algo que no est claro, no se quede parado
culpndose a s mismo: Qujese!


* COPIA
-------

Este tutorial desciende de una larga lnea de tutoriales de Emacs
comenzando con el escrito por Stuart Cracraft para el Emacs original.

La versin en espaol fue originalmente traducida por estudiantes del
Gimnasio Fidel Cano (un colegio en Santaf de Bogot, Colombia):

	Carlos Alberto Lpez Troncoso
	Andrs Felipe Mancipe Galvis
	Lina Fernanda Pinto Garca
	Liliana Carolina Quitin Cedeo
	Leonardo Ramrez Vargas <leonardoramirez@latinmail.com>
	Juan David Vargas Botero <cyberbob1164@hotmail.com>
	Juan Pablo Yela Galln
	Jorge Enrique Crdenas Carrillo <platypus_life@hotmail.com>

La versin en espaol ha sido revisada y corregida por:

	Pablo Reyes <reyes_pablo@hotmail.com>
	Igor Tmara <ikks@bigfoot.com>
	Melissa Giraldo de Tmara <melagira@yahoo.com>
	Vladimir Tmara <vtamara@gnu.org>
        Rafael Seplveda <drs@gnulinux.org.mx>
        Juanma Barranquero <lektu@terra.es>

La versin en espaol ha sido actualizada por:

	Rafael Seplveda <drs@gnulinux.org.mx>
	Juanma Barranquero <lekktu@gmail.com>

Por favor, en caso de duda, slo es vlido el original en ingls de la
siguiente nota de derechos de reproduccin (que puede encontrar en el
archivo TUTORIAL).

Copyright (C) 1985, 1996, 1998, 2001-2012  Free Software Foundation, Inc.

   Se permite a cualquiera hacer o distribuir copias literales de este
   documento como se recibe, en cualquier medio, siempre que la nota
   de derechos de reproduccin y la nota de permiso se preserven, y
   que el distribuidor permita que el que la recibe hacer distribucin
   posterior como lo permite esta nota.

   Se permite distribuir versiones modificadas de este documento, o
   porciones de ste, bajo las condiciones anteriores, siempre que
   ellas tengan nota visible especificando quin fue el ltimo en
   alterarlas.

Las condiciones para copiar Emacs mismo son ms complejas, pero con el
mismo espritu.  Por favor lea el archivo COPYING y luego distribuya
copias de GNU Emacs a sus amigos.  Ayude a erradicar el
obstruccionismo del software ("propietariedad") usando, escribiendo, y
compartiendo software libre!

--- end of TUTORIAL.es ---

;;; Local Variables:
;;;   coding: latin-1
;;; End:

