/* include/linux/i2c/ssd2531-ts.h */

/* Touchscreen characteristics vary between boards and models.  The
 * platform_data for the device's "struct device" holds this information.
 *
 */
#include <linux/i2c.h>
#include <linux/input.h>
#include <linux/earlysuspend.h>

// Device Registers

#define SSD2531_REG_NO_OP		0x0
#define SSD2531_REG_SW_RESET	0x1
#define SSD2531_REG_CHIP_ID		0x2
#define SSD2531_REG_DRIVE_ELECTRODES_NUM		0x6
#define SSD2531_REG_SENSE_ELECTRODES_NUM		0x7
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_0		0x8
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_1		0x9
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_2		0xa
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_3		0xb
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_4		0xc
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_5		0xd
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_6		0xe
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_7		0xf
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_8		0x10
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_9		0x11
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_10		0x12
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_11		0x13
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_12		0x14
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_13		0x15
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_14		0x16
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_15		0x17
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_16		0x18
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_17		0x19
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_18		0x1a
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_19		0x1b
#define SSD2531_REG_DRIVE_PIN_SLEW_RATE_20		0x1c
#define SSD2531_REG_SYSTEM_EN					0x23
#define SSD2531_REG_SYSTEM_DISABLE				0x24
#define SSD2531_REG_OP_MODE_WRITE				0x25
#define SSD2531_REG_OP_MODE_READ				0x26
#define SSD2531_REG_POWER_DOWN_TIME				0x27
#define SSD2531_REG_FRAMES_BEFORE_POWER_DOWN	0x28	/* number of frames without touch before system going down */
#define SSD2531_REG_IDLE_CYCLES					0x29	/* number of idle cycles between driving two rows */
#define SSD2531_REG_SUB_FRAMES					0x2a
#define SSD2531_REG_CLOCK_EN					0x2b
#define SSD2531_REG_MEDIAN_FILTER				0x2c
#define SSD2531_REG_MIN_FINGER_AREA				0x33
#define SSD2531_REG_MIN_FINGER_LEVEL			0x34
#define SSD2531_REG_MIN_FINGER_WEIGHT			0x35
#define SSD2531_REG_MAX_FINGER_AREA				0x36
#define SSD2531_REG_IMAGE_SEGMENTATION_DEPTH	0x37
#define SSD2531_REG_DELTA_DATA_RANGE			0x38
#define SSD2531_REG_CG_CALC_MODE				0x39
#define SSD2531_REG_FILTER_TYPE					0x3d

#define SSD2531_REG_SINGLE_CLICK_TIMING			0x51
#define SSD2531_REG_DOUBLE_CLICK_TIMING			0x52
#define SSD2531_REG_CG_TOLERANCE				0x53
#define SSD2531_REG_X_TRACK_TOLERANCE			0x54
#define SSD2531_REG_Y_TRACK_TOLERANCE			0x55
#define SSD2531_REG_ENABLE_MOVING_AVERAGE		0x56

#define SSD2531_REG_WEIGHT_SCALE_FACTOR			0x58
#define SSD2531_REG_COORDINATE_REMAP			0x65
#define SSD2531_REG_X_SCALE_FACTOR				0x66
#define SSD2531_REG_Y_SCALE_FACTOR				0x67

#define SSD2531_REG_ENABLE_MOVE_TOLERANCE		0x59
#define SSD2531_REG_MAX_MISSED_FRAMES			0x5a
#define SSD2531_REG_MOVE_TOLERANCE_WINDOW		0x5b


#define SSD2531_REG_EVENT_STATUS				0x79
#define SSD2531_REG_EVENT_MASK					0x7a
#define SSD2531_REG_IRQ_MASK					0x7b
#define SSD2531_REG_FINGER_STATUS_BASE			0x7C
#define SSD2531_REG_EVENT_STACK					0x80
#define SSD2531_REG_EVENT_STACK_CLEAR			0x81
#define SSD2531_RESET_INIT_REFERENCE_PROCEDURE	0xa2

#define SSD2531_REG_CHARGE_PUMP					0xc1
#define SSD2531_REG_DRIVE_VOLTAGE				0xd5
#define SSD2531_REG_SENSE_FILTER_EN				0xd9

#define SSD2531_CLOCK_EN_DSP					0x1
#define SSD2531_CLOCK_EN_SELFCAP				0x2

/* Operation Modes (reg 0x25) */
#define SSD2531_OP_MODE_IDLE					0x0
#define SSD2531_OP_MODE_FAST_200HZ				0x2
#define SSD2531_OP_MODE_FAST_166HZ				0x3
#define SSD2531_OP_MODE_FAST_142HZ				0x4
#define SSD2531_OP_MODE_FAST_125HZ				0x5
#define SSD2531_OP_MODE_FAST_100HZ				0x6
#define SSD2531_OP_MODE_NORMAL_83HZ				0x7
#define SSD2531_OP_MODE_NORMAL_71HZ				0x8
#define SSD2531_OP_MODE_NORMAL_62HZ				0x9
#define SSD2531_OP_MODE_NORMAL_55HZ				0xa
#define SSD2531_OP_MODE_NORMAL_50HZ				0xb
#define SSD2531_OP_MODE_SLOW_45HZ				0xc
#define SSD2531_OP_MODE_SLOW_37HZ				0xd
#define SSD2531_OP_MODE_SLOW_30HZ				0xe
#define SSD2531_OP_MODE_SLOW_25HZ				0xf

/* CG Calculation method (reg 0x39) */
#define SSD2531_CALC_MODE_WEIGHTED_AVG			0x0
#define SSD2531_CALC_MODE_CURVE_FITTING			0x1

/* Coordinate Remapping */
#define SSD2531_REMAP_FLIP_X				0x1
#define SSD2531_REMAP_FLIP_Y				0x2
#define SSD2531_REMAP_TRANSPOSE				0x4

/* Event Status Bits (reg 0x79) */
#define SSD2531_EVENT_STATUS_FINGER_0			0x1
#define SSD2531_EVENT_STATUS_FINGER_1			0x2
#define SSD2531_EVENT_STATUS_FINGER_2			0x4
#define SSD2531_EVENT_STATUS_FINGER_3			0x8
#define SSD2531_EVENT_STATUS_STACK_NOT_EMPTY	0x10
#define SSD2531_EVENT_STATUS_STACK_OVERFLOW		0x20
#define SSD2531_EVENT_STATUS_LARGE_OBJECT		0x40

/* Event Type (reg 0x80) */
#define SSD2531_EVENT_TYPE_NO_EVENT				0x0
#define SSD2531_EVENT_TYPE_ONE_FINGER_CLICK		0x1
#define SSD2531_EVENT_TYPE_ONE_FINGER_DCLICK	0x2
#define SSD2531_EVENT_TYPE_TWO_FINGERS_CLICK	0x3
#define SSD2531_EVENT_TYPE_TWO_FINGERS_DCLICK	0x4
#define SSD2531_EVENT_TYPE_FINGER_ENTER			0x5
#define SSD2531_EVENT_TYPE_FINGER_LEAVE			0x6
#define SSD2531_EVENT_TYPE_FINGER_MOVE			0x7
#define SSD2531_EVENT_TYPE_UNKNOWN_EVENT		0xf


/* Charge Pump 2nd Booster Control modes (reg 0xc1) */
#define SSD2531_CHARGE_PUMP_x6					0x02
#define SSD2531_CHARGE_PUMP_x5					0x22
#define SSD2531_CHARGE_PUMP_x4					0x32

/* Drive Voltage Level (reg 0xd5) */
#define SSD2531_DRIVE_VOLTAGE_LEVEL_8V			0x0
#define SSD2531_DRIVE_VOLTAGE_LEVEL_8_5V		0x1
#define SSD2531_DRIVE_VOLTAGE_LEVEL_9V			0x2
#define SSD2531_DRIVE_VOLTAGE_LEVEL_9_5V		0x3
#define SSD2531_DRIVE_VOLTAGE_LEVEL_10V			0x4
#define SSD2531_DRIVE_VOLTAGE_LEVEL_10_5V		0x5
#define SSD2531_DRIVE_VOLTAGE_LEVEL_11V			0x6
#define SSD2531_DRIVE_VOLTAGE_LEVEL_11_5V		0x7
#define SSD2531_DRIVE_VOLTAGE_LEVEL_12V			0x8
#define SSD2531_DRIVE_VOLTAGE_LEVEL_12_5V		0x9
#define SSD2531_DRIVE_VOLTAGE_LEVEL_13V			0xa
#define SSD2531_DRIVE_VOLTAGE_LEVEL_13_5V		0xb
#define SSD2531_DRIVE_VOLTAGE_LEVEL_14V			0xc
#define SSD2531_DRIVE_VOLTAGE_LEVEL_14_5V		0xd
#define SSD2531_DRIVE_VOLTAGE_LEVEL_15V			0xe
#define SSD2531_DRIVE_VOLTAGE_LEVEL_15_5V		0xf

struct POINT {
	int x;
	int y;
};

struct screen_data {
   u8 inactive_area_left;
   u8 inactive_area_right;
   u8 inactive_area_top;
   u8 inactive_area_bottom;
   u16 min_x;
   u16 min_y;
   u16 max_x;
   u16 max_y;
};

#define MAX_DRIVE_PINS 20

struct panel_data {
	u16 min_x;
	u16 min_y;
	u16 max_x;
	u16 max_y;
	int driveline_num;
	int senseline_num;
	int drivepin_slew_rates[MAX_DRIVE_PINS];
	int x_scale;
	int y_scale;
	int remap;
};

struct finger_data {
	u16 x;
	u16 y;
	u8 pressure;
	u8 status;
};

#define FINGER_STATUS_DOWN			0x1
#define FINGER_STATUS_DIRTY_BIT		0x2
#define FINGER_STATUS_REPORT_ENTER 	0x4

#ifdef CONFIG_TOUCHSCREEN_SSD2531_MT
  #define MAX_POINTERS			3
#else
  #define MAX_POINTERS			1
#endif

struct ssd2531_platform_data
{
	struct panel_data panel;
	struct screen_data screen;
	int reset_gpio;
};

struct ssd2531_data {
	struct i2c_client *client;
	struct input_dev *input;
	struct ssd2531_platform_data *platform_data;
	struct finger_data fingers[MAX_POINTERS];
	struct early_suspend early_suspend;
};

static inline void ssd2531_set_screen_dimensions(struct screen_data *screen, int min_x, int min_y, int max_x, int max_y)
{
	screen->min_x = min_x;
	screen->min_y = min_y;
	screen->max_x = max_x;
	screen->max_y = max_y;
}

static inline void ssd2531_set_screen_inactive_area(struct screen_data *screen, int left, int right, int top, int bottom)
{
	screen->inactive_area_left = left;
	screen->inactive_area_right = right;
	screen->inactive_area_top = top;
	screen->inactive_area_bottom = bottom;
}

static inline void ssd2531_set_panel_dimensions(struct panel_data *panel, int min_x, int min_y, int max_x, int max_y)
{
	panel->min_x = min_x;
	panel->min_y = min_y;
	panel->max_x = max_x;
	panel->max_y = max_y;
}





