/*
 * evb96-wm8976.c -- ASoC Machine Driver for DMW-96's Evaluatipon board with Wolfson WM8976
 *
 *  Copyright (C) 2011 DSPG Technologies GmbH
 *
 * 16 October, 2011:
 * Adapted to kernel 2.6.39 by Avi Miller <Avi.Miller@dspg.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//#define DEBUG
//#define V_DEBUG

#include <mach/gpio.h>
#include <sound/soc.h>
#include <sound/soc-dapm.h>

/*****************************************************************************/

#ifdef V_DEBUG
	#ifndef DEBUG 
		#define DEBUG
	#endif
	#define vdbg_prt(fmt, ...) \
		pr_debug("Evb-WM76 asoc Mach-drv: %s(): " fmt, __func__, ##__VA_ARGS__)
#else
	#define vdbg_prt(fmt, ...)
#endif


#ifdef DEBUG
	#define dbg_prt(fmt, ...) \
		pr_debug("Evb-WM76 asoc Mach-drv: %s(): " fmt, __func__, ##__VA_ARGS__)

	#define DIR_STR(stream_dir)  ((stream_dir == 0) ? "for Playback" : "for Capture")
#else
	#define dbg_prt(fmt, ...)
	#define DIR_STR(stream_dir)
#endif

/*****************************************************************************/

#define DRIVER_NAME "snd-evb96-mach-drv"
#include "dspg-wm897X.c"

/* EVB96 board specific sound-related HW devices: */
static const char *pwramp_shutdn_st[] = {"shutdown", "active"};
static const struct soc_enum pwramp_shutdn_enum = SOC_ENUM_SINGLE_EXT(2, pwramp_shutdn_st);

static const char *pwramp_gain_st[] = {"+18db", "+6db"};
static const struct soc_enum pwramp_gain_enum = SOC_ENUM_SINGLE_EXT(2, pwramp_gain_st);

static const char *micr_sel_st[] = {"Differential", "Single-ended"};
static const struct soc_enum micr_sel_enum = SOC_ENUM_SINGLE_EXT(2, micr_sel_st);

static const char *outdev_sel_st[] = {"PwrAmp", "Nokia-Headset"};
static const struct soc_enum outdev_sel_enum = SOC_ENUM_SINGLE_EXT(2, outdev_sel_st);

static const struct snd_kcontrol_new brd_audio_controls[] = {

	SOC_ENUM_EXT("Output-PwrAmp-Gain", pwramp_gain_enum,
		brd_get_pwramp_gain, brd_set_pwramp_gain),

	SOC_ENUM_EXT("Output-PwrAmp-Activation", pwramp_shutdn_enum,
		brd_get_pwramp_shutdn, brd_set_pwramp_shutdn),
		
	SOC_ENUM_EXT("Output-Analog-SW", outdev_sel_enum,
		brd_get_output_sel, brd_set_output_sel),

	SOC_ENUM_EXT("Mic-Type-Select", micr_sel_enum,
		brd_get_mic_sel, brd_set_mic_sel),
};
static const size_t len_of_control_array = ARRAY_SIZE(brd_audio_controls);

static const struct snd_soc_dapm_widget brd_dapm_widgets[] = {
	SND_SOC_DAPM_MIC("Regular-Headset-Mic-Jack", NULL),
	SND_SOC_DAPM_MIC("Nokia-Headset-Mic-Jack", NULL),
	SND_SOC_DAPM_MIC("Onboard-Mic2", NULL),

	SND_SOC_DAPM_HP("Regular-Headset-Ear-Jack", NULL),
	SND_SOC_DAPM_HP("Nokia-Headset-Ear-Jack", NULL),
	
	SND_SOC_DAPM_SPK("Earpiece", NULL),
	
	SND_SOC_DAPM_SPK("Speakers", brd_dapm_pwramp_shutdn),

	SND_SOC_DAPM_INPUT("Analog-SW-L_IN"),
	SND_SOC_DAPM_INPUT("Analog-SW-R_IN"),
	SND_SOC_DAPM_OUTPUT("Analog-SW-L_OUT"),
	SND_SOC_DAPM_OUTPUT("Analog-SW-R_OUT"),

	SND_SOC_DAPM_INPUT("Out-PwrAmp-L_IN"),
	SND_SOC_DAPM_INPUT("Out-PwrAmp-R_IN"),
	SND_SOC_DAPM_OUTPUT("Out-PwrAmp-L_OUT"),
	SND_SOC_DAPM_OUTPUT("Out-PwrAmp-R_OUT"),
};

static const size_t len_of_widget_array = ARRAY_SIZE(brd_dapm_widgets);

static const struct snd_soc_dapm_route brd_audio_route[] = {
	
	// sink, control, source (,connected)

	/* Output path: */
	
	/* Regular Headset earphones directly connected to LOUT2, ROUT2 */
	{"Regular-Headset-Ear-Jack", NULL, "LOUT2"},
	{"Regular-Headset-Ear-Jack", NULL, "ROUT2"},

	/* Nokia Headset earphones connected to LOUT1, ROUT1 via Analog Switch U15 */
	{"Nokia-Headset-Ear-Jack", "Output-Analog-SW", "LOUT1"},
	{"Nokia-Headset-Ear-Jack", "Output-Analog-SW", "ROUT1"},

	/* Onboard Speakers connected via Power Amp, via Analog Switch U15, to LOUT1, ROUT1  */
	{"Analog-SW-L_IN", NULL, "LOUT1"},
	{"Analog-SW-R_IN", NULL, "ROUT1"},

	{"Analog-SW-L_OUT", "Output-Analog-SW", "Analog-SW-L_IN"},
	{"Analog-SW-R_OUT", "Output-Analog-SW", "Analog-SW-R_IN"},

	{"Out-PwrAmp-L_IN", NULL, "Analog-SW-L_OUT"},
	{"Out-PwrAmp-R_IN", NULL, "Analog-SW-R_OUT"},

	{"Out-PwrAmp-L_OUT", "Output-PwrAmp-Activation", "Out-PwrAmp-L_IN"},
	{"Out-PwrAmp-R_OUT", "Output-PwrAmp-Activation", "Out-PwrAmp-R_IN"},

	{"Speakers", NULL, "Out-PwrAmp-L_OUT"},
	{"Speakers", NULL, "Out-PwrAmp-R_OUT"},

	/* Onboard Earpiece directly connected to OUT3, OUT4 */
	{"Earpiece", NULL, "OUT3"},
	{"Earpiece", NULL, "OUT4"},

	/* Input path: */

	/* Regular Headset's Single-Ended Microphone */
	{ "Mic-Bias", NULL, "Regular-Headset-Mic-Jack" },

	/* Nokia Headset's Single-Ended Microphone */
	{ "Mic-Bias", NULL, "Nokia-Headset-Mic-Jack" },

	/* OnBoard Differential Microphone */
	{ "Mic-Bias", NULL, "Onboard-Mic2" },

	{ "LIN", NULL, "Mic-Bias" },
	{ "LIP", NULL, "Mic-Bias" },
};

static const size_t len_of_route_array = ARRAY_SIZE(brd_audio_route);

static const struct wm897X_setup_data hw_data_for_codec = {
	.use_tie_off = false,
};

static int check_valid_board( void )
{
	dbg_prt();

	/* Check for EVB96 board with Wolfson chip WM8976 */
	if ( dmw_board_is("evb96") &&
	     (dmw_board_has_feature("wm8976") ||
	      !dmw_board_has_feature("wm8978")) ) {
		printk("Assuming wm8976 sound device on evb96 board\n");
		return true;
	}

	return false;
}

