/* Copyright (c) 1995 by Internet Software Consortium
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL INTERNET SOFTWARE
 * CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* eventlib.h - exported interfaces for eventlib
 * vix 09sep95 [initial]
 *
 * $Id: eventlib.h,v 1.2 1995/09/17 23:12:25 vixie Exp $
 */

#ifndef _EVENTLIB_H
#define _EVENTLIB_H

#include <sys/time.h>

#ifndef __P
# ifdef __STDC__
#  define __P(x) x
# else
#  define __P(x)
# endif
#endif

/* In the absence of branded types... */
typedef struct { void *opaque; } evTimerID;
typedef struct { void *opaque; } evFileID;
typedef struct { void *opaque; } evSignalID;
typedef struct { void *opaque; } evContext;
typedef struct { void *opaque; } evEvent;

typedef void (*evTimerFunc)__P((evContext ctx, void *uap,
				struct timeval due, struct timeval inter));
typedef void (*evFileFunc)__P((evContext ctx, void *uap, int fd, int evmask));
typedef void (*evSignalFunc)__P((evContext ctx, void *uap, int sig));

#define	EV_POLL		1
#define	EV_WAIT		2

#define	EV_READ		1
#define	EV_WRITE	2
#define	EV_EXCEPT	4

/* eventlib.c */
#define evOpen		__evOpen
#define evClose		__evClose
#define evGetNext	__evGetNext
#define evDispatch	__evDispatch
#define evMainLoop	__evMainLoop

int evOpen __P((evContext *ctx));
int evClose __P((evContext ctx));
int evGetNext __P((evContext ctx, evEvent *ev, int options));
int evDispatch __P((evContext ctx, evEvent ev));
int evMainLoop __P((evContext ctx));

/* timers.c */
#define evConsTimeV	__evConsTimeV
#define evAddTimeV	__evAddTimeV
#define evSubTimeV	__evSubTimeV
#define evCmpTimeV	__evCmpTimeV
#define evSetTimer	__evSetTimer
#define evClearTimer	__evClearTimer

struct timeval evConsTimeV __P((int sec, int usec));
struct timeval evAddTimeV __P((struct timeval add1, struct timeval add2));
struct timeval evSubTimeV __P((struct timeval minu, struct timeval subtra));
int evCmpTimeV __P((struct timeval a, struct timeval b));
int evSetTimer __P((evContext ctx, evTimerFunc func, void *uap,
		    struct timeval due, struct timeval inter,
		    evTimerID *id));
int evClearTimer __P((evContext ctx, evTimerID id));

/* files.c */
#define evSelectFD	__evSelectFD
#define evDeselectFD	__evDeselectFD

int evSelectFD __P((evContext ctx, int fd, int eventmask,
		    evFileFunc func, void *uap, evFileID *id));
int evDeselectFD __P((evContext ctx, evFileID id));

/* signals.c */
#define evSetSignal	__evSetSignal
#define evClearSignal	__evClearSignal

int evSetSignal __P((evContext ctx, int sig, evSignalFunc func, void *uap,
		     evSignalID *ID));
int evClearSignal __P((evContext ctx, evSignalID ID));

#endif /*_EVENTLIB_H*/
