/* Copyright (c) 1995 by Internet Software Consortium
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND INTERNET SOFTWARE CONSORTIUM DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL INTERNET SOFTWARE
 * CONSORTIUM BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* testtimers - a test jig to let programmers test the timer events
 * vix 13sep95 [initial]
 */

#if !defined(LINT) && !defined(CODECENTER)
static const char rcsid[] = "$Id: testtimers.c,v 1.2 1995/09/17 23:12:25 vixie Exp $";
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#ifdef NEED_STRDUP
static char *strdup(char *str);
#endif

#include "eventlib.h"

#ifdef DEBUG
int evDebugLev = 10;
#endif

struct closure {
	char *name;
	evTimerID id;
};

void
myTimerFunc(evContext ctx, void *uap,
	    struct timeval due,
	    struct timeval inter
) {
	struct timeval now;
	struct closure *c = uap;
	int reissue = inter.tv_sec || inter.tv_sec;

	printf("myTimerFunc: due %d.%06d [ctx %#x, uap %#x(%s)]\n",
	       due.tv_sec, due.tv_usec, ctx, c, c->name);
	(void) gettimeofday(&now, NULL);
	printf("myTimerFunc: now %d.%06d [inter %d.%06d, reissue: %d]\n",
	       now.tv_sec, now.tv_usec, inter.tv_sec, inter.tv_usec, reissue);
	if (!reissue)
		free(uap);
}

int
main(int argc, char *argv[]) {
	char buf[1000];
	evContext ev;
	struct timeval now;

	puts("Read the source to figure out what this does.");
	evOpen(&ev);
	gettimeofday(&now, NULL);
	while (gets(buf)) {
		char name[100];
		struct timeval due, inter;
		struct closure *c;
		int x;

		x = sscanf(buf, "%d.%d %d.%d %s\n",
			   &due.tv_sec, &due.tv_usec,
			   &inter.tv_sec, &inter.tv_usec,
			   name);
		if (x != 5 && x != 4 && x != 2) {
			printf("bong!  usage:  due inter name\n");
			continue;
		}
		if (x < 5)
			strcpy(name, "default");
		if (x < 4)
			inter = evConsTimeV(0,0);
		if (!(c = malloc(sizeof *c))) {
			printf("out of memory?\n");
			exit(1);
		}
		c->name = strdup(name);
		x = evSetTimer(ev, myTimerFunc, c,
			       evAddTimeV(due, now), inter,
			       &c->id);
		printf("---> %d\n", x);
	}
	evMainLoop(ev);
	perror("evMainLoop");
	evClose(ev);
	exit(0);
	/*NOTREACHED*/
}

#ifdef NEED_STRDUP
static char *
strdup(char *str) {
	char *x = malloc(strlen(str) + 1);

	return (strcpy(x, str));
}
#endif
