/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.jansi;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Properties;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiColors;
import org.fusesource.jansi.AnsiConsole;
import org.fusesource.jansi.AnsiMode;
import org.fusesource.jansi.AnsiType;
import org.fusesource.jansi.internal.CLibrary;
import org.fusesource.jansi.internal.JansiLoader;

public class AnsiMain {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void main(String ... args) throws IOException {
        System.out.println("Jansi " + AnsiMain.getJansiVersion());
        System.out.println();
        System.out.println("library.jansi.path= " + System.getProperty("library.jansi.path", ""));
        System.out.println("library.jansi.version= " + System.getProperty("library.jansi.version", ""));
        boolean loaded = JansiLoader.initialize();
        if (loaded) {
            System.out.println("Jansi native library loaded from " + JansiLoader.getNativeLibraryPath());
            if (JansiLoader.getNativeLibrarySourceUrl() != null) {
                System.out.println("   which was auto-extracted from " + JansiLoader.getNativeLibrarySourceUrl());
            }
        } else {
            Enum[] prev = System.getProperty("jansi.graceful");
            try {
                System.setProperty("jansi.graceful", "false");
                JansiLoader.initialize();
            }
            catch (Throwable e2) {
                e2.printStackTrace(System.out);
            }
            finally {
                if (prev != null) {
                    System.setProperty("jansi.graceful", (String)prev);
                } else {
                    System.clearProperty("jansi.graceful");
                }
            }
        }
        System.out.println();
        System.out.println("os.name= " + System.getProperty("os.name") + ", os.version= " + System.getProperty("os.version") + ", os.arch= " + System.getProperty("os.arch"));
        System.out.println("file.encoding= " + System.getProperty("file.encoding"));
        System.out.println("java.version= " + System.getProperty("java.version") + ", java.vendor= " + System.getProperty("java.vendor") + ", java.home= " + System.getProperty("java.home"));
        System.out.println();
        System.out.println("jansi.graceful= " + System.getProperty("jansi.graceful", ""));
        System.out.println("jansi.mode= " + System.getProperty("jansi.mode", ""));
        System.out.println("jansi.out.mode= " + System.getProperty("jansi.out.mode", ""));
        System.out.println("jansi.err.mode= " + System.getProperty("jansi.err.mode", ""));
        System.out.println("jansi.colors= " + System.getProperty("jansi.colors", ""));
        System.out.println("jansi.out.colors= " + System.getProperty("jansi.out.colors", ""));
        System.out.println("jansi.err.colors= " + System.getProperty("jansi.err.colors", ""));
        System.out.println("jansi.passthrough= " + AnsiConsole.getBoolean("jansi.passthrough"));
        System.out.println("jansi.strip= " + AnsiConsole.getBoolean("jansi.strip"));
        System.out.println("jansi.force= " + AnsiConsole.getBoolean("jansi.force"));
        System.out.println("jansi.noreset= " + AnsiConsole.getBoolean("jansi.noreset"));
        System.out.println(Ansi.DISABLE + "= " + AnsiConsole.getBoolean(Ansi.DISABLE));
        System.out.println();
        System.out.println("IS_WINDOWS: " + AnsiConsole.IS_WINDOWS);
        if (AnsiConsole.IS_WINDOWS) {
            System.out.println("IS_CONEMU: " + AnsiConsole.IS_CONEMU);
            System.out.println("IS_CYGWIN: " + AnsiConsole.IS_CYGWIN);
            System.out.println("IS_MSYSTEM: " + AnsiConsole.IS_MSYSTEM);
        }
        System.out.println();
        AnsiMain.diagnoseTty(false);
        AnsiMain.diagnoseTty(true);
        AnsiConsole.systemInstall();
        System.out.println();
        System.out.println("Resulting Jansi modes for stout/stderr streams:");
        System.out.println("  - System.out: " + AnsiConsole.out().toString());
        System.out.println("  - System.err: " + AnsiConsole.err().toString());
        System.out.println("Processor types description:");
        for (AnsiType ansiType : AnsiType.values()) {
            System.out.println("  - " + (Object)((Object)ansiType) + ": " + ansiType.getDescription());
        }
        System.out.println("Colors support description:");
        for (Enum enum_ : AnsiColors.values()) {
            System.out.println("  - " + enum_ + ": " + ((AnsiColors)enum_).getDescription());
        }
        System.out.println("Modes description:");
        for (Enum enum_ : AnsiMode.values()) {
            System.out.println("  - " + enum_ + ": " + ((AnsiMode)enum_).getDescription());
        }
        try {
            void var5_17;
            String arg;
            void var5_15;
            File f2;
            System.out.println();
            AnsiMain.testAnsi(false);
            AnsiMain.testAnsi(true);
            if (args.length == 0) {
                AnsiMain.printJansiLogoDemo();
                return;
            }
            System.out.println();
            if (args.length == 1 && (f2 = new File(args[0])).exists()) {
                System.out.println(Ansi.ansi().bold().a("\"" + args[0] + "\" content:").reset());
                AnsiMain.writeFileContent(f2);
                return;
            }
            System.out.println(Ansi.ansi().bold().a("original args:").reset());
            int i2 = 1;
            String[] stringArray = args;
            int n2 = stringArray.length;
            boolean bl = false;
            while (var5_15 < n2) {
                arg = stringArray[var5_15];
                AnsiConsole.system_out.print(i2++ + ": ");
                AnsiConsole.system_out.println(arg);
                ++var5_15;
            }
            System.out.println(Ansi.ansi().bold().a("Jansi filtered args:").reset());
            i2 = 1;
            stringArray = args;
            n2 = stringArray.length;
            boolean bl2 = false;
            while (var5_17 < n2) {
                arg = stringArray[var5_17];
                System.out.print(i2++ + ": ");
                System.out.println(arg);
                ++var5_17;
            }
        }
        finally {
            AnsiConsole.systemUninstall();
        }
    }

    private static String getJansiVersion() {
        Package p2 = AnsiMain.class.getPackage();
        return p2 == null ? null : p2.getImplementationVersion();
    }

    private static void diagnoseTty(boolean stderr) {
        int fd = stderr ? CLibrary.STDERR_FILENO : CLibrary.STDOUT_FILENO;
        int isatty = CLibrary.LOADED ? CLibrary.isatty(fd) : 0;
        System.out.println("isatty(STD" + (stderr ? "ERR" : "OUT") + "_FILENO): " + isatty + ", System." + (stderr ? "err" : "out") + " " + (isatty == 0 ? "is *NOT*" : "is") + " a terminal");
    }

    private static void testAnsi(boolean stderr) {
        int i2;
        PrintStream s2 = stderr ? System.err : System.out;
        s2.print("test on System." + (stderr ? "err" : "out") + ":");
        for (Ansi.Color c2 : Ansi.Color.values()) {
            s2.print(" " + Ansi.ansi().fg(c2) + (Object)((Object)c2) + Ansi.ansi().reset());
        }
        s2.println();
        s2.print("            bright:");
        for (Ansi.Color c2 : Ansi.Color.values()) {
            s2.print(" " + Ansi.ansi().fgBright(c2) + (Object)((Object)c2) + Ansi.ansi().reset());
        }
        s2.println();
        s2.print("              bold:");
        for (Ansi.Color c2 : Ansi.Color.values()) {
            s2.print(" " + Ansi.ansi().bold().fg(c2) + (Object)((Object)c2) + Ansi.ansi().reset());
        }
        s2.println();
        s2.print("             faint:");
        for (Ansi.Color c2 : Ansi.Color.values()) {
            s2.print(" " + Ansi.ansi().a(Ansi.Attribute.INTENSITY_FAINT).fg(c2) + (Object)((Object)c2) + Ansi.ansi().reset());
        }
        s2.println();
        s2.print("        bold+faint:");
        for (Ansi.Color c2 : Ansi.Color.values()) {
            s2.print(" " + Ansi.ansi().bold().a(Ansi.Attribute.INTENSITY_FAINT).fg(c2) + (Object)((Object)c2) + Ansi.ansi().reset());
        }
        s2.println();
        Ansi ansi = Ansi.ansi();
        ansi.a("        256 colors: ");
        for (i2 = 0; i2 < 216; ++i2) {
            if (i2 > 0 && i2 % 36 == 0) {
                ansi.reset();
                ansi.newline();
                ansi.a("                    ");
            } else if (i2 > 0 && i2 % 6 == 0) {
                ansi.reset();
                ansi.a("  ");
            }
            int a0 = i2 % 6;
            int a1 = i2 / 6 % 6;
            int a2 = i2 / 36;
            ansi.bg(16 + a0 + a2 * 6 + a1 * 36).a(' ');
        }
        ansi.reset();
        s2.println(ansi);
        ansi = Ansi.ansi();
        ansi.a("         truecolor: ");
        for (i2 = 0; i2 < 256; ++i2) {
            if (i2 > 0 && i2 % 48 == 0) {
                ansi.reset();
                ansi.newline();
                ansi.a("                    ");
            }
            int r2 = 255 - i2;
            int g2 = i2 * 2 > 255 ? 255 - 2 * i2 : 2 * i2;
            int b2 = i2;
            ansi.bgRgb(r2, g2, b2).fgRgb(255 - r2, 255 - g2, 255 - b2).a(i2 % 2 == 0 ? (char)'/' : '\\');
        }
        ansi.reset();
        s2.println(ansi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPomPropertiesVersion(String path) throws IOException {
        InputStream in = AnsiMain.class.getResourceAsStream("/META-INF/maven/" + path + "/pom.properties");
        if (in == null) {
            return null;
        }
        try {
            Properties p2 = new Properties();
            p2.load(in);
            String string = p2.getProperty("version");
            return string;
        }
        finally {
            AnsiMain.closeQuietly(in);
        }
    }

    private static void printJansiLogoDemo() throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(AnsiMain.class.getResourceAsStream("jansi.txt"), "UTF-8"));
        try {
            String l2;
            while ((l2 = in.readLine()) != null) {
                System.out.println(l2);
            }
        }
        finally {
            AnsiMain.closeQuietly(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFileContent(File f2) throws IOException {
        FileInputStream in = new FileInputStream(f2);
        try {
            byte[] buf = new byte[1024];
            int l2 = 0;
            while ((l2 = ((InputStream)in).read(buf)) >= 0) {
                System.out.write(buf, 0, l2);
            }
        }
        finally {
            AnsiMain.closeQuietly(in);
        }
    }

    private static void closeQuietly(Closeable c2) {
        try {
            c2.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
    }
}

