/*
 * Decompiled with CFR 0.152.
 */
package spock.lang;

import groovy.lang.Closure;
import org.junit.runner.RunWith;
import org.spockframework.lang.Wildcard;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.InvalidSpecException;
import org.spockframework.runtime.SpockAssertionError;
import org.spockframework.runtime.Sputnik;
import org.spockframework.runtime.UnallowedExceptionThrownError;
import org.spockframework.util.ExceptionUtil;
import spock.lang.MockingApi;

@RunWith(value=Sputnik.class)
public abstract class Specification
extends MockingApi {
    public static final Object _ = Wildcard.INSTANCE;

    public <T extends Throwable> T thrown() {
        throw new InvalidSpecException("Exception conditions are only allowed in 'then' blocks, and may not be nested inside other elements");
    }

    public <T extends Throwable> T thrown(Class<T> type) {
        throw new InvalidSpecException("Exception conditions are only allowed in 'then' blocks, and may not be nested inside other elements");
    }

    public void notThrown(Class<? extends Throwable> type) {
        Throwable thrown = this.getSpecificationContext().getThrownException();
        if (thrown == null) {
            return;
        }
        if (type.isAssignableFrom(thrown.getClass())) {
            throw new UnallowedExceptionThrownError(type, thrown);
        }
        ExceptionUtil.sneakyThrow(thrown);
    }

    public void noExceptionThrown() {
        Throwable thrown = this.getSpecificationContext().getThrownException();
        if (thrown == null) {
            return;
        }
        throw new UnallowedExceptionThrownError(null, thrown);
    }

    public <T> T old(T expression) {
        throw new InvalidSpecException("old() can only be used in a 'then' block");
    }

    public void with(Object target, Closure<?> closure) {
        if (target == null) {
            throw new SpockAssertionError("Target of 'with' block must not be null");
        }
        closure.setDelegate(target);
        closure.setResolveStrategy(1);
        GroovyRuntimeUtil.invokeClosure(closure, target);
    }

    public void with(Object target, Class<?> type, Closure closure) {
        if (target != null && !type.isInstance(target)) {
            throw new SpockAssertionError(String.format("Expected target of 'with' block to have type '%s', but got '%s'", type, target.getClass().getName()));
        }
        this.with(target, closure);
    }
}

