/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.util;

import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.common.jsdl.action.I18nActionBuilder;
import com.jgoodies.framework.util.HistoryList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class History<E>
extends Bean {
    public static final String PROPERTY_HOME = "home";
    public static final String PROPERTY_SELECTION = "selection";
    private static final String ACTION_BACK = "history.Back";
    private static final String ACTION_NEXT = "history.Next";
    private static final String ACTION_HOME = "history.Home";
    private static final int MAX_TOOLTIP_LENGTH = 60;
    private static final ResourceMap RESOURCES = Application.getResourceMap(History.class);
    private final int capacity;
    private final Action backAction;
    private final Action nextAction;
    private final Action homeAction;
    private final JPopupMenu backPopupMenu;
    private final JPopupMenu nextPopupMenu;
    private E home;
    private HistoryList<E> list;

    public History(int capacity) {
        this(capacity, ACTION_BACK, ACTION_NEXT, ACTION_HOME, RESOURCES);
    }

    public History(int capacity, String goBackActionName, String goNextActionName, String goHomeActionName, ResourceMap actionResources) {
        this.capacity = capacity;
        this.backAction = new I18nActionBuilder().handler(this::goBack).resources(actionResources).id(goBackActionName).build();
        this.nextAction = new I18nActionBuilder().handler(this::goNext).resources(actionResources).id(goNextActionName).build();
        this.homeAction = new I18nActionBuilder().handler(this::goHome).resources(actionResources).id(goHomeActionName).build();
        this.backPopupMenu = new JPopupMenu();
        this.backPopupMenu.putClientProperty("jgoodies.noIcons", Boolean.TRUE);
        this.nextPopupMenu = new JPopupMenu();
        this.nextPopupMenu.putClientProperty("jgoodies.noIcons", Boolean.TRUE);
        this.reset();
    }

    public E getHome() {
        return this.home;
    }

    public void setHome(E newHome) {
        E oldHome = this.getHome();
        this.home = newHome;
        this.firePropertyChange(PROPERTY_HOME, oldHome, newHome);
    }

    public E getSelection() {
        return this.list.getLastAdded();
    }

    public void setSelection(E newSelection) {
        E oldSelection = this.getSelection();
        if (Objects.equals(oldSelection, newSelection)) {
            return;
        }
        this.setSelection0(newSelection);
    }

    public void removeAll(E element) {
        this.list.removeAll(element);
        this.updateActions();
    }

    public void removeAndGoBack(E element) {
        this.list.removeAll(element);
        this.setSelection0(this.list.getLastAdded());
    }

    public void reset() {
        this.list = new HistoryList(this.capacity);
        this.backAction.setEnabled(false);
        this.nextAction.setEnabled(false);
        this.homeAction.setEnabled(false);
    }

    public void goBack() {
        this.setSelection0(this.list.getAndGoPrevious());
    }

    public void goNext() {
        this.setSelection0(this.list.getAndGoNext());
    }

    public void goHome() {
        this.setSelection0(this.home);
    }

    public Action getBackAction() {
        return this.backAction;
    }

    public Action getNextAction() {
        return this.nextAction;
    }

    public Action getHomeAction() {
        return this.homeAction;
    }

    public JPopupMenu getBackPopupMenu() {
        return this.backPopupMenu;
    }

    public JPopupMenu getNextPopupMenu() {
        return this.nextPopupMenu;
    }

    protected String createToolTip(E element) {
        return Strings.abbreviateCenter(element.toString(), 60);
    }

    private String getBackText() {
        E previous = this.list.getPrevious();
        return null == previous ? RESOURCES.getString("history.back", new Object[0]) : RESOURCES.getString("history.backTo", this.createToolTip(previous));
    }

    private String getNextText() {
        E next = this.list.getNext();
        return null == next ? RESOURCES.getString("history.next", new Object[0]) : RESOURCES.getString("history.nextTo", this.createToolTip(next));
    }

    private void setSelection0(E newSelection) {
        if (null == newSelection) {
            return;
        }
        this.list.add(newSelection);
        this.updateMenu(this.backPopupMenu, this.list.getBackIterator(), true);
        this.updateMenu(this.nextPopupMenu, this.list.getNextIterator(), false);
        this.updateActions();
        this.firePropertyChange(PROPERTY_SELECTION, null, newSelection);
    }

    private void updateActions() {
        E selection = this.getSelection();
        E previous = this.list.getPrevious();
        E next = this.list.getNext();
        String goBackToolTip = this.getBackText();
        String goNextToolTip = this.getNextText();
        this.backAction.putValue("ShortDescription", goBackToolTip);
        this.backAction.putValue("Name", goBackToolTip);
        this.nextAction.putValue("ShortDescription", goNextToolTip);
        this.nextAction.putValue("Name", goNextToolTip);
        this.backAction.setEnabled(previous != null);
        this.nextAction.setEnabled(next != null);
        this.homeAction.setEnabled(this.home != null && !this.home.equals(selection));
    }

    private void updateMenu(JPopupMenu menu, Iterator<E> items, boolean goBack) {
        menu.removeAll();
        int steps = 1;
        while (items.hasNext()) {
            JMenuItem menuItem = new JMenuItem(this.createToolTip(items.next()));
            menuItem.putClientProperty("noIcon", Boolean.TRUE);
            menuItem.addActionListener(new GoMenuActionListener(steps, goBack));
            menu.add(menuItem);
            ++steps;
        }
    }

    private void updateState() {
        this.updateMenu(this.backPopupMenu, this.list.getBackIterator(), true);
        this.updateMenu(this.nextPopupMenu, this.list.getNextIterator(), false);
        this.updateActions();
        this.firePropertyChange(PROPERTY_SELECTION, null, this.getSelection());
    }

    private final class GoMenuActionListener
    implements ActionListener {
        private final int steps;
        private final boolean back;

        private GoMenuActionListener(int steps, boolean back) {
            this.steps = steps;
            this.back = back;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.back) {
                History.this.list.goBack(this.steps);
            } else {
                History.this.list.goNext(this.steps);
            }
            History.this.updateState();
        }
    }
}

