/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.Task;

public class ConcatFileInputStream
extends InputStream {
    private static final int EOF = -1;
    private int currentIndex = 0;
    private boolean eof = false;
    private File[] file;
    private InputStream currentStream;
    private Task managingTask;

    public ConcatFileInputStream(File[] file) throws IOException {
        this.file = file;
        this.openFile(this.currentIndex);
    }

    public void close() throws IOException {
        this.closeCurrent();
        this.eof = true;
    }

    public int read() throws IOException {
        int result = this.readCurrent();
        if (result == -1 && !this.eof) {
            this.openFile(++this.currentIndex);
            result = this.readCurrent();
        }
        return result;
    }

    public void setManagingTask(Task task) {
        this.managingTask = task;
    }

    public void log(String message, int loglevel) {
        if (this.managingTask != null) {
            this.managingTask.log(message, loglevel);
        } else if (loglevel > 1) {
            System.out.println(message);
        } else {
            System.err.println(message);
        }
    }

    private int readCurrent() throws IOException {
        return this.eof || this.currentStream == null ? -1 : this.currentStream.read();
    }

    private void openFile(int index) throws IOException {
        this.closeCurrent();
        if (this.file != null && index < this.file.length) {
            this.log("Opening " + this.file[index], 3);
            this.currentStream = new BufferedInputStream(new FileInputStream(this.file[index]));
        } else {
            this.eof = true;
        }
    }

    private void closeCurrent() {
        if (this.currentStream != null) {
            try {
                this.currentStream.close();
            }
            catch (IOException eyeOhEx) {
                // empty catch block
            }
            this.currentStream = null;
        }
    }
}

