/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.declarations;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.instrumentation.api.annotations.CallableKind;
import org.gradle.internal.instrumentation.api.annotations.InterceptCalls;
import org.gradle.internal.instrumentation.api.annotations.ParameterKind;
import org.gradle.internal.instrumentation.api.annotations.SpecificGroovyCallInterceptors;
import org.gradle.internal.instrumentation.api.annotations.SpecificJvmCallInterceptors;

@SpecificJvmCallInterceptors(generatedClassName="org.gradle.internal.classpath.generated.InterceptorDeclaration_ConfigCacheJvmBytecode")
@SpecificGroovyCallInterceptors(generatedClassName="org.gradle.internal.classpath.generated.InterceptorDeclaration_ConfigCacheGroovyInterceptors")
public class FileInterceptorsDeclaration {
    @InterceptCalls
    @CallableKind.InstanceMethod
    public static File[] intercept_listFiles(@ParameterKind.Receiver File thisFile, @ParameterKind.CallerClassName String consumer) {
        return Instrumented.fileListFiles(thisFile, consumer);
    }

    @InterceptCalls
    @CallableKind.InstanceMethod
    public static File[] intercept_listFiles(@ParameterKind.Receiver File thisFile, FileFilter fileFilter, @ParameterKind.CallerClassName String consumer) {
        return Instrumented.fileListFiles(thisFile, fileFilter, consumer);
    }

    @InterceptCalls
    @CallableKind.InstanceMethod
    public static File[] intercept_listFiles(@ParameterKind.Receiver File thisFile, FilenameFilter fileFilter, @ParameterKind.CallerClassName String consumer) {
        return Instrumented.fileListFiles(thisFile, fileFilter, consumer);
    }

    @InterceptCalls
    @CallableKind.InstanceMethod
    public static boolean intercept_exists(@ParameterKind.Receiver File thisFile, @ParameterKind.CallerClassName String consumer) {
        return Instrumented.fileExists(thisFile, consumer);
    }

    @InterceptCalls
    @CallableKind.InstanceMethod
    public static boolean intercept_isFile(@ParameterKind.Receiver File thisFile, @ParameterKind.CallerClassName String consumer) {
        return Instrumented.fileIsFile(thisFile, consumer);
    }

    @InterceptCalls
    @CallableKind.InstanceMethod
    public static boolean intercept_isDirectory(@ParameterKind.Receiver File thisFile, @ParameterKind.CallerClassName String consumer) {
        return Instrumented.fileIsDirectory(thisFile, consumer);
    }

    @InterceptCalls
    @CallableKind.InstanceMethod
    public static String[] intercept_list(@ParameterKind.Receiver File thisFile, @ParameterKind.CallerClassName String consumer) {
        Instrumented.directoryContentObserved(thisFile, consumer);
        return thisFile.list();
    }

    @InterceptCalls
    @CallableKind.InstanceMethod
    public static String[] intercept_list(@ParameterKind.Receiver File thisFile, FilenameFilter filenameFilter, @ParameterKind.CallerClassName String consumer) {
        Instrumented.directoryContentObserved(thisFile, consumer);
        return thisFile.list(filenameFilter);
    }

    @InterceptCalls
    @CallableKind.InstanceMethod
    public static long intercept_length(@ParameterKind.Receiver File thisFile, @ParameterKind.CallerClassName String consumer) {
        Instrumented.fileOpened(thisFile, consumer);
        return thisFile.length();
    }
}

