/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.ForNode;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableNode;
import guru.nidi.graphviz.model.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ImmutableNode
extends MutableNode
implements Node {
    ImmutableNode(Label name) {
        this(name, new ArrayList<Link>(), Attributes.attrs());
    }

    private ImmutableNode(Label name, List<Link> links, Attributes<? extends ForNode> attributes) {
        super(name, links, attributes);
    }

    public ImmutableNode link(LinkTarget target) {
        return (ImmutableNode)this.copyOfMut().addLink(target);
    }

    @Override
    public ImmutableNode link(LinkTarget ... targets) {
        return (ImmutableNode)this.copyOfMut().addLink(targets);
    }

    @Override
    public ImmutableNode link(List<? extends LinkTarget> targets) {
        return (ImmutableNode)this.copyOfMut().addLink(targets);
    }

    @Override
    public ImmutableNode link(String node) {
        return (ImmutableNode)this.copyOfMut().addLink(node);
    }

    @Override
    public ImmutableNode link(String ... nodes) {
        return (ImmutableNode)this.copyOfMut().addLink(nodes);
    }

    @Override
    public ImmutableNode with(Attributes<? extends ForNode> attrs) {
        return (ImmutableNode)this.copyOfMut().add((Attributes)attrs);
    }

    private ImmutableNode copyOfMut() {
        return new ImmutableNode(this.name, new ArrayList<Link>(this.links), this.attributes.copy());
    }

    @Override
    public List<Link> links() {
        return Collections.unmodifiableList(super.links());
    }
}

