/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import weka.core.Utils;
import weka.core.WekaException;
import weka.gui.knowledgeflow.MainKFPerspective;
import weka.gui.knowledgeflow.StepVisual;
import weka.gui.knowledgeflow.VisibleLayout;
import weka.knowledgeflow.Flow;

public class MainKFPerspectiveToolBar
extends JPanel {
    private static final long serialVersionUID = -157986423490835642L;
    public static String ICON_PATH = "weka/gui/knowledgeflow/icons/";
    protected MainKFPerspective m_mainPerspective;
    protected Map<String, JComponent> m_widgetMap = new HashMap<String, JComponent>();
    protected Map<String, JMenu> m_menuMap = new LinkedHashMap<String, JMenu>();
    protected Map<String, JMenuItem> m_menuItemMap = new HashMap<String, JMenuItem>();
    protected boolean m_showMenus;

    public MainKFPerspectiveToolBar(MainKFPerspective mainKFPerspective) {
        JMenu fileMenu = new JMenu();
        fileMenu.setText("File");
        this.m_menuMap.put("File", fileMenu);
        JMenu editMenu = new JMenu();
        editMenu.setText("Edit");
        this.m_menuMap.put("Edit", editMenu);
        JMenu insertMenu = new JMenu();
        insertMenu.setText("Insert");
        this.m_menuMap.put("Insert", insertMenu);
        JMenu viewMenu = new JMenu();
        viewMenu.setText("View");
        this.m_menuMap.put("View", viewMenu);
        this.m_mainPerspective = mainKFPerspective;
        this.setLayout(new BorderLayout());
        AbstractAction closeAction = new AbstractAction("Close"){
            private static final long serialVersionUID = 4762166880144590384L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentTabIndex() >= 0) {
                    MainKFPerspectiveToolBar.this.m_mainPerspective.removeTab(MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentTabIndex());
                }
            }
        };
        KeyStroke closeKey = KeyStroke.getKeyStroke(87, 128);
        this.m_mainPerspective.getActionMap().put("Close", closeAction);
        this.m_mainPerspective.getInputMap(2).put(closeKey, "Close");
        this.setupLeftSideToolBar();
        this.setupRightSideToolBar();
    }

    private void setupLeftSideToolBar() {
        JToolBar fixedTools2 = new JToolBar();
        fixedTools2.setOrientation(0);
        fixedTools2.setFloatable(false);
        JButton playB = new JButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "resultset_next.png").getImage()));
        playB.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        playB.setToolTipText("Run this flow (all start points launched in parallel)");
        final AbstractAction playParallelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout() != null) {
                    boolean proceed = true;
                    if (MainKFPerspectiveToolBar.this.m_mainPerspective.isMemoryLow()) {
                        proceed = MainKFPerspectiveToolBar.this.m_mainPerspective.showMemoryIsLow();
                    }
                    if (proceed) {
                        try {
                            MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().executeFlow(false);
                        }
                        catch (WekaException e1) {
                            MainKFPerspectiveToolBar.this.m_mainPerspective.showErrorDialog(e1);
                        }
                    }
                }
            }
        };
        playB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                playParallelAction.actionPerformed(e);
            }
        });
        JButton playBB = new JButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "resultset_last.png").getImage()));
        playBB.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        playBB.setToolTipText("Run this flow (start points launched sequentially)");
        final AbstractAction playSequentialAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout() != null) {
                    if (!Utils.getDontShowDialog("weka.gui.knowledgeflow.SequentialRunInfo")) {
                        JCheckBox dontShow = new JCheckBox("Do not show this message again");
                        Object[] stuff = new Object[]{"The order that data sources are launched in can be\nspecified by setting a custom name for each data source that\nthat includes a number. E.g. \"1:MyArffLoader\". To set a name,\nright-click over a data source and select \"Set name\"\n\nIf the prefix is not specified, then the order of execution\nwill correspond to the order that the components were added\nto the layout. Note that it is also possible to prevent a data\nsource from executing by prefixing its name with a \"!\". E.g\n\"!:MyArffLoader\"", dontShow};
                        JOptionPane.showMessageDialog(MainKFPerspectiveToolBar.this.m_mainPerspective, stuff, "Sequential execution information", 0);
                        if (dontShow.isSelected()) {
                            try {
                                Utils.setDontShowDialog("weka.gui.knowledgeFlow.SequentialRunInfo");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    boolean proceed = true;
                    if (MainKFPerspectiveToolBar.this.m_mainPerspective.isMemoryLow()) {
                        proceed = MainKFPerspectiveToolBar.this.m_mainPerspective.showMemoryIsLow();
                    }
                    if (proceed) {
                        try {
                            MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().executeFlow(true);
                        }
                        catch (WekaException e1) {
                            MainKFPerspectiveToolBar.this.m_mainPerspective.showErrorDialog(e1);
                        }
                    }
                }
            }
        };
        playBB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                playSequentialAction.actionPerformed(e);
            }
        });
        JButton stopB = new JButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "shape_square.png").getImage()));
        stopB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        stopB.setToolTipText("Stop all execution");
        final AbstractAction stopAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout() != null) {
                    MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().getLogPanel().statusMessage("@!@[KnowledgeFlow]|Attempting to stop all components...");
                    MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().stopFlow();
                    MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().getLogPanel().statusMessage("@!@[KnowledgeFlow]|OK.");
                }
            }
        };
        stopB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                stopAction.actionPerformed(e);
            }
        });
        JButton pointerB = new JButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "cursor.png").getImage()));
        pointerB.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        pointerB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainKFPerspectiveToolBar.this.m_mainPerspective.setPalleteSelectedStep(null);
                MainKFPerspectiveToolBar.this.m_mainPerspective.setCursor(Cursor.getPredefinedCursor(0));
                MainKFPerspectiveToolBar.this.m_mainPerspective.clearDesignPaletteSelection();
                if (MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout() != null) {
                    MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().setFlowLayoutOperation(VisibleLayout.LayoutOperation.NONE);
                }
            }
        });
        this.addWidgetToToolBar(fixedTools2, Widgets.POINTER_BUTTON.toString(), pointerB);
        this.addWidgetToToolBar(fixedTools2, Widgets.PLAY_PARALLEL_BUTTON.toString(), playB);
        this.addWidgetToToolBar(fixedTools2, Widgets.PLAY_SEQUENTIAL_BUTTON.toString(), playBB);
        this.addWidgetToToolBar(fixedTools2, Widgets.STOP_BUTTON.toString(), stopB);
        Dimension d = playB.getPreferredSize();
        Dimension d2 = fixedTools2.getMinimumSize();
        Dimension d3 = new Dimension(d2.width, d.height + 4);
        fixedTools2.setPreferredSize(d3);
        fixedTools2.setMaximumSize(d3);
        this.add((Component)fixedTools2, "West");
    }

    private void setupRightSideToolBar() {
        JToolBar fixedTools = new JToolBar();
        fixedTools.setOrientation(0);
        JButton cutB = new JButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "cut.png").getImage()));
        cutB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        cutB.setToolTipText("Cut selected (Ctrl+X)");
        JButton copyB = new JButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "page_copy.png").getImage()));
        copyB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        copyB.setToolTipText("Copy selected (Ctrl+C)");
        JButton pasteB = new JButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "paste_plain.png").getImage()));
        pasteB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        pasteB.setToolTipText("Paste from clipboard (Ctrl+V)");
        JButton deleteB = new JButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "delete.png").getImage()));
        deleteB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        deleteB.setToolTipText("Delete selected (DEL)");
        final JToggleButton snapToGridB = new JToggleButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "shape_handles.png").getImage()));
        snapToGridB.setToolTipText("Snap to grid (Ctrl+G)");
        JButton saveB = new JButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "disk.png").getImage()));
        saveB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        saveB.setToolTipText("Save layout (Ctrl+S)");
        JButton saveBB = new JButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "disk_multiple.png").getImage()));
        saveBB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        saveBB.setToolTipText("Save layout with new name");
        JButton loadB = new JButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "folder_add.png").getImage()));
        loadB.setToolTipText("Open (Ctrl+O)");
        loadB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        JButton newB = new JButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "page_add.png").getImage()));
        newB.setToolTipText("New layout (Ctrl+N)");
        newB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        newB.setEnabled(this.m_mainPerspective.getAllowMultipleTabs());
        final JButton helpB = new JButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "help.png").getImage()));
        helpB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        helpB.setToolTipText("Display help (Ctrl+H)");
        JButton togglePerspectivesB = new JButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "cog_go.png").getImage()));
        togglePerspectivesB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        togglePerspectivesB.setToolTipText("Show/hide perspectives toolbar (Ctrl+P)");
        final JButton templatesB = new JButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "application_view_tile.png").getImage()));
        templatesB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        templatesB.setToolTipText("Load a template layout");
        JButton noteB = new JButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "note_add.png").getImage()));
        noteB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        noteB.setToolTipText("Add a note to the layout (Ctrl+I)");
        JButton selectAllB = new JButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "shape_group.png").getImage()));
        selectAllB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        selectAllB.setToolTipText("Select all (Ctrl+A)");
        final JButton zoomInB = new JButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "zoom_in.png").getImage()));
        zoomInB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        zoomInB.setToolTipText("Zoom in (Ctrl++)");
        final JButton zoomOutB = new JButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "zoom_out.png").getImage()));
        zoomOutB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        zoomOutB.setToolTipText("Zoom out (Ctrl+-)");
        JButton undoB = new JButton(new ImageIcon(StepVisual.loadIcon(ICON_PATH + "arrow_undo.png").getImage()));
        undoB.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        undoB.setToolTipText("Undo (Ctrl+U)");
        final AbstractAction saveAction = new AbstractAction("Save"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentTabIndex() >= 0) {
                    MainKFPerspectiveToolBar.this.m_mainPerspective.saveLayout(MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentTabIndex(), false);
                }
            }
        };
        KeyStroke saveKey = KeyStroke.getKeyStroke(83, 128);
        this.m_mainPerspective.getActionMap().put("Save", saveAction);
        this.m_mainPerspective.getInputMap(2).put(saveKey, "Save");
        saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                saveAction.actionPerformed(e);
            }
        });
        KeyStroke saveAsKey = KeyStroke.getKeyStroke(89, 128);
        final AbstractAction saveAsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainKFPerspectiveToolBar.this.m_mainPerspective.saveLayout(MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentTabIndex(), true);
            }
        };
        this.m_mainPerspective.getActionMap().put("SaveAS", saveAsAction);
        this.m_mainPerspective.getInputMap(2).put(saveAsKey, "SaveAS");
        saveBB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                saveAsAction.actionPerformed(e);
            }
        });
        final AbstractAction openAction = new AbstractAction("Open"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainKFPerspectiveToolBar.this.m_mainPerspective.loadLayout();
            }
        };
        KeyStroke openKey = KeyStroke.getKeyStroke(79, 128);
        this.m_mainPerspective.getActionMap().put("Open", openAction);
        this.m_mainPerspective.getInputMap(2).put(openKey, "Open");
        loadB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                openAction.actionPerformed(e);
            }
        });
        final AbstractAction newAction = new AbstractAction("New"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainKFPerspectiveToolBar.this.m_mainPerspective.addUntitledTab();
            }
        };
        KeyStroke newKey = KeyStroke.getKeyStroke(78, 128);
        this.m_mainPerspective.getActionMap().put("New", newAction);
        this.m_mainPerspective.getInputMap(2).put(newKey, "New");
        newB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                newAction.actionPerformed(ae);
            }
        });
        final AbstractAction selectAllAction = new AbstractAction("SelectAll"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout() != null && MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().numSteps() > 0) {
                    ArrayList<StepVisual> newSelected = new ArrayList<StepVisual>();
                    newSelected.addAll(MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().getRenderGraph());
                    if (newSelected.size() == MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().getSelectedSteps().size()) {
                        MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().setSelectedSteps(new ArrayList<StepVisual>());
                    } else {
                        MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().setSelectedSteps(newSelected);
                    }
                    MainKFPerspectiveToolBar.this.m_mainPerspective.revalidate();
                    MainKFPerspectiveToolBar.this.m_mainPerspective.repaint();
                    MainKFPerspectiveToolBar.this.m_mainPerspective.notifyIsDirty();
                }
            }
        };
        KeyStroke selectAllKey = KeyStroke.getKeyStroke(65, 128);
        this.m_mainPerspective.getActionMap().put("SelectAll", selectAllAction);
        this.m_mainPerspective.getInputMap(2).put(selectAllKey, "SelectAll");
        selectAllB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectAllAction.actionPerformed(e);
            }
        });
        final AbstractAction zoomInAction = new AbstractAction("ZoomIn"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout() != null) {
                    int z = MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().getZoomSetting();
                    zoomOutB.setEnabled(true);
                    if ((z += 25) >= 200) {
                        z = 200;
                        zoomInB.setEnabled(false);
                    }
                    MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().setZoomSetting(z);
                    MainKFPerspectiveToolBar.this.m_mainPerspective.revalidate();
                    MainKFPerspectiveToolBar.this.m_mainPerspective.repaint();
                    MainKFPerspectiveToolBar.this.m_mainPerspective.notifyIsDirty();
                }
            }
        };
        KeyStroke zoomInKey = KeyStroke.getKeyStroke(61, 128);
        this.m_mainPerspective.getActionMap().put("ZoomIn", zoomInAction);
        this.m_mainPerspective.getInputMap(2).put(zoomInKey, "ZoomIn");
        zoomInB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                zoomInAction.actionPerformed(e);
            }
        });
        final AbstractAction zoomOutAction = new AbstractAction("ZoomOut"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout() != null) {
                    int z = MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().getZoomSetting();
                    zoomInB.setEnabled(true);
                    if ((z -= 25) <= 50) {
                        z = 50;
                        zoomOutB.setEnabled(false);
                    }
                    MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().setZoomSetting(z);
                    MainKFPerspectiveToolBar.this.m_mainPerspective.revalidate();
                    MainKFPerspectiveToolBar.this.m_mainPerspective.repaint();
                    MainKFPerspectiveToolBar.this.m_mainPerspective.notifyIsDirty();
                }
            }
        };
        KeyStroke zoomOutKey = KeyStroke.getKeyStroke(45, 128);
        this.m_mainPerspective.getActionMap().put("ZoomOut", zoomOutAction);
        this.m_mainPerspective.getInputMap(2).put(zoomOutKey, "ZoomOut");
        zoomOutB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                zoomOutAction.actionPerformed(e);
            }
        });
        final AbstractAction cutAction = new AbstractAction("Cut"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout() != null && MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().getSelectedSteps().size() > 0) {
                    try {
                        MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().copySelectedStepsToClipboard();
                        MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().removeSelectedSteps();
                    }
                    catch (WekaException e1) {
                        MainKFPerspectiveToolBar.this.m_mainPerspective.showErrorDialog(e1);
                    }
                }
            }
        };
        KeyStroke cutKey = KeyStroke.getKeyStroke(88, 128);
        this.m_mainPerspective.getActionMap().put("Cut", cutAction);
        this.m_mainPerspective.getInputMap(2).put(cutKey, "Cut");
        cutB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cutAction.actionPerformed(e);
            }
        });
        final AbstractAction deleteAction = new AbstractAction("Delete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout() != null) {
                    try {
                        MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().removeSelectedSteps();
                    }
                    catch (WekaException e1) {
                        MainKFPerspectiveToolBar.this.m_mainPerspective.showErrorDialog(e1);
                    }
                }
            }
        };
        KeyStroke deleteKey = KeyStroke.getKeyStroke(127, 0);
        this.m_mainPerspective.getActionMap().put("Delete", deleteAction);
        this.m_mainPerspective.getInputMap(2).put(deleteKey, "Delete");
        deleteB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                deleteAction.actionPerformed(e);
            }
        });
        final AbstractAction copyAction = new AbstractAction("Copy"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout() != null && MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().getSelectedSteps().size() > 0) {
                    try {
                        MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().copySelectedStepsToClipboard();
                        MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().setSelectedSteps(new ArrayList<StepVisual>());
                    }
                    catch (WekaException e1) {
                        MainKFPerspectiveToolBar.this.m_mainPerspective.showErrorDialog(e1);
                    }
                }
            }
        };
        KeyStroke copyKey = KeyStroke.getKeyStroke(67, 128);
        this.m_mainPerspective.getActionMap().put("Copy", copyAction);
        this.m_mainPerspective.getInputMap(2).put(copyKey, "Copy");
        copyB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                copyAction.actionPerformed(e);
            }
        });
        final AbstractAction pasteAction = new AbstractAction("Paste"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout() != null && MainKFPerspectiveToolBar.this.m_mainPerspective.getPasteBuffer().length() > 0) {
                    MainKFPerspectiveToolBar.this.m_mainPerspective.setCursor(Cursor.getPredefinedCursor(1));
                    MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().setFlowLayoutOperation(VisibleLayout.LayoutOperation.PASTING);
                }
            }
        };
        KeyStroke pasteKey = KeyStroke.getKeyStroke(86, 128);
        this.m_mainPerspective.getActionMap().put("Paste", pasteAction);
        this.m_mainPerspective.getInputMap(2).put(pasteKey, "Paste");
        pasteB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pasteAction.actionPerformed(e);
            }
        });
        final AbstractAction snapAction = new AbstractAction("Snap"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (snapToGridB.isSelected() && MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout() != null) {
                    MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().snapSelectedToGrid();
                }
            }
        };
        KeyStroke snapKey = KeyStroke.getKeyStroke(71, 128);
        this.m_mainPerspective.getActionMap().put("Snap", snapAction);
        this.m_mainPerspective.getInputMap(2).put(snapKey, "Snap");
        snapToGridB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (snapToGridB.isSelected()) {
                    snapAction.actionPerformed(e);
                }
            }
        });
        final AbstractAction noteAction = new AbstractAction("Note"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout() != null) {
                    MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().initiateAddNote();
                }
            }
        };
        KeyStroke noteKey = KeyStroke.getKeyStroke(73, 128);
        this.m_mainPerspective.getActionMap().put("Note", noteAction);
        this.m_mainPerspective.getInputMap(2).put(noteKey, "Note");
        noteB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                noteAction.actionPerformed(e);
            }
        });
        final AbstractAction undoAction = new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout() != null) {
                    MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().popAndLoadUndo();
                }
            }
        };
        KeyStroke undoKey = KeyStroke.getKeyStroke(85, 128);
        this.m_mainPerspective.getActionMap().put("Undo", undoAction);
        this.m_mainPerspective.getInputMap(2).put(undoKey, "Undo");
        undoB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                undoAction.actionPerformed(e);
            }
        });
        final AbstractAction helpAction = new AbstractAction("Help"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainKFPerspectiveToolBar.this.popupHelp(helpB);
            }
        };
        KeyStroke helpKey = KeyStroke.getKeyStroke(72, 128);
        this.m_mainPerspective.getActionMap().put("Help", helpAction);
        this.m_mainPerspective.getInputMap(2).put(helpKey, "Help");
        helpB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                helpAction.actionPerformed(ae);
            }
        });
        templatesB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem menuItem;
                JPopupMenu popupMenu = new JPopupMenu();
                List<String> builtinTemplates = MainKFPerspectiveToolBar.this.m_mainPerspective.getTemplateManager().getBuiltinTemplateDescriptions();
                List<String> pluginTemplates = MainKFPerspectiveToolBar.this.m_mainPerspective.getTemplateManager().getPluginTemplateDescriptions();
                for (final String desc : builtinTemplates) {
                    menuItem = new JMenuItem(desc);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                Flow templateFlow = MainKFPerspectiveToolBar.this.m_mainPerspective.getTemplateManager().getTemplateFlow(desc);
                                MainKFPerspectiveToolBar.this.m_mainPerspective.addTab(desc);
                                MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().setFlow(templateFlow);
                            }
                            catch (WekaException ex) {
                                MainKFPerspectiveToolBar.this.m_mainPerspective.showErrorDialog(ex);
                            }
                        }
                    });
                    popupMenu.add(menuItem);
                }
                if (builtinTemplates.size() > 0 && pluginTemplates.size() > 0) {
                    popupMenu.addSeparator();
                }
                for (final String desc : pluginTemplates) {
                    menuItem = new JMenuItem(desc);
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                Flow templateFlow = MainKFPerspectiveToolBar.this.m_mainPerspective.getTemplateManager().getTemplateFlow(desc);
                                MainKFPerspectiveToolBar.this.m_mainPerspective.addTab(desc);
                                MainKFPerspectiveToolBar.this.m_mainPerspective.getCurrentLayout().setFlow(templateFlow);
                            }
                            catch (WekaException ex) {
                                MainKFPerspectiveToolBar.this.m_mainPerspective.showErrorDialog(ex);
                            }
                        }
                    });
                    popupMenu.add(menuItem);
                }
                templatesB.add(popupMenu);
                popupMenu.show(templatesB, 0, 0);
            }
        });
        templatesB.setEnabled(this.m_mainPerspective.getTemplateManager().numTemplates() > 0);
        final AbstractAction togglePerspectivesAction = new AbstractAction("Toggle perspectives"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Utils.getDontShowDialog("weka.gui.knowledgeflow.PerspectiveInfo")) {
                    JCheckBox dontShow = new JCheckBox("Do not show this message again");
                    Object[] stuff = new Object[]{"Perspectives are environments that take over the\nKnowledge Flow UI and provide major additional functionality.\nMany perspectives will operate on a set of instances. Instances\nCan be sent to a perspective by placing a DataSource on the\nlayout canvas, configuring it and then selecting \"Send to perspective\"\nfrom the contextual popup menu that appears when you right-click on\nit. Several perspectives are built in to the Knowledge Flow, others\ncan be installed via the package manager.\n", dontShow};
                    JOptionPane.showMessageDialog(MainKFPerspectiveToolBar.this.m_mainPerspective, stuff, "Perspective information", 0);
                    if (dontShow.isSelected()) {
                        try {
                            Utils.setDontShowDialog("weka.gui.Knowledgeflow.PerspectiveInfo");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (MainKFPerspectiveToolBar.this.m_mainPerspective.getMainApplication().isPerspectivesToolBarVisible()) {
                    MainKFPerspectiveToolBar.this.m_mainPerspective.getMainApplication().hidePerspectivesToolBar();
                } else {
                    MainKFPerspectiveToolBar.this.m_mainPerspective.getMainApplication().showPerspectivesToolBar();
                }
                MainKFPerspectiveToolBar.this.m_mainPerspective.revalidate();
                MainKFPerspectiveToolBar.this.m_mainPerspective.notifyIsDirty();
            }
        };
        KeyStroke togglePerspectivesKey = KeyStroke.getKeyStroke(80, 128);
        this.m_mainPerspective.getActionMap().put("Toggle perspectives", togglePerspectivesAction);
        this.m_mainPerspective.getInputMap(2).put(togglePerspectivesKey, "Toggle perspectives");
        togglePerspectivesB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                togglePerspectivesAction.actionPerformed(e);
            }
        });
        this.addWidgetToToolBar(fixedTools, Widgets.ZOOM_IN_BUTTON.toString(), zoomInB);
        this.addMenuItemToMenu("View", Widgets.ZOOM_IN_BUTTON.toString(), zoomInAction, zoomInKey);
        this.addWidgetToToolBar(fixedTools, Widgets.ZOOM_OUT_BUTTON.toString(), zoomOutB);
        this.addMenuItemToMenu("View", Widgets.ZOOM_OUT_BUTTON.toString(), zoomOutAction, zoomOutKey);
        fixedTools.addSeparator();
        this.addWidgetToToolBar(fixedTools, Widgets.SELECT_ALL_BUTTON.toString(), selectAllB);
        this.addWidgetToToolBar(fixedTools, Widgets.CUT_BUTTON.toString(), cutB);
        this.addMenuItemToMenu("Edit", Widgets.CUT_BUTTON.toString(), cutAction, cutKey);
        this.addWidgetToToolBar(fixedTools, Widgets.COPY_BUTTON.toString(), copyB);
        this.addMenuItemToMenu("Edit", Widgets.COPY_BUTTON.toString(), copyAction, copyKey);
        this.addMenuItemToMenu("Edit", Widgets.PASTE_BUTTON.toString(), pasteAction, pasteKey);
        this.addWidgetToToolBar(fixedTools, Widgets.DELETE_BUTTON.toString(), deleteB);
        this.addMenuItemToMenu("Edit", Widgets.DELETE_BUTTON.toString(), deleteAction, deleteKey);
        this.addWidgetToToolBar(fixedTools, Widgets.PASTE_BUTTON.toString(), pasteB);
        this.addWidgetToToolBar(fixedTools, Widgets.UNDO_BUTTON.toString(), undoB);
        this.addMenuItemToMenu("Edit", Widgets.UNDO_BUTTON.toString(), undoAction, undoKey);
        this.addWidgetToToolBar(fixedTools, Widgets.NOTE_BUTTON.toString(), noteB);
        this.addMenuItemToMenu("Insert", Widgets.NOTE_BUTTON.toString(), noteAction, noteKey);
        fixedTools.addSeparator();
        this.addWidgetToToolBar(fixedTools, Widgets.SNAP_TO_GRID_BUTTON.toString(), snapToGridB);
        fixedTools.addSeparator();
        this.addWidgetToToolBar(fixedTools, Widgets.NEW_FLOW_BUTTON.toString(), newB);
        this.addMenuItemToMenu("File", Widgets.NEW_FLOW_BUTTON.toString(), newAction, newKey);
        this.addWidgetToToolBar(fixedTools, Widgets.SAVE_FLOW_BUTTON.toString(), saveB);
        this.addMenuItemToMenu("File", Widgets.LOAD_FLOW_BUTTON.toString(), openAction, openKey);
        this.addMenuItemToMenu("File", Widgets.SAVE_FLOW_BUTTON.toString(), saveAction, saveKey);
        this.addWidgetToToolBar(fixedTools, Widgets.SAVE_FLOW_AS_BUTTON.toString(), saveBB);
        this.addMenuItemToMenu("File", Widgets.SAVE_FLOW_AS_BUTTON.toString(), saveAction, saveAsKey);
        this.addWidgetToToolBar(fixedTools, Widgets.LOAD_FLOW_BUTTON.toString(), loadB);
        this.addWidgetToToolBar(fixedTools, Widgets.TEMPLATES_BUTTON.toString(), templatesB);
        fixedTools.addSeparator();
        this.addWidgetToToolBar(fixedTools, Widgets.TOGGLE_PERSPECTIVES_BUTTON.toString(), togglePerspectivesB);
        this.addWidgetToToolBar(fixedTools, Widgets.HELP_BUTTON.toString(), helpB);
        Dimension d = undoB.getPreferredSize();
        Dimension d2 = fixedTools.getMinimumSize();
        Dimension d3 = new Dimension(d2.width, d.height + 4);
        fixedTools.setPreferredSize(d3);
        fixedTools.setMaximumSize(d3);
        fixedTools.setFloatable(false);
        this.add((Component)fixedTools, "East");
    }

    protected void addWidgetToToolBar(JToolBar toolBar, String widgetName, JComponent widget) {
        toolBar.add(widget);
        this.m_widgetMap.put(widgetName, widget);
    }

    protected void addMenuItemToMenu(String topMenu, String menuItem, final Action action, KeyStroke accelerator) {
        JMenuItem newItem = this.m_menuItemMap.get(menuItem);
        if (newItem != null) {
            throw new IllegalArgumentException("The menu item '" + menuItem + "' already exists!");
        }
        newItem = new JMenuItem(menuItem);
        if (accelerator != null) {
            newItem.setAccelerator(accelerator);
        }
        newItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                action.actionPerformed(e);
            }
        });
        JMenu topJ = this.m_menuMap.get(topMenu);
        if (topJ == null) {
            topJ = new JMenu();
            topJ.setText(topMenu);
            this.m_menuMap.put(topMenu, topJ);
        }
        topJ.add(newItem);
        this.m_menuItemMap.put(menuItem, newItem);
    }

    public void enableWidget(String widgetName, boolean enable) {
        JMenuItem mI;
        JComponent widget = this.m_widgetMap.get(widgetName);
        if (widget != null) {
            widget.setEnabled(enable);
        }
        if ((mI = this.m_menuItemMap.get(widgetName)) != null) {
            mI.setEnabled(enable);
        }
    }

    public void enableWidgets(String ... widgetNames) {
        for (String s : widgetNames) {
            this.enableWidget(s, true);
        }
    }

    public void disableWidgets(String ... widgetNames) {
        for (String s : widgetNames) {
            this.enableWidget(s, false);
        }
    }

    private void popupHelp(final JButton helpB) {
        try {
            String line;
            helpB.setEnabled(false);
            InputStream inR = this.getClass().getClassLoader().getResourceAsStream("weka/gui/knowledgeflow/README_KnowledgeFlow");
            StringBuilder helpHolder = new StringBuilder();
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(inR));
            while ((line = lnr.readLine()) != null) {
                helpHolder.append(line + "\n");
            }
            lnr.close();
            final JFrame jf = new JFrame();
            jf.getContentPane().setLayout(new BorderLayout());
            JTextArea ta = new JTextArea(helpHolder.toString());
            ta.setFont(new Font("Monospaced", 0, 12));
            ta.setEditable(false);
            JScrollPane sp = new JScrollPane(ta);
            jf.getContentPane().add((Component)sp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    helpB.setEnabled(true);
                    jf.dispose();
                }
            });
            jf.setSize(600, 600);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            helpB.setEnabled(true);
        }
    }

    public JComponent getWidget(String widgetName) {
        return this.m_widgetMap.get(widgetName);
    }

    public JMenuItem getMenuItem(String menuItemName) {
        return this.m_menuItemMap.get(menuItemName);
    }

    public List<JMenu> getMenus() {
        ArrayList<JMenu> menuList = new ArrayList<JMenu>();
        for (Map.Entry<String, JMenu> e : this.m_menuMap.entrySet()) {
            menuList.add(e.getValue());
        }
        return menuList;
    }

    public static enum Widgets {
        ZOOM_IN_BUTTON("Zoom In"),
        ZOOM_OUT_BUTTON("Zoom Out"),
        SELECT_ALL_BUTTON("Select All"),
        CUT_BUTTON("Cut"),
        COPY_BUTTON("Copy"),
        DELETE_BUTTON("Delete"),
        PASTE_BUTTON("Paste"),
        UNDO_BUTTON("Undo"),
        NOTE_BUTTON("New Note"),
        SNAP_TO_GRID_BUTTON("Snap to Grid"),
        NEW_FLOW_BUTTON("New Layout"),
        SAVE_FLOW_BUTTON("Save"),
        SAVE_FLOW_AS_BUTTON("Save As..."),
        LOAD_FLOW_BUTTON("Open..."),
        TEMPLATES_BUTTON("Template"),
        TOGGLE_PERSPECTIVES_BUTTON("Toggle Perspectives"),
        HELP_BUTTON("help..."),
        POINTER_BUTTON("Pointer"),
        PLAY_PARALLEL_BUTTON("Launch"),
        PLAY_SEQUENTIAL_BUTTON("Launch Squential"),
        STOP_BUTTON("Stop");

        String m_name;

        private Widgets(String name) {
            this.m_name = name;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

