/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.configuration.ImportsReader;

public class DefaultImportsReader
implements ImportsReader {
    public static final String RESOURCE = "/default-imports.txt";
    private static final String MAPPING_RESOURCE = "/api-mapping.txt";
    private final String[] importPackages;
    private final Map<String, List<String>> simpleNameToFQCN;

    public DefaultImportsReader() {
        this(DefaultImportsReader.class.getResource(RESOURCE));
    }

    public DefaultImportsReader(URL url) {
        try {
            this.importPackages = DefaultImportsReader.generateImportPackages(url);
            this.simpleNameToFQCN = DefaultImportsReader.generateSimpleNameToFQCN();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    @Override
    public String[] getImportPackages() {
        return this.importPackages;
    }

    @Override
    public Map<String, List<String>> getSimpleNameToFullClassNamesMapping() {
        return this.simpleNameToFQCN;
    }

    private static String[] generateImportPackages(URL url) throws IOException {
        if (url == null) {
            throw new IllegalStateException("Could not load default imports resource: /default-imports.txt");
        }
        return (String[])Resources.asCharSource((URL)url, (Charset)Charsets.UTF_8).readLines((LineProcessor)new LineProcessor<String[]>(){
            private final List<String> packages = Lists.newLinkedList();

            public boolean processLine(String line) throws IOException {
                this.packages.add(line.substring(7, line.length() - 2));
                return true;
            }

            public String[] getResult() {
                return this.packages.toArray(new String[this.packages.size()]);
            }
        });
    }

    private static Map<String, List<String>> generateSimpleNameToFQCN() throws IOException {
        URL url = DefaultImportsReader.class.getResource(MAPPING_RESOURCE);
        if (url == null) {
            throw new IllegalStateException("Could not load default imports resource: /api-mapping.txt");
        }
        return (Map)Resources.asCharSource((URL)url, (Charset)Charsets.UTF_8).readLines((LineProcessor)new LineProcessor<Map<String, List<String>>>(){
            private final ImmutableMap.Builder<String, List<String>> builder = ImmutableMap.builder();

            public boolean processLine(String line) throws IOException {
                boolean process;
                boolean bl = process = !StringUtils.isEmpty((String)line);
                if (process) {
                    String[] split = line.split(":");
                    if (split.length == 2) {
                        String simpleName = split[0];
                        List fqcns = Splitter.on((char)';').omitEmptyStrings().splitToList((CharSequence)split[1]);
                        this.builder.put((Object)simpleName, (Object)fqcns);
                    } else {
                        process = false;
                    }
                }
                return process;
            }

            public Map<String, List<String>> getResult() {
                return this.builder.build();
            }
        });
    }
}

