/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.UninitializedPropertyAccessExceptionThrower;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRichPropertyReference;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrWhenImpl;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.utils.CollectionUtilKt;

@PhaseDescription(name="LateinitLowering")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001dH\u0016J\f\u0010\u001e\u001a\u00020\u001f*\u00020 H\u0002J\f\u0010!\u001a\u00020\u001f*\u00020\u0016H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u0016H\u0014J\u0018\u0010'\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020 2\u0006\u0010(\u001a\u00020)H\u0002J\u0014\u0010*\u001a\u00020\u0019*\u00020+2\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LateinitLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "loweringContext", "Lorg/jetbrains/kotlin/backend/common/LoweringContext;", "uninitializedPropertyAccessExceptionThrower", "Lorg/jetbrains/kotlin/backend/common/lower/UninitializedPropertyAccessExceptionThrower;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/LoweringContext;Lorg/jetbrains/kotlin/backend/common/lower/UninitializedPropertyAccessExceptionThrower;)V", "(Lorg/jetbrains/kotlin/backend/common/LoweringContext;)V", "visitedLateinitVariables", "", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "visitProperty", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "visitVariable", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "isLateinitBackingField", "", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "isRealLateinit", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "transformLateinitBackingField", "backingField", "property", "transformGetter", "getter", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "throwUninitializedPropertyAccessException", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "name", "", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nLateinitLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LateinitLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LateinitLowering\n+ 2 LateinitLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LateinitLoweringKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n192#2,12:215\n1#3:227\n*S KotlinDebug\n*F\n+ 1 LateinitLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LateinitLowering\n*L\n133#1:215,12\n*E\n"})
public class LateinitLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final LoweringContext loweringContext;
    @NotNull
    private final UninitializedPropertyAccessExceptionThrower uninitializedPropertyAccessExceptionThrower;
    @NotNull
    private final Set<IrVariable> visitedLateinitVariables;

    public LateinitLowering(@NotNull LoweringContext loweringContext, @NotNull UninitializedPropertyAccessExceptionThrower uninitializedPropertyAccessExceptionThrower) {
        Intrinsics.checkNotNullParameter(loweringContext, "loweringContext");
        Intrinsics.checkNotNullParameter(uninitializedPropertyAccessExceptionThrower, "uninitializedPropertyAccessExceptionThrower");
        this.loweringContext = loweringContext;
        this.uninitializedPropertyAccessExceptionThrower = uninitializedPropertyAccessExceptionThrower;
        this.visitedLateinitVariables = new LinkedHashSet();
    }

    public LateinitLowering(@NotNull LoweringContext loweringContext) {
        Intrinsics.checkNotNullParameter(loweringContext, "loweringContext");
        this(loweringContext, new UninitializedPropertyAccessExceptionThrower(loweringContext.getSymbols()));
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    public final void lower(@NotNull IrBody irBody) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, this);
    }

    @Override
    @NotNull
    public IrStatement visitProperty(@NotNull IrProperty declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (this.isRealLateinit(declaration)) {
            IrField irField = declaration.getBackingField();
            Intrinsics.checkNotNull(irField);
            IrField backingField = irField;
            if (!IrTypePredicatesKt.isMarkedNullable(backingField.getType())) {
                this.transformLateinitBackingField(backingField, declaration);
                IrSimpleFunction irSimpleFunction = declaration.getGetter();
                if (irSimpleFunction != null) {
                    IrSimpleFunction it = irSimpleFunction;
                    boolean bl = false;
                    this.transformGetter(backingField, it);
                }
            }
        }
        this.transformChildrenVoid(declaration);
        return declaration;
    }

    @Override
    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        this.transformChildrenVoid(declaration);
        if (declaration.isLateinit() && !IrTypePredicatesKt.isMarkedNullable(declaration.getType())) {
            ((Collection)this.visitedLateinitVariables).add(declaration);
            declaration.setType(IrTypesKt.makeNullable(declaration.getType()));
            declaration.setVar(true);
            declaration.setInitializer(IrConstImpl.Companion.constNull(declaration.getStartOffset(), declaration.getEndOffset(), this.loweringContext.getIrBuiltIns().getNothingNType()));
        }
        return declaration;
    }

    @Override
    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.transformChildrenVoid(expression2);
        IrValueDeclaration irValue = expression2.getSymbol().getOwner();
        if (!(irValue instanceof IrVariable) || !this.visitedLateinitVariables.contains(irValue)) {
            return expression2;
        }
        IrDeclarationParent irDeclarationParent = ((IrVariable)irValue).getParent();
        Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
        DeclarationIrBuilder $this$visitGetValue_u24lambda_u241 = LowerUtilsKt.createIrBuilder(this.loweringContext, ((IrSymbolOwner)((Object)irDeclarationParent)).getSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
        boolean bl = false;
        IrBuilder irBuilder = $this$visitGetValue_u24lambda_u241;
        IrType irType = expression2.getType();
        IrExpression irExpression = ExpressionHelpersKt.irEqualsNull($this$visitGetValue_u24lambda_u241, ExpressionHelpersKt.irGet($this$visitGetValue_u24lambda_u241, irValue));
        IrBuilderWithScope irBuilderWithScope = $this$visitGetValue_u24lambda_u241;
        String string = irValue.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        return ExpressionHelpersKt.irIfThenElse$default(irBuilder, irType, irExpression, this.uninitializedPropertyAccessExceptionThrower.build(irBuilderWithScope, string), ExpressionHelpersKt.irGet($this$visitGetValue_u24lambda_u241, irValue), null, 16, null);
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.transformChildrenVoid(expression2);
        IrField irField = (IrField)expression2.getSymbol().getOwner();
        if (this.isLateinitBackingField(irField)) {
            expression2.setType(IrTypesKt.makeNullable(expression2.getType()));
        }
        return expression2;
    }

    private final boolean isLateinitBackingField(IrField $this$isLateinitBackingField) {
        IrPropertySymbol irPropertySymbol = $this$isLateinitBackingField.getCorrespondingPropertySymbol();
        IrProperty property2 = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
        return property2 != null && this.isRealLateinit(property2);
    }

    private final boolean isRealLateinit(IrProperty $this$isRealLateinit) {
        return $this$isRealLateinit.isLateinit() && !$this$isRealLateinit.isFakeOverride();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrExpression irExpression;
        Pair<Object, IrExpression> pair;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.transformChildrenVoid(expression2);
        if (!Symbols.Companion.isLateinitIsInitializedPropertyGetter(expression2.getSymbol())) {
            return expression2;
        }
        Object e2 = expression2.getArguments().get(0);
        Intrinsics.checkNotNull(e2);
        IrExpression $this$replaceTailExpression$iv = (IrExpression)e2;
        boolean $i$f$replaceTailExpression = false;
        IrExpression current$iv = $this$replaceTailExpression$iv;
        IrContainerExpression block$iv = null;
        while (current$iv instanceof IrContainerExpression) {
            block$iv = (IrContainerExpression)current$iv;
            IrStatement irStatement = CollectionsKt.last(((IrContainerExpression)current$iv).getStatements());
            Intrinsics.checkNotNull(irStatement, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            current$iv = (IrExpression)irStatement;
        }
        IrExpression it = current$iv;
        boolean bl = false;
        IrExpression irExpression2 = it;
        if (irExpression2 instanceof IrPropertyReference) {
            Object object = ((IrPropertyReference)it).getGetter();
            pair = TuplesKt.to(object != null && (object = (IrSimpleFunction)object.getOwner()) != null && (object = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default((IrOverridableDeclaration)object, null, 1, null)) != null && (object = ((IrSimpleFunction)object).getCorrespondingPropertySymbol()) != null ? (IrProperty)object.getOwner() : null, ((IrPropertyReference)it).getDispatchReceiver());
        } else if (irExpression2 instanceof IrRichPropertyReference) {
            Object s2 = ((IrRichPropertyReference)it).getReflectionTargetSymbol();
            Object object = s2 instanceof IrPropertySymbol ? (IrPropertySymbol)s2 : null;
            pair = TuplesKt.to(object != null && (object = (IrProperty)object.getOwner()) != null ? (IrProperty)IrFakeOverrideUtilsKt.resolveFakeOverride$default((IrOverridableDeclaration)object, null, 1, null) : null, CollectionUtilKt.atMostOne((Collection)((IrRichPropertyReference)it).getBoundValues()));
        } else {
            throw new IllegalStateException(("Unsupported argument for KProperty::isInitialized call: " + RenderIrElementKt.render$default(it, null, 1, null)).toString());
        }
        Pair<Object, IrExpression> pair2 = pair;
        IrProperty property2 = pair2.component1();
        IrExpression dispatchReceiver = pair2.component2();
        IrProperty irProperty = property2;
        if (!(irProperty != null ? irProperty.isLateinit() : false)) {
            boolean bl2 = false;
            IrProperty irProperty2 = property2;
            String string = "isInitialized invoked on non-lateinit property " + (irProperty2 != null ? RenderIrElementKt.render$default(irProperty2, null, 1, null) : null);
            throw new IllegalArgumentException(string.toString());
        }
        IrField irField = property2.getBackingField();
        if (irField == null) {
            throw new AssertionError((Object)"Lateinit property is supposed to have a backing field");
        }
        IrField backingField = irField;
        this.transformLateinitBackingField(backingField, property2);
        DeclarationIrBuilder $this$visitCall_u24lambda_u244_u24lambda_u243 = LowerUtilsKt.createIrBuilder(this.loweringContext, (IrSymbol)property2.getSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
        boolean bl3 = false;
        current$iv = ExpressionHelpersKt.irNotEquals($this$visitCall_u24lambda_u244_u24lambda_u243, ExpressionHelpersKt.irGetField$default($this$visitCall_u24lambda_u244_u24lambda_u243, dispatchReceiver, backingField, null, 4, null), ExpressionHelpersKt.irNull($this$visitCall_u24lambda_u244_u24lambda_u243));
        if (block$iv == null) {
            irExpression = current$iv;
        } else {
            void var2_2;
            block$iv.getStatements().set(block$iv.getStatements().size() - 1, current$iv);
            irExpression = var2_2;
        }
        return irExpression;
    }

    protected void transformLateinitBackingField(@NotNull IrField backingField, @NotNull IrProperty property2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(backingField, "backingField");
        Intrinsics.checkNotNullParameter(property2, "property");
        boolean bl2 = bl = backingField.getInitializer() == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "lateinit property backing field should not have an initializer:\n" + DumpIrTreeKt.dump$default(property2, null, 1, null);
            throw new AssertionError((Object)string);
        }
        backingField.setType(IrTypesKt.makeNullable(backingField.getType()));
    }

    private final void transformGetter(IrField backingField, IrFunction getter2) {
        boolean bl;
        IrType type = backingField.getType();
        boolean bl2 = bl = !IrTypePredicatesKt.isPrimitiveType$default(type, false, 1, null);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-LateinitLowering$transformGetter$22 = false;
            String $i$a$-assert-LateinitLowering$transformGetter$22 = "'lateinit' property type should not be primitive:\n" + DumpIrTreeKt.dump$default(backingField, null, 1, null);
            throw new AssertionError((Object)$i$a$-assert-LateinitLowering$transformGetter$22);
        }
        int startOffset = getter2.getStartOffset();
        int endOffset = getter2.getEndOffset();
        getter2.setBody(IrFactoryHelpersKt.createBlockBody(this.loweringContext.getIrFactory(), startOffset, endOffset, arg_0 -> LateinitLowering.transformGetter$lambda$9(this, getter2, startOffset, endOffset, backingField, type, arg_0)));
    }

    private final IrExpression throwUninitializedPropertyAccessException(IrBuilderWithScope $this$throwUninitializedPropertyAccessException, String name2) {
        return this.uninitializedPropertyAccessExceptionThrower.build($this$throwUninitializedPropertyAccessException, name2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit transformGetter$lambda$9(LateinitLowering this$0, IrFunction $getter, int $startOffset, int $endOffset, IrField $backingField, IrType $type, IrBlockBody $this$createBlockBody) {
        IrGetValueImpl irGetValueImpl;
        DeclarationIrBuilder irBuilder;
        Intrinsics.checkNotNullParameter($this$createBlockBody, "$this$createBlockBody");
        DeclarationIrBuilder $this$transformGetter_u24lambda_u249_u24lambda_u248 = irBuilder = LowerUtilsKt.createIrBuilder(this$0.loweringContext, (IrSymbol)$getter.getSymbol(), $startOffset, $endOffset);
        boolean bl = false;
        Scope scope2 = $this$transformGetter_u24lambda_u249_u24lambda_u248.getScope();
        IrBuilder irBuilder2 = $this$transformGetter_u24lambda_u249_u24lambda_u248;
        IrValueParameter irValueParameter = $getter.getDispatchReceiverParameter();
        if (irValueParameter != null) {
            void it;
            IrValueParameter irValueParameter2 = irValueParameter;
            IrBuilder irBuilder3 = irBuilder2;
            Scope scope3 = scope2;
            boolean bl2 = false;
            IrGetValueImpl irGetValueImpl2 = ExpressionHelpersKt.irGet($this$transformGetter_u24lambda_u249_u24lambda_u248, (IrValueDeclaration)it);
            scope2 = scope3;
            irBuilder2 = irBuilder3;
            irGetValueImpl = irGetValueImpl2;
        } else {
            irGetValueImpl = null;
        }
        IrVariable resultVar2 = IrBuilderKt.createTmpVariable$default(scope2, (IrExpression)ExpressionHelpersKt.irGetField(irBuilder2, irGetValueImpl, $backingField, $type), null, false, null, null, 30, null);
        resultVar2.setParent($getter);
        $this$createBlockBody.getStatements().add(resultVar2);
        IrBuilder irBuilder4 = $this$transformGetter_u24lambda_u249_u24lambda_u248;
        IrType irType = $this$transformGetter_u24lambda_u249_u24lambda_u248.getContext().getIrBuiltIns().getNothingType();
        IrExpression irExpression = ExpressionHelpersKt.irNotEquals($this$transformGetter_u24lambda_u249_u24lambda_u248, ExpressionHelpersKt.irGet($this$transformGetter_u24lambda_u249_u24lambda_u248, resultVar2), ExpressionHelpersKt.irNull($this$transformGetter_u24lambda_u249_u24lambda_u248));
        IrExpression irExpression2 = ExpressionHelpersKt.irReturn($this$transformGetter_u24lambda_u249_u24lambda_u248, ExpressionHelpersKt.irGet($this$transformGetter_u24lambda_u249_u24lambda_u248, resultVar2));
        IrBuilderWithScope irBuilderWithScope = $this$transformGetter_u24lambda_u249_u24lambda_u248;
        String string = $backingField.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        IrWhenImpl throwIfNull = ExpressionHelpersKt.irIfThenElse$default(irBuilder4, irType, irExpression, irExpression2, this$0.throwUninitializedPropertyAccessException(irBuilderWithScope, string), null, 16, null);
        $this$createBlockBody.getStatements().add(throwIfNull);
        return Unit.INSTANCE;
    }
}

