/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.result;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import org.hsqldb.ColumnBase;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.lib.List;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.result.ResultLob;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public class Result {
    public static final Result[] emptyArray = new Result[0];
    public static final ResultMetaData sessionAttributesMetaData;
    private static final ResultMetaData emptyMeta;
    public static final Result emptyGeneratedResult;
    public static final Result updateZeroResult;
    public static final Result updateOneResult;
    public byte mode;
    int databaseID;
    long sessionID;
    private long id;
    private String databaseName;
    private String mainString;
    private String subString;
    private String zoneString;
    int errorCode;
    private HsqlException exception;
    long statementID;
    int statementReturnType;
    public int updateCount;
    private int fetchSize;
    private Result chainedResult;
    private int lobCount;
    ResultLob lobResults;
    public ResultMetaData metaData;
    public ResultMetaData parameterMetaData;
    public ResultMetaData generatedMetaData;
    public int rsProperties;
    public int queryTimeout;
    int generateKeys;
    public Object valueData;
    public Statement statement;
    public RowSetNavigator navigator;

    Result(int n) {
        this.mode = (byte)n;
    }

    public Result(int n, int n2) {
        this.mode = (byte)n;
        this.updateCount = n2;
    }

    public static Result newResult(RowSetNavigator rowSetNavigator) {
        Result result = new Result(3);
        result.navigator = rowSetNavigator;
        return result;
    }

    public static Result newResult(int n) {
        RowSetNavigatorClient rowSetNavigatorClient = null;
        switch (n) {
            case 35: 
            case 41: 
            case 43: {
                break;
            }
            case 8: 
            case 9: {
                rowSetNavigatorClient = new RowSetNavigatorClient(4);
                break;
            }
            case 6: 
            case 17: {
                rowSetNavigatorClient = new RowSetNavigatorClient(1);
                break;
            }
            case 16: {
                rowSetNavigatorClient = new RowSetNavigatorClient(4);
                break;
            }
            case 3: 
            case 14: 
            case 15: 
            case 20: {
                break;
            }
            case 18: {
                throw Error.runtimeError(201, "Result");
            }
        }
        Result result = new Result(n);
        result.navigator = rowSetNavigatorClient;
        return result;
    }

    public static Result newResult(DataInputStream dataInputStream, RowInputInterface rowInputInterface) throws IOException {
        byte by = dataInputStream.readByte();
        return Result.newResult(null, by, dataInputStream, rowInputInterface);
    }

    public static Result newResult(Session session, int n, DataInputStream dataInputStream, RowInputInterface rowInputInterface) {
        try {
            if (n == 18) {
                return ResultLob.newLob(dataInputStream, false);
            }
            Result result = Result.newResult(session, dataInputStream, rowInputInterface, n);
            return result;
        }
        catch (IOException iOException) {
            throw Error.error(1300, iOException);
        }
    }

    public void readAdditionalResults(SessionInterface sessionInterface, DataInputStream dataInputStream, RowInputInterface rowInputInterface) throws IOException {
        this.setSession(sessionInterface);
        byte by;
        while ((by = dataInputStream.readByte()) != 0) {
            Result result = Result.newResult(null, dataInputStream, rowInputInterface, by);
            this.addChainedResult(result);
        }
        return;
    }

    public Result readLobResults(Session session, DataInputStream dataInputStream) throws IOException {
        byte by;
        boolean bl = false;
        this.setSession(session);
        while ((by = dataInputStream.readByte()) == 18) {
            ResultLob resultLob = ResultLob.newLob(dataInputStream, false);
            Result result = session.allocateResultLob(resultLob);
            if (result.isError()) {
                return result;
            }
            bl = true;
        }
        if (by != 0) {
            throw Error.runtimeError(201, "Result");
        }
        if (bl) {
            session.registerResultLobs(this);
        }
        return updateZeroResult;
    }

    private static Result newResult(Session session, DataInput dataInput, RowInputInterface rowInputInterface, int n) throws IOException {
        Result result = Result.newResult(n);
        int n2 = dataInput.readInt();
        rowInputInterface.resetRow(0L, n2);
        byte[] byArray = rowInputInterface.getBuffer();
        dataInput.readFully(byArray, 4, n2 - 4);
        block0 : switch (n) {
            case 7: {
                result.statementReturnType = rowInputInterface.readByte();
                break;
            }
            case 10: 
            case 32: 
            case 39: {
                break;
            }
            case 37: {
                result.setStatementType(rowInputInterface.readByte());
                result.mainString = rowInputInterface.readString();
                result.rsProperties = rowInputInterface.readByte();
                result.generateKeys = rowInputInterface.readByte();
                if (result.generateKeys != 11 && result.generateKeys != 21) break;
                result.generatedMetaData = new ResultMetaData(rowInputInterface);
                break;
            }
            case 40: {
                result.id = rowInputInterface.readLong();
                break;
            }
            case 36: {
                result.statementID = rowInputInterface.readLong();
                break;
            }
            case 34: {
                result.updateCount = rowInputInterface.readInt();
                result.fetchSize = rowInputInterface.readInt();
                result.statementReturnType = rowInputInterface.readByte();
                result.mainString = rowInputInterface.readString();
                result.rsProperties = rowInputInterface.readByte();
                result.queryTimeout = rowInputInterface.readShort();
                result.generateKeys = rowInputInterface.readByte();
                if (result.generateKeys != 11 && result.generateKeys != 21) break;
                result.generatedMetaData = new ResultMetaData(rowInputInterface);
                break;
            }
            case 31: {
                result.databaseName = rowInputInterface.readString();
                result.mainString = rowInputInterface.readString();
                result.subString = rowInputInterface.readString();
                result.zoneString = rowInputInterface.readString();
                result.updateCount = rowInputInterface.readInt();
                break;
            }
            case 2: 
            case 19: {
                result.mainString = rowInputInterface.readString();
                result.subString = rowInputInterface.readString();
                result.errorCode = rowInputInterface.readInt();
                break;
            }
            case 11: {
                result.databaseID = rowInputInterface.readInt();
                result.sessionID = rowInputInterface.readLong();
                result.databaseName = rowInputInterface.readString();
                result.mainString = rowInputInterface.readString();
                result.generateKeys = rowInputInterface.readInt();
                break;
            }
            case 1: {
                result.updateCount = rowInputInterface.readInt();
                break;
            }
            case 33: {
                int n3 = rowInputInterface.readInt();
                result.setActionType(n3);
                switch (n3) {
                    case 2: 
                    case 4: {
                        result.mainString = rowInputInterface.readString();
                        break block0;
                    }
                    case 0: 
                    case 1: 
                    case 6: 
                    case 7: 
                    case 12: {
                        break block0;
                    }
                }
                throw Error.runtimeError(201, "Result");
            }
            case 38: {
                int n4 = rowInputInterface.readInt();
                result.setConnectionAttrType(n4);
                switch (n4) {
                    case 10027: {
                        result.mainString = rowInputInterface.readString();
                        break block0;
                    }
                }
                throw Error.runtimeError(201, "Result");
            }
            case 5: {
                result.databaseID = rowInputInterface.readInt();
                result.sessionID = rowInputInterface.readLong();
                result.statementID = rowInputInterface.readLong();
                result.generateKeys = rowInputInterface.readInt();
                result.mainString = rowInputInterface.readString();
                break;
            }
            case 4: {
                result.statementReturnType = rowInputInterface.readByte();
                result.statementID = rowInputInterface.readLong();
                result.rsProperties = rowInputInterface.readByte();
                result.metaData = new ResultMetaData(rowInputInterface);
                result.parameterMetaData = new ResultMetaData(rowInputInterface);
                break;
            }
            case 43: {
                result.updateCount = rowInputInterface.readInt();
                result.fetchSize = rowInputInterface.readInt();
                result.statementID = rowInputInterface.readLong();
                result.statementReturnType = rowInputInterface.readByte();
                result.rsProperties = rowInputInterface.readByte();
                result.metaData = new ResultMetaData(rowInputInterface);
                result.valueData = Result.readSimple(rowInputInterface, result.metaData);
                break;
            }
            case 35: {
                result.updateCount = rowInputInterface.readInt();
                result.fetchSize = rowInputInterface.readInt();
                result.statementID = rowInputInterface.readLong();
                result.rsProperties = rowInputInterface.readByte();
                result.queryTimeout = rowInputInterface.readShort();
                Statement statement = session.statementManager.getStatement(result.statementID);
                if (statement == null) {
                    result.mode = (byte)21;
                    result.valueData = ValuePool.emptyObjectArray;
                    break;
                }
                result.statement = statement;
                result.metaData = result.statement.getParametersMetaData();
                result.valueData = Result.readSimple(rowInputInterface, result.metaData);
                break;
            }
            case 41: {
                result.id = rowInputInterface.readLong();
                int n5 = rowInputInterface.readInt();
                result.setActionType(n5);
                result.metaData = new ResultMetaData(rowInputInterface);
                result.valueData = Result.readSimple(rowInputInterface, result.metaData);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 16: {
                result.updateCount = rowInputInterface.readInt();
                result.fetchSize = rowInputInterface.readInt();
                result.statementID = rowInputInterface.readLong();
                result.queryTimeout = rowInputInterface.readShort();
                result.metaData = new ResultMetaData(rowInputInterface);
                result.navigator.readSimple(rowInputInterface, result.metaData);
                break;
            }
            case 17: {
                result.metaData = new ResultMetaData(rowInputInterface);
                result.navigator.read(rowInputInterface, result.metaData);
                break;
            }
            case 13: {
                result.id = rowInputInterface.readLong();
                result.updateCount = rowInputInterface.readInt();
                result.fetchSize = rowInputInterface.readInt();
                break;
            }
            case 3: 
            case 15: 
            case 20: {
                result.id = rowInputInterface.readLong();
                result.updateCount = rowInputInterface.readInt();
                result.fetchSize = rowInputInterface.readInt();
                result.rsProperties = rowInputInterface.readByte();
                result.metaData = new ResultMetaData(rowInputInterface);
                result.navigator = new RowSetNavigatorClient();
                result.navigator.read(rowInputInterface, result.metaData);
                break;
            }
            case 14: {
                result.metaData = new ResultMetaData(rowInputInterface);
                result.navigator = new RowSetNavigatorClient();
                result.navigator.read(rowInputInterface, result.metaData);
                break;
            }
            default: {
                throw Error.runtimeError(201, "Result");
            }
        }
        return result;
    }

    public static Result newPSMResult(int n, String string, Object object) {
        Result result = Result.newResult(42);
        result.errorCode = n;
        result.mainString = string;
        result.valueData = object;
        return result;
    }

    public static Result newPSMResult(Object object) {
        Result result = Result.newResult(42);
        result.valueData = object;
        return result;
    }

    public static Result newPrepareStatementRequest() {
        return Result.newResult(37);
    }

    public static Result newPreparedExecuteRequest(Type[] typeArray, long l) {
        Result result = Result.newResult(35);
        result.metaData = ResultMetaData.newSimpleResultMetaData(typeArray);
        result.statementID = l;
        result.valueData = ValuePool.emptyObjectArray;
        return result;
    }

    public static Result newCallResponse(Type[] typeArray, long l, Object[] objectArray) {
        Result result = Result.newResult(43);
        result.metaData = ResultMetaData.newSimpleResultMetaData(typeArray);
        result.statementID = l;
        result.valueData = objectArray;
        return result;
    }

    public static Result newUpdateResultRequest(Type[] typeArray, long l) {
        Result result = Result.newResult(41);
        result.metaData = ResultMetaData.newUpdateResultMetaData(typeArray);
        result.id = l;
        result.valueData = ValuePool.emptyObjectArray;
        return result;
    }

    public void setPreparedResultUpdateProperties(Object[] objectArray) {
        this.valueData = objectArray;
    }

    public void setPreparedExecuteProperties(Object[] objectArray, int n, int n2, int n3, int n4) {
        this.mode = (byte)35;
        this.valueData = objectArray;
        this.updateCount = n;
        this.fetchSize = n2;
        this.rsProperties = n3;
        this.queryTimeout = n4;
    }

    public void setBatchedPreparedExecuteRequest() {
        this.mode = (byte)9;
        if (this.navigator == null) {
            this.navigator = new RowSetNavigatorClient(4);
        } else {
            this.navigator.clear();
        }
        this.updateCount = 0;
        this.fetchSize = 0;
    }

    public void addBatchedPreparedExecuteRequest(Object[] objectArray) {
        this.navigator.add(objectArray);
    }

    public static Result newBatchedExecuteRequest() {
        Type[] typeArray = new Type[]{Type.SQL_VARCHAR};
        Result result = Result.newResult(8);
        result.metaData = ResultMetaData.newSimpleResultMetaData(typeArray);
        return result;
    }

    public static Result newBatchedExecuteResponse(int[] nArray, Result result, Result result2) {
        Result result3 = Result.newResult(16);
        result3.addChainedResult(result);
        result3.addChainedResult(result2);
        Type[] typeArray = new Type[]{Type.SQL_INTEGER};
        result3.metaData = ResultMetaData.newSimpleResultMetaData(typeArray);
        Object[][] objectArray = new Object[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = new Object[]{ValuePool.getInt(nArray[i])};
        }
        ((RowSetNavigatorClient)result3.navigator).setData(objectArray);
        return result3;
    }

    public static Result newResetSessionRequest() {
        return Result.newResult(10);
    }

    public static Result newConnectionAttemptRequest(String string, String string2, String string3, String string4, int n) {
        Result result = Result.newResult(31);
        result.mainString = string;
        result.subString = string2;
        result.zoneString = string4;
        result.databaseName = string3;
        result.updateCount = n;
        return result;
    }

    public static Result newConnectionAcknowledgeResponse(Session session) {
        Result result = Result.newResult(11);
        result.sessionID = session.getId();
        result.databaseID = session.getDatabase().getDatabaseID();
        result.databaseName = session.getDatabase().getNameString();
        result.mainString = session.getDatabase().getProperties().getClientPropertiesAsString();
        result.generateKeys = session.getRandomId();
        return result;
    }

    public static Result newUpdateZeroResult() {
        return new Result(1, 0);
    }

    public static Result newUpdateCountResult(int n) {
        return new Result(1, n);
    }

    public static Result newUpdateCountResult(ResultMetaData resultMetaData, int n) {
        Result result = Result.newResult(1);
        Result result2 = Result.newGeneratedDataResult(resultMetaData);
        result.updateCount = n;
        result.addChainedResult(result2);
        return result;
    }

    public static Result newSingleColumnResult(ResultMetaData resultMetaData) {
        Result result = Result.newResult(3);
        result.metaData = resultMetaData;
        result.navigator = new RowSetNavigatorClient();
        return result;
    }

    public static Result newSingleColumnResult(String string) {
        Result result = Result.newResult(3);
        result.metaData = ResultMetaData.newSingleColumnMetaData(string);
        result.navigator = new RowSetNavigatorClient(8);
        return result;
    }

    public static Result newSingleColumnStringResult(String string, String string2) {
        Result result = Result.newSingleColumnResult(string);
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(string2));
        while (true) {
            String string3 = null;
            try {
                string3 = lineNumberReader.readLine();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string3 == null) break;
            result.getNavigator().add(new Object[]{string3});
        }
        return result;
    }

    public static Result newMultiColumnResult(String[] stringArray, Type[] typeArray) {
        Result result = Result.newResult(3);
        result.metaData = ResultMetaData.newMetaData(stringArray, typeArray);
        result.navigator = new RowSetNavigatorClient(8);
        return result;
    }

    public static Result newPrepareResponse(Statement statement) {
        Result result = Result.newResult(4);
        result.statement = statement;
        result.statementID = statement.getID();
        int n = statement.getType();
        result.statementReturnType = statement.getStatementReturnType();
        result.metaData = statement.getResultMetaData();
        result.parameterMetaData = statement.getParametersMetaData();
        return result;
    }

    public static Result newCancelRequest(int n, long l, String string) {
        Result result = Result.newResult(5);
        result.statementID = l;
        result.mainString = string;
        result.generateKeys = n;
        return result;
    }

    public static Result newFreeStmtRequest(long l) {
        Result result = Result.newResult(36);
        result.statementID = l;
        return result;
    }

    public static Result newExecuteDirectRequest() {
        return Result.newResult(34);
    }

    public void setPrepareOrExecuteProperties(String string, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray, String[] stringArray) {
        this.mainString = string;
        this.updateCount = n;
        this.fetchSize = n2;
        this.statementReturnType = n3;
        this.queryTimeout = n4;
        this.rsProperties = n5;
        this.generateKeys = n6;
        this.generatedMetaData = ResultMetaData.newGeneratedColumnsMetaData(nArray, stringArray);
    }

    public static Result newSetSavepointRequest(String string) {
        Result result = Result.newResult(38);
        result.setConnectionAttrType(10027);
        result.setMainString(string);
        return result;
    }

    public static Result newRequestDataResult(long l, int n, int n2) {
        Result result = Result.newResult(13);
        result.id = l;
        result.updateCount = n;
        result.fetchSize = n2;
        return result;
    }

    public static Result newDataResult(ResultMetaData resultMetaData) {
        Result result = Result.newResult(3);
        result.navigator = new RowSetNavigatorClient();
        result.metaData = resultMetaData;
        return result;
    }

    public static Result newGeneratedDataResult(ResultMetaData resultMetaData) {
        Result result = Result.newResult(20);
        result.navigator = new RowSetNavigatorClient();
        result.metaData = resultMetaData;
        return result;
    }

    public int getExecuteProperties() {
        return this.rsProperties;
    }

    public static Result newDataHeadResult(SessionInterface sessionInterface, Result result, int n, int n2) {
        if (n + n2 > result.navigator.getSize()) {
            n2 = result.navigator.getSize() - n;
        }
        Result result2 = Result.newResult(15);
        result2.metaData = result.metaData;
        result2.navigator = new RowSetNavigatorClient(result.navigator, n, n2);
        result2.navigator.setId(result.navigator.getId());
        result2.setSession(sessionInterface);
        result2.rsProperties = result.rsProperties;
        result2.fetchSize = result.fetchSize;
        return result2;
    }

    public static Result newDataRowsResult(Result result, int n, int n2) {
        if (n + n2 > result.navigator.getSize()) {
            n2 = result.navigator.getSize() - n;
        }
        Result result2 = Result.newResult(14);
        result2.id = result.id;
        result2.metaData = result.metaData;
        result2.navigator = new RowSetNavigatorClient(result.navigator, n, n2);
        return result2;
    }

    public static Result newDataRowsResult(RowSetNavigator rowSetNavigator) {
        Result result = Result.newResult(14);
        result.navigator = rowSetNavigator;
        return result;
    }

    public static Result newSessionAttributesResult() {
        Result result = Result.newResult(3);
        result.navigator = new RowSetNavigatorClient(1);
        result.metaData = sessionAttributesMetaData;
        result.navigator.add(new Object[4]);
        return result;
    }

    public static Result newWarningResult(HsqlException hsqlException) {
        Result result = Result.newResult(19);
        result.mainString = hsqlException.getMessage();
        result.subString = hsqlException.getSQLState();
        result.errorCode = hsqlException.getErrorCode();
        return result;
    }

    public static Result newErrorResult(Throwable throwable) {
        return Result.newErrorResult(throwable, null);
    }

    public static Result newErrorResult(Throwable throwable, String string) {
        Result result = Result.newResult(2);
        if (throwable instanceof HsqlException) {
            result.exception = (HsqlException)throwable;
            result.mainString = result.exception.getMessage();
            result.subString = result.exception.getSQLState();
            if (string != null) {
                result.mainString = result.mainString + " in statement [" + string + "]";
            }
            result.errorCode = result.exception.getErrorCode();
        } else if (throwable instanceof OutOfMemoryError) {
            result.exception = Error.error(460, throwable);
            result.mainString = result.exception.getMessage();
            result.subString = result.exception.getSQLState();
            result.errorCode = result.exception.getErrorCode();
        } else if (throwable instanceof IOException) {
            result.exception = Error.error(467);
            result.mainString = result.exception.getMessage() + ' ' + throwable.getMessage();
            result.subString = result.exception.getSQLState();
            result.errorCode = result.exception.getErrorCode();
        } else {
            result.exception = Error.error(458);
            result.mainString = result.exception.getMessage();
            result.subString = result.exception.getSQLState();
            result.errorCode = result.exception.getErrorCode();
        }
        return result;
    }

    public void write(SessionInterface sessionInterface, DataOutputStream dataOutputStream, RowOutputInterface rowOutputInterface) throws IOException {
        int n;
        rowOutputInterface.reset();
        rowOutputInterface.writeByte(this.mode);
        int n2 = rowOutputInterface.size();
        rowOutputInterface.writeSize(0);
        block0 : switch (this.mode) {
            case 7: {
                rowOutputInterface.writeByte(this.statementReturnType);
                break;
            }
            case 10: 
            case 32: 
            case 39: {
                break;
            }
            case 37: {
                rowOutputInterface.writeByte(this.statementReturnType);
                rowOutputInterface.writeString(this.mainString);
                rowOutputInterface.writeByte(this.rsProperties);
                rowOutputInterface.writeByte(this.generateKeys);
                if (this.generateKeys != 11 && this.generateKeys != 21) break;
                this.generatedMetaData.write(rowOutputInterface);
                break;
            }
            case 36: {
                rowOutputInterface.writeLong(this.statementID);
                break;
            }
            case 40: {
                rowOutputInterface.writeLong(this.id);
                break;
            }
            case 34: {
                rowOutputInterface.writeInt(this.updateCount);
                rowOutputInterface.writeInt(this.fetchSize);
                rowOutputInterface.writeByte(this.statementReturnType);
                rowOutputInterface.writeString(this.mainString);
                rowOutputInterface.writeByte(this.rsProperties);
                rowOutputInterface.writeShort(this.queryTimeout);
                rowOutputInterface.writeByte(this.generateKeys);
                if (this.generateKeys != 11 && this.generateKeys != 21) break;
                this.generatedMetaData.write(rowOutputInterface);
                break;
            }
            case 31: {
                rowOutputInterface.writeString(this.databaseName);
                rowOutputInterface.writeString(this.mainString);
                rowOutputInterface.writeString(this.subString);
                rowOutputInterface.writeString(this.zoneString);
                rowOutputInterface.writeInt(this.updateCount);
                break;
            }
            case 2: 
            case 19: {
                rowOutputInterface.writeString(this.mainString);
                rowOutputInterface.writeString(this.subString);
                rowOutputInterface.writeInt(this.errorCode);
                break;
            }
            case 11: {
                rowOutputInterface.writeInt(this.databaseID);
                rowOutputInterface.writeLong(this.sessionID);
                rowOutputInterface.writeString(this.databaseName);
                rowOutputInterface.writeString(this.mainString);
                rowOutputInterface.writeInt(this.generateKeys);
                break;
            }
            case 1: {
                rowOutputInterface.writeInt(this.updateCount);
                break;
            }
            case 33: {
                n = this.getActionType();
                rowOutputInterface.writeInt(n);
                switch (n) {
                    case 2: 
                    case 4: {
                        rowOutputInterface.writeString(this.mainString);
                        break block0;
                    }
                    case 0: 
                    case 1: 
                    case 6: 
                    case 7: 
                    case 12: {
                        break block0;
                    }
                }
                throw Error.runtimeError(201, "Result");
            }
            case 5: {
                rowOutputInterface.writeInt(this.databaseID);
                rowOutputInterface.writeLong(this.sessionID);
                rowOutputInterface.writeLong(this.statementID);
                rowOutputInterface.writeInt(this.generateKeys);
                rowOutputInterface.writeString(this.mainString);
                break;
            }
            case 4: {
                rowOutputInterface.writeByte(this.statementReturnType);
                rowOutputInterface.writeLong(this.statementID);
                rowOutputInterface.writeByte(this.rsProperties);
                this.metaData.write(rowOutputInterface);
                this.parameterMetaData.write(rowOutputInterface);
                break;
            }
            case 43: {
                rowOutputInterface.writeInt(this.updateCount);
                rowOutputInterface.writeInt(this.fetchSize);
                rowOutputInterface.writeLong(this.statementID);
                rowOutputInterface.writeByte(this.statementReturnType);
                rowOutputInterface.writeByte(this.rsProperties);
                this.metaData.write(rowOutputInterface);
                Result.writeSimple(rowOutputInterface, this.metaData, (Object[])this.valueData);
                break;
            }
            case 35: {
                rowOutputInterface.writeInt(this.updateCount);
                rowOutputInterface.writeInt(this.fetchSize);
                rowOutputInterface.writeLong(this.statementID);
                rowOutputInterface.writeByte(this.rsProperties);
                rowOutputInterface.writeShort(this.queryTimeout);
                Result.writeSimple(rowOutputInterface, this.metaData, (Object[])this.valueData);
                break;
            }
            case 41: {
                rowOutputInterface.writeLong(this.id);
                rowOutputInterface.writeInt(this.getActionType());
                this.metaData.write(rowOutputInterface);
                Result.writeSimple(rowOutputInterface, this.metaData, (Object[])this.valueData);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 16: {
                rowOutputInterface.writeInt(this.updateCount);
                rowOutputInterface.writeInt(this.fetchSize);
                rowOutputInterface.writeLong(this.statementID);
                rowOutputInterface.writeShort(this.queryTimeout);
                this.metaData.write(rowOutputInterface);
                this.navigator.writeSimple(rowOutputInterface, this.metaData);
                break;
            }
            case 17: {
                this.metaData.write(rowOutputInterface);
                this.navigator.write(rowOutputInterface, this.metaData);
                break;
            }
            case 38: {
                n = this.getConnectionAttrType();
                rowOutputInterface.writeInt(n);
                switch (n) {
                    case 10027: {
                        rowOutputInterface.writeString(this.mainString);
                        break block0;
                    }
                }
                throw Error.runtimeError(201, "Result");
            }
            case 13: {
                rowOutputInterface.writeLong(this.id);
                rowOutputInterface.writeInt(this.updateCount);
                rowOutputInterface.writeInt(this.fetchSize);
                break;
            }
            case 14: {
                this.metaData.write(rowOutputInterface);
                this.navigator.write(rowOutputInterface, this.metaData);
                break;
            }
            case 3: 
            case 15: 
            case 20: {
                rowOutputInterface.writeLong(this.id);
                rowOutputInterface.writeInt(this.updateCount);
                rowOutputInterface.writeInt(this.fetchSize);
                rowOutputInterface.writeByte(this.rsProperties);
                this.metaData.write(rowOutputInterface);
                this.navigator.write(rowOutputInterface, this.metaData);
                break;
            }
            default: {
                throw Error.runtimeError(201, "Result");
            }
        }
        rowOutputInterface.writeSize(rowOutputInterface.size() - n2);
        dataOutputStream.write(rowOutputInterface.getOutputStream().getBuffer(), 0, rowOutputInterface.size());
        n = this.getLobCount();
        Result result = this;
        for (int i = 0; i < n; ++i) {
            ResultLob resultLob = result.lobResults;
            resultLob.writeBody(sessionInterface, dataOutputStream);
            result = result.lobResults;
        }
        if (this.chainedResult == null) {
            dataOutputStream.writeByte(0);
        } else {
            this.chainedResult.write(sessionInterface, dataOutputStream, rowOutputInterface);
        }
        dataOutputStream.flush();
    }

    public int getType() {
        return this.mode;
    }

    public boolean isData() {
        return this.mode == 3 || this.mode == 15;
    }

    public boolean isError() {
        return this.mode == 2;
    }

    public boolean isWarning() {
        return this.mode == 19;
    }

    public boolean isUpdateCount() {
        return this.mode == 1;
    }

    public boolean isSimpleValue() {
        return this.mode == 42;
    }

    public boolean hasGeneratedKeys() {
        return this.mode == 1 && this.chainedResult != null;
    }

    public HsqlException getException() {
        if (this.exception == null && this.mode == 2) {
            this.exception = Error.error(this);
        }
        return this.exception;
    }

    public long getStatementID() {
        return this.statementID;
    }

    public void setStatementID(long l) {
        this.statementID = l;
    }

    public String getMainString() {
        return this.mainString;
    }

    public void setMainString(String string) {
        this.mainString = string;
    }

    public String getSubString() {
        return this.subString;
    }

    public String getZoneString() {
        return this.zoneString;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Object getValueObject() {
        return this.valueData;
    }

    public void setValueObject(Object object) {
        this.valueData = object;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setMaxRows(int n) {
        this.updateCount = n;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int n) {
        this.fetchSize = n;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public int getConnectionAttrType() {
        return this.updateCount;
    }

    public void setConnectionAttrType(int n) {
        this.updateCount = n;
    }

    public int getActionType() {
        return this.updateCount;
    }

    public void setActionType(int n) {
        this.updateCount = n;
    }

    public long getSessionId() {
        return this.sessionID;
    }

    public void setSessionId(long l) {
        this.sessionID = l;
    }

    public void setSession(SessionInterface sessionInterface) {
        if (this.navigator != null) {
            this.navigator.setSession(sessionInterface);
        }
    }

    public int getDatabaseId() {
        return this.databaseID;
    }

    public void setDatabaseId(int n) {
        this.databaseID = n;
    }

    public long getResultId() {
        return this.id;
    }

    public void setResultId(long l) {
        this.id = l;
        if (this.navigator != null) {
            this.navigator.setId(l);
        }
    }

    public void setUpdateCount(int n) {
        this.updateCount = n;
    }

    public void setAsTransactionEndRequest(int n, String string) {
        this.mode = (byte)33;
        this.updateCount = n;
        this.mainString = string == null ? "" : string;
    }

    public Object[] getSingleRowData() {
        this.initialiseNavigator();
        this.navigator.next();
        Object[] objectArray = this.navigator.getCurrent();
        objectArray = (Object[])ArrayUtil.resizeArrayIfDifferent(objectArray, this.metaData.getColumnCount());
        return objectArray;
    }

    public Object[] getParameterData() {
        return (Object[])this.valueData;
    }

    public Object[] getSessionAttributes() {
        this.initialiseNavigator();
        this.navigator.next();
        return this.navigator.getCurrent();
    }

    public void setResultType(int n) {
        this.mode = (byte)n;
    }

    public void setStatementType(int n) {
        this.statementReturnType = n;
    }

    public int getStatementType() {
        return this.statementReturnType;
    }

    public void setSessionRandomID(int n) {
        this.generateKeys = n;
    }

    public int getSessionRandomID() {
        return this.generateKeys;
    }

    public int getGeneratedResultType() {
        return this.generateKeys;
    }

    public ResultMetaData getGeneratedResultMetaData() {
        return this.generatedMetaData;
    }

    public Result getChainedResult() {
        return this.chainedResult;
    }

    public Result getUnlinkChainedResult() {
        Result result = this.chainedResult;
        this.chainedResult = null;
        return result;
    }

    public void addChainedResult(Result result) {
        Result result2 = this;
        while (result2.chainedResult != null) {
            result2 = result2.chainedResult;
        }
        result2.chainedResult = result;
    }

    public void addWarnings(HsqlException[] hsqlExceptionArray) {
        for (int i = 0; i < hsqlExceptionArray.length; ++i) {
            Result result = Result.newWarningResult(hsqlExceptionArray[i]);
            this.addChainedResult(result);
        }
    }

    public int getLobCount() {
        return this.lobCount;
    }

    public ResultLob getLOBResult() {
        return this.lobResults;
    }

    public void addLobResult(ResultLob resultLob) {
        Result result = this;
        while (result.lobResults != null) {
            result = result.lobResults;
        }
        result.lobResults = resultLob;
        ++this.lobCount;
    }

    public void clearLobResults() {
        this.lobResults = null;
        this.lobCount = 0;
    }

    public void addRows(List<String> list) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object[] objectArray = new String[]{list.get(i)};
            this.initialiseNavigator().add(objectArray);
        }
    }

    private static Object[] readSimple(RowInputInterface rowInputInterface, ResultMetaData resultMetaData) {
        int n = rowInputInterface.readInt();
        return rowInputInterface.readData(resultMetaData.columnTypes);
    }

    private static void writeSimple(RowOutputInterface rowOutputInterface, ResultMetaData resultMetaData, Object[] objectArray) {
        rowOutputInterface.writeInt(1);
        rowOutputInterface.writeData(resultMetaData.getColumnCount(), resultMetaData.columnTypes, objectArray, null, null);
    }

    public RowSetNavigator getNavigator() {
        return this.navigator;
    }

    public void setNavigator(RowSetNavigator rowSetNavigator) {
        this.navigator = rowSetNavigator;
    }

    public RowSetNavigator initialiseNavigator() {
        switch (this.mode) {
            case 6: 
            case 8: 
            case 9: 
            case 16: 
            case 17: {
                this.navigator.beforeFirst();
                return this.navigator;
            }
            case 3: 
            case 15: 
            case 20: {
                this.navigator.reset();
                return this.navigator;
            }
        }
        throw Error.runtimeError(201, "Result");
    }

    static {
        SqlInvariants.isSystemSchemaName("SYSTEM_SCHEMA");
        Charset.getDefaultInstance();
        Collation.getDefaultInstance();
        sessionAttributesMetaData = ResultMetaData.newResultMetaData(4);
        for (int i = 0; i < 4; ++i) {
            Result.sessionAttributesMetaData.columns[i] = new ColumnBase(null, null, null, null);
        }
        Result.sessionAttributesMetaData.columns[0].setType(Type.SQL_INTEGER);
        Result.sessionAttributesMetaData.columns[1].setType(Type.SQL_INTEGER);
        Result.sessionAttributesMetaData.columns[2].setType(Type.SQL_BOOLEAN);
        Result.sessionAttributesMetaData.columns[3].setType(Type.SQL_VARCHAR);
        sessionAttributesMetaData.prepareData();
        emptyMeta = ResultMetaData.newResultMetaData(0);
        emptyGeneratedResult = Result.newDataResult(emptyMeta);
        updateZeroResult = Result.newUpdateCountResult(0);
        updateOneResult = Result.newUpdateCountResult(1);
    }
}

