/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.internal.build.event.types.AbstractOperationResult;
import org.gradle.internal.build.event.types.DefaultBuildPhaseDescriptor;
import org.gradle.internal.build.event.types.DefaultFailure;
import org.gradle.internal.build.event.types.DefaultFailureResult;
import org.gradle.internal.build.event.types.DefaultOperationDescriptor;
import org.gradle.internal.build.event.types.DefaultOperationFinishedProgressEvent;
import org.gradle.internal.build.event.types.DefaultOperationStartedProgressEvent;
import org.gradle.internal.build.event.types.DefaultSuccessResult;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationStartedProgressEvent;
import org.gradle.tooling.internal.provider.runner.ProgressEventConsumer;

public class BuildPhaseOperationListener
implements BuildOperationListener {
    private static final Set<BuildOperationCategory> SUPPORTED_CATEGORIES = Collections.unmodifiableSet(EnumSet.of(BuildOperationCategory.CONFIGURE_ROOT_BUILD, BuildOperationCategory.CONFIGURE_BUILD, BuildOperationCategory.RUN_MAIN_TASKS, BuildOperationCategory.RUN_WORK));
    private final ProgressEventConsumer eventConsumer;
    private final BuildOperationIdFactory idFactory;
    private final Map<OperationIdentifier, DefaultBuildPhaseDescriptor> descriptors;

    public BuildPhaseOperationListener(ProgressEventConsumer eventConsumer, BuildOperationIdFactory idFactory) {
        this.eventConsumer = eventConsumer;
        this.idFactory = idFactory;
        this.descriptors = new ConcurrentHashMap<OperationIdentifier, DefaultBuildPhaseDescriptor>();
    }

    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        if (!this.isSupportedBuildOperation(buildOperation)) {
            return;
        }
        DefaultBuildPhaseDescriptor descriptor = this.toBuildOperationDescriptor(buildOperation);
        this.descriptors.put(buildOperation.getId(), descriptor);
        this.eventConsumer.started((InternalOperationStartedProgressEvent)new DefaultOperationStartedProgressEvent(startEvent.getStartTime(), (DefaultOperationDescriptor)descriptor));
    }

    private DefaultBuildPhaseDescriptor toBuildOperationDescriptor(BuildOperationDescriptor buildOperation) {
        OperationIdentifier operationId = new OperationIdentifier(this.idFactory.nextId());
        OperationIdentifier parent = this.eventConsumer.findStartedParentId(buildOperation);
        String name = buildOperation.getName();
        String displayName = "Build phase: " + buildOperation.getDisplayName();
        String buildPhase = buildOperation.getMetadata().toString();
        return new DefaultBuildPhaseDescriptor(operationId, name, displayName, parent, buildPhase, buildOperation.getTotalProgress());
    }

    public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent progressEvent) {
    }

    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
        if (!this.isSupportedBuildOperation(buildOperation)) {
            return;
        }
        DefaultBuildPhaseDescriptor descriptor = this.descriptors.remove(buildOperation.getId());
        if (descriptor != null) {
            long endTime = finishEvent.getEndTime();
            AbstractOperationResult result = this.toOperationResult(finishEvent);
            this.eventConsumer.finished((InternalOperationFinishedProgressEvent)new DefaultOperationFinishedProgressEvent(endTime, (DefaultOperationDescriptor)descriptor, result));
        }
    }

    private AbstractOperationResult toOperationResult(OperationFinishEvent finishEvent) {
        long startTime = finishEvent.getStartTime();
        long endTime = finishEvent.getEndTime();
        if (finishEvent.getFailure() != null) {
            return new DefaultFailureResult(startTime, endTime, Collections.singletonList(DefaultFailure.fromThrowable((Throwable)finishEvent.getFailure())));
        }
        return new DefaultSuccessResult(startTime, endTime);
    }

    private boolean isSupportedBuildOperation(BuildOperationDescriptor buildOperation) {
        return buildOperation.getMetadata() instanceof BuildOperationCategory && SUPPORTED_CATEGORIES.contains(buildOperation.getMetadata());
    }
}

