/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.coverage;

import com.google.inject.Singleton;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

@Singleton
public class CoverageNameMapper {
    private final AtomicInteger id = new AtomicInteger(0);
    private final ConcurrentMap<Integer, String> idToNameMap = new ConcurrentHashMap<Integer, String>();
    private final ConcurrentMap<String, Integer> nameToIdMap = new ConcurrentHashMap<String, Integer>();

    public Integer map(String filePath) {
        if (this.nameToIdMap.containsKey(filePath)) {
            return (Integer)this.nameToIdMap.get(filePath);
        }
        Integer pathId = this.id.getAndIncrement();
        this.idToNameMap.put(pathId, filePath);
        this.nameToIdMap.put(filePath, pathId);
        return pathId;
    }

    public String unmap(Integer fileId) {
        return (String)this.idToNameMap.get(fileId);
    }
}

