/*
 * Copyright 2011 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * The first half of the angular json wrapper.
 * @author corbinrsmith@gmail.com (Cory Smith)
 */

jstestdriver.angular = (function (angular, JSON, jQuery) {
  angular = angular || {};
  var _null = null;
  var $null = 'null';
  var _undefined;
  var $undefined = 'undefined';
  var $function = 'function';
  
  // library functions for angular.
  var isNumber = function (obj) {
    return (typeof obj).toLowerCase() == 'number' || obj instanceof Number;
  };
  
  var isObject = function (obj) {
    return obj != null && (typeof obj).toLowerCase() == 'object';
  };

  var isString = function (obj) {
    return (typeof obj).toLowerCase() == 'string' || obj instanceof String;
  };

  var isArray = function (obj) {
    return obj instanceof Array;
  };

  var isFunction = function (obj) {
    return (typeof obj).toLowerCase() == 'function';
  }

  var isBoolean = function (obj) {
    return (typeof obj).toLowerCase() == 'boolean' || obj instanceof Boolean;
  };

  var isUndefined = function (obj) {
    return (typeof obj).toLowerCase() == 'undefined';
  };

  var isDate = function (obj) {
    return obj instanceof Date;
  };

  var forEach = function (coll, callback) {
    jQuery.each(coll, function (index, value){
      return callback(value, index);
    });
  }

  function includes(arr, obj) {
    for (var i = 0; i < arr.length; i++) {
      if (arr[i] === obj) {
        return true;
      }
    }
    return false;
  }

  // extracted from https://github.com/angular/angular.js/blob/master/src/filters.js
  // Lines 106..129, 
  function padNumber(num, digits, trim) {
    var neg = '';
    if (num < 0) {
      neg =  '-';
      num = -num;
    }
    num = '' + num;
    while(num.length < digits) num = '0' + num;
    if (trim)
      num = num.substr(num.length - digits);
    return neg + num;
  }
  
  // extracted from https://github.com/angular/angular.js/blob/master/src/apis.js
  // Lines 721..782, 
  var R_ISO8061_STR = /^(\d{4})-(\d\d)-(\d\d)(?:T(\d\d)(?:\:(\d\d)(?:\:(\d\d)(?:\.(\d{3}))?)?)?Z)?$/;

  angular['String'] = {
    'quote':function(string) {
      return '"' + string.replace(/\\/g, '\\\\').
                          replace(/"/g, '\\"').
                          replace(/\n/g, '\\n').
                          replace(/\f/g, '\\f').
                          replace(/\r/g, '\\r').
                          replace(/\t/g, '\\t').
                          replace(/\v/g, '\\v') +
               '"';
    },
    'quoteUnicode':function(string) {
      var str = angular['String']['quote'](string);
      var chars = [];
      for ( var i = 0; i < str.length; i++) {
        var ch = str.charCodeAt(i);
        if (ch < 128) {
          chars.push(str.charAt(i));
        } else {
          var encode = "000" + ch.toString(16);
          chars.push("\\u" + encode.substring(encode.length - 4));
        }
      }
      return chars.join('');
    },

    /**
     * Tries to convert input to date and if successful returns the date, otherwise returns the input.
     * @param {string} string
     * @return {(Date|string)}
     */
    'toDate':function(string){
      var match;
      if (isString(string) && (match = string.match(R_ISO8061_STR))){
        var date = new Date(0);
        date.setUTCFullYear(match[1], match[2] - 1, match[3]);
        date.setUTCHours(match[4]||0, match[5]||0, match[6]||0, match[7]||0);
        return date;
      }
      return string;
    }
  };

  angular['Date'] = {
      'toString':function(date){
        return !date ?
                  date :
                  date.toISOString ?
                    date.toISOString() :
                    padNumber(date.getUTCFullYear(), 4) + '-' +
                    padNumber(date.getUTCMonth() + 1, 2) + '-' +
                    padNumber(date.getUTCDate(), 2) + 'T' +
                    padNumber(date.getUTCHours(), 2) + ':' +
                    padNumber(date.getUTCMinutes(), 2) + ':' +
                    padNumber(date.getUTCSeconds(), 2) + '.' +
                    padNumber(date.getUTCMilliseconds(), 3) + 'Z';
      }
    };
  /*The MIT License

Copyright (c) 2010 Adam Abrons and Misko Hevery http://getangular.com

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

var array = [].constructor;

/**
 * @workInProgress
 * @ngdoc function
 * @name angular.toJson
 * @function
 *
 * @description
 * Serializes the input into a JSON formated string.
 *
 * @param {Object|Array|Date|string|number} obj Input to jsonify.
 * @param {boolean=} pretty If set to true, the JSON output will contain newlines and whitespace.
 * @returns {string} Jsonified string representing `obj`.
 */
function toJson(obj, pretty) {
  var buf = [];
  toJsonArray(buf, obj, pretty ? "\n  " : _null, []);
  return buf.join('');
}

/**
 * @workInProgress
 * @ngdoc function
 * @name angular.fromJson
 * @function
 *
 * @description
 * Deserializes a string in the JSON format.
 *
 * @param {string} json JSON string to deserialize.
 * @param {boolean} [useNative=false] Use native JSON parser if available
 * @returns {Object|Array|Date|string|number} Deserialized thingy.
 */
function fromJson(json, useNative) {
  if (!isString(json)) return json;

  var obj, p, expression;

  try {
    if (useNative && JSON && JSON.parse) {
      obj = JSON.parse(json);
      return transformDates(obj);
    }

    p = parser(json, true);
    expression =  p.primary();
    p.assertAllConsumed();
    return expression();

  } catch (e) {
    error("fromJson error: ", json, e);
    throw e;
  }

  // TODO make forEach optionally recursive and remove this function
  function transformDates(obj) {
    if (isString(obj) && obj.length === DATE_ISOSTRING_LN) {
      return angularString.toDate(obj);
    } else if (isArray(obj) || isObject(obj)) {
      forEach(obj, function(val, name) {
        obj[name] = transformDates(val);
      });
    }
    return obj;
  }
}

angular['toJson'] = toJson;
angular['fromJson'] = fromJson;

function toJsonArray(buf, obj, pretty, stack) {
  if (isObject(obj)) {
    if (obj === window) {
      buf.push('WINDOW');
      return;
    }

    if (obj === document) {
      buf.push('DOCUMENT');
      return;
    }

    if (includes(stack, obj)) {
      buf.push('RECURSION');
      return;
    }
    stack.push(obj);
  }
  if (obj === _null) {
    buf.push($null);
  } else if (obj instanceof RegExp) {
    buf.push(angular['String']['quoteUnicode'](obj.toString()));
  } else if (isFunction(obj)) {
    return;
  } else if (isBoolean(obj)) {
    buf.push('' + obj);
  } else if (isNumber(obj)) {
    if (isNaN(obj)) {
      buf.push($null);
    } else {
      buf.push('' + obj);
    }
  } else if (isString(obj)) {
    return buf.push(angular['String']['quoteUnicode'](obj));
  } else if (isObject(obj)) {
    if (isArray(obj)) {
      buf.push("[");
      var len = obj.length;
      var sep = false;
      for(var i=0; i<len; i++) {
        var item = obj[i];
        if (sep) buf.push(",");
        if (!(item instanceof RegExp) && (isFunction(item) || isUndefined(item))) {
          buf.push($null);
        } else {
          toJsonArray(buf, item, pretty, stack);
        }
        sep = true;
      }
      buf.push("]");
    } else if (isDate(obj)) {
      buf.push(angular['String']['quoteUnicode'](angular['Date']['toString'](obj)));
    } else {
      buf.push("{");
      if (pretty) buf.push(pretty);
      var comma = false;
      var childPretty = pretty ? pretty + "  " : false;
      var keys = [];
      for(var k in obj) {
        if (obj[k] === _undefined)
          continue;
        keys.push(k);
      }
      keys.sort();
      for ( var keyIndex = 0; keyIndex < keys.length; keyIndex++) {
        var key = keys[keyIndex];
        var value = obj[key];
        if (typeof value != $function) {
          if (comma) {
            buf.push(",");
            if (pretty) buf.push(pretty);
          }
          buf.push(angular['String']['quote'](key));
          buf.push(":");
          toJsonArray(buf, value, childPretty, stack);
          comma = true;
        }
      }
      buf.push("}");
    }
  }
  if (isObject(obj)) {
    stack.pop();
  }
}
/*
 * Copyright 2011 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
/**
 * The second half of the angular json wrapper.
 * @author corbinrsmith@gmail.com (Cory Smith)
 */

  angular.toJson = toJson;
  angular.fromJson = fromJson;
  return angular;
})(jstestdriver.angular, jstestdriver.JSON, jstestdriver.jQuery);
jstestdriver.Signal=function(a){this.value_=a};jstestdriver.Signal.prototype.get=function(){return this.value_};jstestdriver.Signal.prototype.set=function(a){this.value_=a};jstestdriver.RESPONSE_TYPES={FILE_LOAD_RESULT:"FILE_LOAD_RESULT",REGISTER_RESULT:"REGISTER_RESULT",TEST_RESULT:"TEST_RESULT",TEST_QUERY_RESULT:"TEST_QUERY_RESULT",RESET_RESULT:"RESET_RESULT",COMMAND_RESULT:"COMMAND_RESULT",BROWSER_READY:"BROWSER_READY",BROWSER_PANIC:"BROWSER_PANIC",NOOP:"NOOP",LOG:"LOG"};jstestdriver.Response=function(c,a,b,d){this.type=c;this.response=a;this.browser=b;if(d){this.start=true}};jstestdriver.Response.prototype.toString=function(){return"Response(\nresponse="+this.response+",\ntype"+this.type+",\n browser="+this.browser+")"};jstestdriver.CommandResponse=function(a,b){this.done=a;this.response=b};jstestdriver.BrowserInfo=function(a){this.id=a};jstestdriver.BrowserLog=function(d,c,b,a){this.level=d;this.source=c;this.message=b;this.browser=a};function expectAsserts(a){jstestdriver.expectedAssertCount=a}this.fail=function fail(b){var a=new Error(b);a.name="AssertError";if(!a.message){a.message=b}throw a};function isBoolean_(a){if(typeof(a)!="boolean"){this.fail("Not a boolean: "+this.prettyPrintEntity_(a))}}var isElement_=(function(){var c=document.createElement("div");function b(f){try{c.appendChild(f);c.removeChild(f)}catch(d){return false}return true}return function a(d){return d&&d.nodeType===1&&b(d)}}());function formatElement_(f){var d;try{d=f.tagName.toLowerCase();var j="<"+d;var b=f.attributes,g;for(var c=0,a=b.length;c<a;c++){g=b.item(c);if(!!g.nodeValue){j+=" "+g.nodeName+'="'+g.nodeValue+'"'}}return j+">...</"+d+">"}catch(h){return"[Element]"+(!!d?" "+d:"")}}function prettyPrintEntity_(a){if(isElement_(a)){return formatElement_(a)}var c;if(typeof a=="function"){try{c=a.toString().match(/(function [^\(]+\(\))/)[1]}catch(b){}return c||"[function]"}try{c=this.JSON.stringify(a)}catch(b){}return c||"["+typeof a+"]"}function argsWithOptionalMsg_(b,e){var a=[];for(var d=0;d<b.length;d++){a.push(b[d])}var c=e-1;if(b.length<c){this.fail("expected at least "+c+" arguments, got "+b.length)}else{if(b.length==e){a[0]+=" "}else{a.unshift("")}}return a}function assertTrue(b,c){var a=this.argsWithOptionalMsg_(arguments,2);jstestdriver.assertCount++;isBoolean_(a[1]);if(a[1]!=true){this.fail(a[0]+"expected true but was "+this.prettyPrintEntity_(a[1]))}return true}function assertFalse(b,c){var a=this.argsWithOptionalMsg_(arguments,2);jstestdriver.assertCount++;isBoolean_(a[1]);if(a[1]!=false){this.fail(a[0]+"expected false but was "+this.prettyPrintEntity_(a[1]))}return true}function assertEquals(c,b,d){var a=this.argsWithOptionalMsg_(arguments,3);jstestdriver.assertCount++;c=a[0];b=a[1];d=a[2];if(!compare_(b,d)){this.fail(c+"expected "+this.prettyPrintEntity_(b)+" but was "+this.prettyPrintEntity_(d)+"")}return true}function compare_(g,j){if(g===j){return true}if(typeof g!="object"||typeof j!="object"||!g||!j){return g==j}if(isElement_(g)||isElement_(j)){return false}var d=null;var f=0;var b=0;try{if(jstestdriver.jQuery.isArray(j)){f=j.length}else{for(d in j){if(j.hasOwnProperty(d)){++f}}}if(f==0&&typeof j.length=="number"){f=j.length;for(var c=0,a=f;c<a;c++){if(!(c in j)){f=0;break}}}for(d in g){if(g.hasOwnProperty(d)){if(!compare_(g[d],j[d])){return false}++b}}if(b!=f){return false}return b==0?g.toString()==j.toString():true}catch(h){return false}}function assertNotEquals(d,b,f){try{assertEquals.apply(this,arguments)}catch(c){if(c.name=="AssertError"){return true}throw c}var a=this.argsWithOptionalMsg_(arguments,3);this.fail(a[0]+"expected "+this.prettyPrintEntity_(a[1])+" not to be equal to "+this.prettyPrintEntity_(a[2]))}function assertSame(c,b,d){var a=this.argsWithOptionalMsg_(arguments,3);jstestdriver.assertCount++;if(!isSame_(a[2],a[1])){this.fail(a[0]+"expected "+this.prettyPrintEntity_(a[1])+" but was "+this.prettyPrintEntity_(a[2]))}return true}function assertNotSame(c,b,d){var a=this.argsWithOptionalMsg_(arguments,3);jstestdriver.assertCount++;if(isSame_(a[2],a[1])){this.fail(a[0]+"expected not same as "+this.prettyPrintEntity_(a[1])+" but was "+this.prettyPrintEntity_(a[2]))}return true}function isSame_(a,b){return b===a}function assertNull(b,c){var a=this.argsWithOptionalMsg_(arguments,2);jstestdriver.assertCount++;if(a[1]!==null){this.fail(a[0]+"expected null but was "+this.prettyPrintEntity_(a[1]))}return true}function assertNotNull(b,c){var a=this.argsWithOptionalMsg_(arguments,2);jstestdriver.assertCount++;if(a[1]===null){this.fail(a[0]+"expected not null but was null")}return true}function assertUndefined(b,c){var a=this.argsWithOptionalMsg_(arguments,2);jstestdriver.assertCount++;if(typeof a[1]!="undefined"){this.fail(a[2]+"expected undefined but was "+this.prettyPrintEntity_(a[1]))}return true}function assertNotUndefined(b,c){var a=this.argsWithOptionalMsg_(arguments,2);jstestdriver.assertCount++;if(typeof a[1]=="undefined"){this.fail(a[0]+"expected not undefined but was undefined")}return true}function assertNaN(b,c){var a=this.argsWithOptionalMsg_(arguments,2);jstestdriver.assertCount++;if(!isNaN(a[1])){this.fail(a[0]+"expected to be NaN but was "+a[1])}return true}function assertNotNaN(b,c){var a=this.argsWithOptionalMsg_(arguments,2);jstestdriver.assertCount++;if(isNaN(a[1])){this.fail(a[0]+"expected not to be NaN")}return true}function assertException(c,d,a){if(arguments.length==1){d=c;c=""}else{if(arguments.length==2){if(typeof d!="function"){a=d;d=c;c=""}else{c+=" "}}else{c+=" "}}jstestdriver.assertCount++;try{d()}catch(b){if(b.name=="AssertError"){throw b}if(a&&b.name!=a){this.fail(c+"expected to throw "+a+" but threw "+b.name)}return true}this.fail(c+"expected to throw exception")}function assertNoException(c,d){var a=this.argsWithOptionalMsg_(arguments,2);jstestdriver.assertCount++;try{a[1]()}catch(b){fail(a[0]+"expected not to throw exception, but threw "+b.name+" ("+b.message+")")}}function assertArray(b,c){var a=this.argsWithOptionalMsg_(arguments,2);jstestdriver.assertCount++;if(!jstestdriver.jQuery.isArray(a[1])){fail(a[0]+"expected to be array, but was "+this.prettyPrintEntity_(a[1]))}}function assertTypeOf(d,b,c){var a=this.argsWithOptionalMsg_(arguments,3);jstestdriver.assertCount++;var e=typeof a[2];if(e!=a[1]){this.fail(a[0]+"expected to be "+a[1]+" but was "+e)}return true}function assertBoolean(b,c){var a=this.argsWithOptionalMsg_(arguments,2);return assertTypeOf(a[0],"boolean",a[1])}function assertFunction(b,c){var a=this.argsWithOptionalMsg_(arguments,2);return assertTypeOf(a[0],"function",a[1])}function assertObject(b,c){var a=this.argsWithOptionalMsg_(arguments,2);return assertTypeOf(a[0],"object",a[1])}function assertNumber(b,c){var a=this.argsWithOptionalMsg_(arguments,2);return assertTypeOf(a[0],"number",a[1])}function assertString(b,c){var a=this.argsWithOptionalMsg_(arguments,2);return assertTypeOf(a[0],"string",a[1])}function assertMatch(e,d,f){var b=this.argsWithOptionalMsg_(arguments,3);var c=typeof b[2]=="undefined";jstestdriver.assertCount++;var a;if(c||!b[1].test(b[2])){f=(c?a:this.prettyPrintEntity_(b[2]));this.fail(b[0]+"expected "+f+" to match "+b[1])}return true}function assertNoMatch(c,b,d){var a=this.argsWithOptionalMsg_(arguments,3);jstestdriver.assertCount++;if(a[1].test(a[2])){this.fail(a[0]+"expected "+this.prettyPrintEntity_(a[2])+" not to match "+a[1])}return true}function assertTagName(d,c,b){var a=this.argsWithOptionalMsg_(arguments,3);var e=a[2]&&a[2].tagName;if(String(e).toUpperCase()!=a[1].toUpperCase()){this.fail(a[0]+"expected tagName to be "+a[1]+" but was "+e)}return true}function assertClassName(g,c,b){var a=this.argsWithOptionalMsg_(arguments,3);var h=a[2]&&a[2].className;var d=new RegExp("(^|\\s)"+a[1]+"(\\s|$)");try{this.assertMatch(a[0],d,h)}catch(f){h=this.prettyPrintEntity_(h);this.fail(a[0]+"expected class name to include "+this.prettyPrintEntity_(a[1])+" but was "+h)}return true}function assertElementId(c,e,b){var a=this.argsWithOptionalMsg_(arguments,3);var d=a[2]&&a[2].id;jstestdriver.assertCount++;if(d!==a[1]){this.fail(a[0]+"expected id to be "+a[1]+" but was "+d)}return true}function assertInstanceOf(e,c,f){jstestdriver.assertCount++;var a=this.argsWithOptionalMsg_(arguments,3);var b=this.prettyPrintEntity_(a[2]);var d=a[1]&&a[1].name||a[1];if(a[2]==null){this.fail(a[0]+"expected "+b+" to be instance of "+d)}if(!(Object(a[2]) instanceof a[1])){this.fail(a[0]+"expected "+b+" to be instance of "+d)}return true}function assertNotInstanceOf(e,c,f){var a=this.argsWithOptionalMsg_(arguments,3);jstestdriver.assertCount++;if(Object(a[2]) instanceof a[1]){var d=a[1]&&a[1].name||a[1];var b=this.prettyPrintEntity_(a[2]);this.fail(a[0]+"expected "+b+" not to be instance of "+d)}return true}var assert=assertTrue;jstestdriver.StreamingService=function(c,b,d,a){this.url_=c;this.now_=b;this.post_=d;this.activeResponses_={};this.completeFinalResponse=null;this.synchPost_=a};jstestdriver.StreamingService.prototype.synchClose=function(a){var b=new jstestdriver.CommandResponse(true,a);console.info("synch call");this.synchPost_(this.url_,b)};jstestdriver.StreamingService.prototype.stream=function(a,b){this.streamResponse(a,false,b)};jstestdriver.StreamingService.prototype.streamResponse=function(b,a,d){var c=new jstestdriver.CommandResponse(a,b);if(!a&&b!=null){c.responseId=this.now_();this.activeResponses_[c.responseId]=c}this.post_(this.url_,c,d,"text/plain")};jstestdriver.StreamingService.prototype.streamAcknowledged=function(a){for(var b=0;a&&a[b];b++){if(this.activeResponses_[a[b]]){this.activeResponses_[a[b]]=null;delete this.activeResponses_[a[b]]}}if(this.completeFinalResponse){this.completeFinalResponse()}};jstestdriver.StreamingService.prototype.close=function(b,c){var a=this;this.completeFinalResponse=function(){if(a.hasOpenResponses()){a.streamResponse(null,false,c)}else{a.completeFinalResponse=null;a.activeResponses_={};a.streamResponse(b,true,c)}};this.completeFinalResponse()};jstestdriver.StreamingService.prototype.hasOpenResponses=function(){for(var a in this.activeResponses_){if(this.activeResponses_.hasOwnProperty(a)){return true}}return false};jstestdriver.FileSource=function(b,a,c){this.fileSrc=b;this.timestamp=a;this.basePath=c};jstestdriver.FileResult=function(b,d,c,a){this.file=b;this.success=d;this.message=c;this.elapsed=a};jstestdriver.FileResult.prototype.toString=function(){return["FileResult(",this.file.fileSrc,this.success,this.message,")"].join("")};jstestdriver.JSON=JSON;jstestdriver.FORMAT_MAPPINGS={"s":function(a){if(a==undefined){return""}return String(a)},"d":Number,"i":parseInt,"f":parseFloat,"o":jstestdriver.JSON.stringify};jstestdriver.formatString=function(e){var c=arguments;var a=1;var d=String(e).replace(/%([sdifo])/g,function(f,g){var h=c[a++];if(!jstestdriver.FORMAT_MAPPINGS[g]){throw new Error(g+"is not a proper format.")}if(h===undefined||h===null){return h}return jstestdriver.FORMAT_MAPPINGS[g](h)});while(a<c.length){var b=c[a++];if(typeof b=="object"){b=JSON.stringify(b)}d+=" "+b}return d};jstestdriver.convertToJson=function(b){var a=jstestdriver.parameterSerialize;return function(c,e,f,d){b(c,a(e),f,d)}};jstestdriver.parameterSerialize=function(c){var b={};for(var a in c){b[a]=JSON.stringify(c[a])}return b};jstestdriver.bind=function(a,c){function b(){return c.apply(a,arguments)}b.toString=function(){return"bound: "+a+" to: "+c};return b};jstestdriver.extractId=function(a){return a.match(/\/id\/(\d+)\//)[1]};jstestdriver.createPath=function(c,b){var a=c.match(/^(.*)\/(slave|runner|bcr)\//)[1];return a+b};jstestdriver.getBrowserFriendlyName=function(){if(jstestdriver.jQuery.browser.safari){if(navigator.userAgent.indexOf("Chrome")!=-1){return"Chrome"}return"Safari"}else{if(jstestdriver.jQuery.browser.opera){return"Opera"}else{if(jstestdriver.jQuery.browser.msie){return"Internet Explorer"}else{if(jstestdriver.jQuery.browser.mozilla){if(navigator.userAgent.indexOf("Firefox")!=-1){return"Firefox"}return"Mozilla"}}}}};jstestdriver.getBrowserFriendlyVersion=function(){if(jstestdriver.jQuery.browser.msie){if(typeof XDomainRequest!="undefined"){return"8.0"}}else{if(jstestdriver.jQuery.browser.safari){if(navigator.appVersion.indexOf("Chrome/")!=-1){return navigator.appVersion.match(/Chrome\/(.*)\s/)[1]}}}return jstestdriver.jQuery.browser.version};jstestdriver.trim=function(a){return a.replace(/(^\s*)|(\s*$)/g,"")};jstestdriver.toHtml=function(c,e){var b=e.createDocumentFragment();var d=e.createElement("div");d.innerHTML=jstestdriver.trim(jstestdriver.stripHtmlComments(c));while(d.firstChild){b.appendChild(d.firstChild)}var a=b.childNodes.length>1?b:b.firstChild;return a};jstestdriver.stripHtmlComments=function(b){var d=[];function a(h){var i=b.indexOf("<!--",h);var g=b.indexOf("-->",h)+"-->".length;if(i==-1){return null}return{"start":i,"stop":g}}var c=0;while(true){var f=a(c);if(!f){d.push(b.slice(c));break}var e=b.slice(c,f.start);d.push(e);c=f.stop}return d.join("")};jstestdriver.appendHtml=function(b,c){var a=jstestdriver.toHtml(b,c);jstestdriver.jQuery(c.body).append(a)};jstestdriver.now=function(){return new Date().getTime()};jstestdriver.createSynchPost=function(a){return jstestdriver.convertToJson(function(b,c){return a.ajax({"async":false,"data":c,"type":"POST","url":b})})};jstestdriver.Console=function(){this.log_=[]};jstestdriver.Console.prototype.log=function(){this.logStatement("[LOG]",jstestdriver.formatString.apply(this,arguments))};jstestdriver.Console.prototype.debug=function(){this.logStatement("[DEBUG]",jstestdriver.formatString.apply(this,arguments))};jstestdriver.Console.prototype.info=function(){this.logStatement("[INFO]",jstestdriver.formatString.apply(this,arguments))};jstestdriver.Console.prototype.warn=function(){this.logStatement("[WARN]",jstestdriver.formatString.apply(this,arguments))};jstestdriver.Console.prototype.error=function(){this.logStatement("[ERROR]",jstestdriver.formatString.apply(this,arguments))};jstestdriver.Console.prototype.logStatement=function(b,a){this.log_.push(b+" "+a)};jstestdriver.Console.prototype.getLog=function(){var a=this.log_;return a.join("\n")};jstestdriver.Console.prototype.getAndResetLog=function(){var a=this.getLog();this.log_=[];return a};jstestdriver.PluginRegistrar=function(){this.plugins_=[]};jstestdriver.PluginRegistrar.PROCESS_TEST_RESULT="processTestResult";jstestdriver.PluginRegistrar.LOAD_SOURCE="loadSource";jstestdriver.PluginRegistrar.RUN_TEST="runTestConfiguration";jstestdriver.PluginRegistrar.IS_FAILURE="isFailure";jstestdriver.PluginRegistrar.GET_TEST_RUN_CONFIGURATIONS="getTestRunsConfigurationFor";jstestdriver.PluginRegistrar.ON_TESTS_START="onTestsStart";jstestdriver.PluginRegistrar.ON_TESTS_FINISH="onTestsFinish";jstestdriver.PluginRegistrar.prototype.register=function(c){if(!c.name){throw new Error("Plugins must define a name.")}var a=this.getIndexOfPlugin_(c.name);var b=1;if(a==-1){a=this.plugins_.length-1;b=0}this.plugins_.splice(a,b,c)};jstestdriver.PluginRegistrar.prototype.unregister=function(b){var a=this.getIndexOfPlugin_(b.name);if(a!=-1){this.plugins_.splice(a,1)}};jstestdriver.PluginRegistrar.prototype.getPlugin=function(b){var a=this.getIndexOfPlugin_(b);return a!=-1?this.plugins_[a]:null};jstestdriver.PluginRegistrar.prototype.getNumberOfRegisteredPlugins=function(){return this.plugins_.length};jstestdriver.PluginRegistrar.prototype.dispatch_=function(e,d){var b=this.plugins_.length;for(var a=0;a<b;a++){var c=this.plugins_[a];if(c[e]){if(c[e].apply(c,d)){return true}}}return false};jstestdriver.PluginRegistrar.prototype.getIndexOfPlugin_=function(a){var c=this.plugins_.length;for(var b=0;b<c;b++){var d=this.plugins_[b];if(d.name==a){return b}}return -1};jstestdriver.PluginRegistrar.prototype.loadSource=function(b,a){this.dispatch_(jstestdriver.PluginRegistrar.LOAD_SOURCE,arguments)};jstestdriver.PluginRegistrar.prototype.runTestConfiguration=function(a,b,c){this.dispatch_(jstestdriver.PluginRegistrar.RUN_TEST,arguments)};jstestdriver.PluginRegistrar.prototype.processTestResult=function(a){this.dispatch_(jstestdriver.PluginRegistrar.PROCESS_TEST_RESULT,arguments)};jstestdriver.PluginRegistrar.prototype.isFailure=function(a){return this.dispatch_(jstestdriver.PluginRegistrar.IS_FAILURE,arguments)};jstestdriver.PluginRegistrar.prototype.getTestRunsConfigurationFor=function(c,b,a){return this.dispatch_(jstestdriver.PluginRegistrar.GET_TEST_RUN_CONFIGURATIONS,arguments)};jstestdriver.PluginRegistrar.prototype.onTestsStart=function(){return this.dispatch_(jstestdriver.PluginRegistrar.ON_TESTS_START,[])};jstestdriver.PluginRegistrar.prototype.onTestsFinish=function(){return this.dispatch_(jstestdriver.PluginRegistrar.ON_TESTS_FINISH,[])};jstestdriver.LibLoader=function(b,c,a){this.files_=b;this.dom_=c;this.getScript_=a;this.remainingLibToLoad_=this.files_.length;this.boundOnLibLoaded_=jstestdriver.bind(this,this.onLibLoaded);this.savedDocumentWrite_=c.write;this.currentFile_=0};jstestdriver.LibLoader.prototype.load=function(a,b){if(this.files_.length==0){a(b)}else{this.dom_.write=function(){};this.onAllLibLoaded_=a;this.data_=b;this.getScript_(this.dom_,this.files_[this.currentFile_++],this.boundOnLibLoaded_)}};jstestdriver.LibLoader.prototype.onLibLoaded=function(){if(--this.remainingLibToLoad_==0){var a=this.onAllLibLoaded_;var b=this.data_;this.onAllLibLoaded_=null;this.data_=null;this.dom_.write=this.savedDocumentWrite_;a(b)}else{this.getScript_(this.dom_,this.files_[this.currentFile_++],this.boundOnLibLoaded_)}};jstestdriver.FileLoader=function(a,b){this.pluginRegistrar_=a;this.onAllFilesLoaded_=b;this.boundOnFileLoaded=jstestdriver.bind(this,this.onFileLoaded_);this.boundLoadFile_=jstestdriver.bind(this,this.onLoadFile_);this.loadedFiles_=[]};jstestdriver.FileLoader.prototype.load=function(a){this.files_=a;if(this.files_.length>0){this.loadFile_(this.files_.shift())}else{this.onAllFilesLoaded_({loadedFiles:[]})}};jstestdriver.FileLoader.prototype.loadFile_=function(a){this.pluginRegistrar_.loadSource(a,this.boundOnFileLoaded)};jstestdriver.FileLoader.prototype.onFileLoaded_=function(a){this.loadedFiles_.push(a);if(this.files_.length==0){this.onAllFilesLoaded_({loadedFiles:this.loadedFiles_})}else{this.loadFile_(this.files_.shift())}};jstestdriver.TestCaseInfo=function(c,a,b){this.testCaseName_=c;this.template_=a;this.type_=b||jstestdriver.TestCaseInfo.DEFAULT_TYPE};jstestdriver.TestCaseInfo.DEFAULT_TYPE="default";jstestdriver.TestCaseInfo.ASYNC_TYPE="async";jstestdriver.TestCaseInfo.prototype.getType=function(){return this.type_};jstestdriver.TestCaseInfo.prototype.getTestCaseName=function(){return this.testCaseName_};jstestdriver.TestCaseInfo.prototype.getTemplate=function(){return this.template_};jstestdriver.TestCaseInfo.prototype.getTestNames=function(){var b=[];for(var a in this.template_.prototype){if(a.indexOf("test")==0){b.push(a)}}return b};jstestdriver.TestCaseInfo.prototype.getDefaultTestRunConfiguration=function(){return this.createTestRunConfiguration_(this.getTestNames())};jstestdriver.TestCaseInfo.prototype.createTestRunConfiguration_=function(a){return new jstestdriver.TestRunConfiguration(this,a)};jstestdriver.TestCaseInfo.prototype.getTestRunConfigurationFor=function(e){var g={};var l=e.length;for(var c=0;c<l;c++){var j=e[c];if(j=="all"||j=="*"){return this.getDefaultTestRunConfiguration()}var h=j.split(".");var a=g[h[0]];if(!a){a=[];g[h[0]]=a}if(h.length==2){a.push(h[1])}else{if(h.length==3&&h[1]=="prototype"){a.push(h[2])}else{}}}var d=g[this.testCaseName_];if(!d){return null}if(d.length==0){return this.createTestRunConfiguration_(this.getTestNames())}var b=[];var k=d.length;for(var c=0;c<k;c++){var f=d[c];if(f in this.template_.prototype){b.push(f)}}return this.createTestRunConfiguration_(b)};jstestdriver.TestCaseInfo.prototype.equals=function(a){return a&&typeof a.getTestCaseName!="undefined"&&a.getTestCaseName()==this.testCaseName_};jstestdriver.TestCaseInfo.prototype.toString=function(){return"TestCaseInfo("+this.testCaseName_+","+this.template_+","+this.type_+")"};jstestdriver.TestResult=function(g,b,a,d,c,f,e){this.testCaseName=g;this.testName=b;this.result=a;this.message=d;this.log=c;this.time=f;this.data=e||{}};jstestdriver.TestResult.RESULT={PASSED:"passed",ERROR:"error",FAILED:"failed"};jstestdriver.TestRunConfiguration=function(a,b){this.testCaseInfo_=a;this.tests_=b};jstestdriver.TestRunConfiguration.prototype.getTestCaseInfo=function(){return this.testCaseInfo_};jstestdriver.TestRunConfiguration.prototype.getTests=function(){return this.tests_};jstestdriver.TestCaseManager=function(a){this.testCasesInfo_=[];this.fileToTestCaseMap_={};this.latestTestCaseInfo_=null;this.pluginRegistrar_=a;this.recentCases_=[]};jstestdriver.TestCaseManager.prototype.add=function(b){var a=this.indexOf_(b);if(a!=-1){throw new Error("duplicate test case names! On "+b+" and "+this.testCasesInfo_[a])}else{this.testCasesInfo_.push(b);this.recentCases_.push(b)}};jstestdriver.TestCaseManager.prototype.updateLatestTestCase=function(a){if(this.recentCases_.length){this.fileToTestCaseMap_[a]=this.recentCases_;this.recentCases_=[]}};jstestdriver.TestCaseManager.prototype.removeTestCaseForFilename=function(a){var b=this.fileToTestCaseMap_[a]||[];this.fileToTestCaseMap_[a]=null;delete this.fileToTestCaseMap_[a];while(b.length){this.removeTestCase_(this.indexOf_(b.pop()))}};jstestdriver.TestCaseManager.prototype.removeTestCase_=function(a){this.testCasesInfo_.splice(a,1)};jstestdriver.TestCaseManager.prototype.indexOf_=function(a){var c=this.testCasesInfo_.length;for(var b=0;b<c;b++){var d=this.testCasesInfo_[b];if(d.equals(a)){return b}}return -1};jstestdriver.TestCaseManager.prototype.getDefaultTestRunsConfiguration=function(){var a=[];var d=this.testCasesInfo_.length;for(var c=0;c<d;c++){var b=this.testCasesInfo_[c];a.push(b.getDefaultTestRunConfiguration())}return a};jstestdriver.TestCaseManager.prototype.getTestRunsConfigurationFor=function(b){var a=[];this.pluginRegistrar_.getTestRunsConfigurationFor(this.testCasesInfo_,b,a);return a};jstestdriver.TestCaseManager.prototype.getTestCasesInfo=function(){return this.testCasesInfo_};jstestdriver.TestCaseManager.prototype.getCurrentlyLoadedTest=function(){var h=[];var e=this.testCasesInfo_.length;for(var d=0;d<e;d++){var b=this.testCasesInfo_[d];var g=b.getTestCaseName();var f=b.getTestNames();var c=f.length;for(var a=0;a<c;a++){h.push(g+"."+f[a])}}return{numTests:h.length,testNames:h}};jstestdriver.TestCaseManager.prototype.getCurrentlyLoadedTestFor=function(g){var l=this.getTestRunsConfigurationFor(g);var m=l.length;var f=[];for(var e=0;e<m;e++){var k=l[e];var b=k.getTestCaseInfo().getTestCaseName();var a=k.getTests();var d=a.length;for(var c=0;c<d;c++){var h=a[c];f.push(b+"."+h)}}return{numTests:f.length,testNames:f}};jstestdriver.TestCaseBuilder=function(a){this.testCaseManager_=a};jstestdriver.TestCaseBuilder.prototype.TestCase=function(d,a,c){var b=function(){};if(a){b.prototype=a}if(typeof b.prototype.setUp=="undefined"){b.prototype.setUp=function(){}}if(!b.prototype.hasOwnProperty("toString")){b.prototype.toString=function(){return"TestCase("+d+")"}}if(typeof b.prototype.tearDown=="undefined"){b.prototype.tearDown=function(){}}this.testCaseManager_.add(new jstestdriver.TestCaseInfo(d,b,c));return b};jstestdriver.TestCaseBuilder.prototype.AsyncTestCase=function(b,a){return this.TestCase(b,a,jstestdriver.TestCaseInfo.ASYNC_TYPE)};jstestdriver.TestCaseBuilder.prototype.ConditionalTestCase=function(c,d,a,b){if(d()){return this.TestCase(c,a,b)}this.testCaseManager_.add(new jstestdriver.TestCaseInfo(c,jstestdriver.TestCaseBuilder.PlaceHolderCase,b));return function(){}};jstestdriver.TestCaseBuilder.prototype.ConditionalAsyncTestCase=function(b,c,a){return this.ConditionalTestCase(b,c,a,jstestdriver.TestCaseInfo.ASYNC_TYPE)};jstestdriver.TestCaseBuilder.PlaceHolderCase=function(){};jstestdriver.TestCaseBuilder.PlaceHolderCase.prototype.testExcludedByCondition=jstestdriver.EMPTY_FUNC;jstestdriver.TestRunner=function(a){this.pluginRegistrar_=a;this.boundRunNextConfiguration_=jstestdriver.bind(this,this.runNextConfiguration_)};jstestdriver.TestRunner.prototype.runTests=function(a,c,d,b){this.pluginRegistrar_.onTestsStart();this.testRunsConfiguration_=a;this.onTestDone_=c;this.onComplete_=d;this.captureConsole_=b;this.runNextConfiguration_()};jstestdriver.TestRunner.prototype.finish_=function(){var a=this.onComplete_;this.pluginRegistrar_.onTestsFinish();this.testRunsConfiguration_=null;this.onTestDone_=null;this.onComplete_=null;this.captureConsole_=false;a()};jstestdriver.TestRunner.prototype.runNextConfiguration_=function(){if(this.testRunsConfiguration_.length==0){this.finish_();return}this.runConfiguration(this.testRunsConfiguration_.shift(),this.onTestDone_,this.boundRunNextConfiguration_)};jstestdriver.TestRunner.prototype.runConfiguration=function(b,a,c){if(this.captureConsole_){this.overrideConsole_()}jstestdriver.log("running configuration "+b);this.pluginRegistrar_.runTestConfiguration(b,a,c);if(this.captureConsole_){this.resetConsole_()}};jstestdriver.TestRunner.prototype.overrideConsole_=function(){this.logMethod_=console.log;this.logDebug_=console.debug;this.logInfo_=console.info;this.logWarn_=console.warn;this.logError_=console.error;console.log=function(){jstestdriver.console.log.apply(jstestdriver.console,arguments)};console.debug=function(){jstestdriver.console.debug.apply(jstestdriver.console,arguments)};console.info=function(){jstestdriver.console.info.apply(jstestdriver.console,arguments)};console.warn=function(){jstestdriver.console.warn.apply(jstestdriver.console,arguments)};console.error=function(){jstestdriver.console.error.apply(jstestdriver.console,arguments)}};jstestdriver.TestRunner.prototype.resetConsole_=function(){console.log=this.logMethod_;console.debug=this.logDebug_;console.info=this.logInfo_;console.warn=this.logWarn_;console.error=this.logError_};jstestdriver.TestRunner.TestCaseMap=function(){this.testCases_={}};jstestdriver.TestRunner.TestCaseMap.prototype.startCase=function(a){this.testCases_[a]=true};jstestdriver.TestRunner.TestCaseMap.prototype.stopCase=function(a){this.testCases_[a]=false};jstestdriver.TestRunner.TestCaseMap.prototype.hasActiveCases=function(){for(var a in this.testCases_){if(this.testCases_.hasOwnProperty(a)&&this.testCases_[a]){return true}}return false};jstestdriver.StandAloneLoadTestsCommand=function(e,b,d,f,a,c){this.jsonParse_=e;this.pluginRegistrar_=b;this.boundOnFileLoaded_=jstestdriver.bind(this,this.onFileLoaded);this.getBrowserInfo=d;this.onLoadComplete_=f;this.reporter_=a;this.now_=c};jstestdriver.StandAloneLoadTestsCommand.prototype.loadTest=function(c){var d=c[0];var b=this.jsonParse_('{"f":'+d+"}").f;this.removeScripts(document,b);var a=new jstestdriver.FileLoader(this.pluginRegistrar_,this.boundOnFileLoaded_);this.reporter_.startLoading(this.now_());a.load(b)};jstestdriver.StandAloneLoadTestsCommand.prototype.onFileLoaded=function(a){this.reporter_.addLoadedFileResults(a.loadedFiles);var b=new jstestdriver.Response(jstestdriver.RESPONSE_TYPES.FILE_LOAD_RESULT,JSON.stringify(a),this.getBrowserInfo());this.reporter_.finishLoading(this.now_());this.onLoadComplete_(b)};jstestdriver.StandAloneLoadTestsCommand.prototype.findScriptTagsToRemove_=function(e,l){var c=e.getElementsByTagName("script");var a=l.length;var k=c.length;var b=[];for(var g=0;g<a;g++){var h=l[g].fileSrc;for(var d=0;d<k;d++){var m=c[d];if(m.src.indexOf(h)!=-1){b.push(m);break}}}return b};jstestdriver.StandAloneLoadTestsCommand.prototype.removeScriptTags_=function(e,f){var d=e.getElementsByTagName("head")[0];var c=f.length;for(var b=0;b<c;b++){var a=f[b];d.removeChild(a)}};jstestdriver.StandAloneLoadTestsCommand.prototype.removeScripts=function(b,a){this.removeScriptTags_(b,this.findScriptTagsToRemove_(b,a))};jstestdriver.StandAloneRunTestsCommand=function(g,f,h,i,e,c,d,a,b){this.testCaseManager_=g;this.testRunner_=f;this.pluginRegistrar_=h;this.jsonParse_=d;this.now_=c;this.boundOnTestDone_=jstestdriver.bind(this,this.onTestDone_);this.boundOnComplete_=jstestdriver.bind(this,this.onComplete);this.testsDone_=[];this.getBrowserInfo_=i;this.reporter_=e;this.streamContinue_=a;this.streamStop_=b};jstestdriver.StandAloneRunTestsCommand.prototype.createLog_=function(a){return new jstestdriver.BrowserLog(0,"jstestdriver.StandAloneRunTestsCommand",a,this.getBrowserInfo_())};jstestdriver.StandAloneRunTestsCommand.prototype.runAllTests=function(b){this.streamContinue_(new jstestdriver.Response(jstestdriver.RESPONSE_TYPES.LOG,jstestdriver.JSON.stringify(this.createLog_("all tests started.")),this.getBrowserInfo_()));var a=b[0];this.debug_=Boolean(b[2]);this.runTestCases_(this.testCaseManager_.getDefaultTestRunsConfiguration(),a=="true"?true:false)};jstestdriver.StandAloneRunTestsCommand.prototype.runTests=function(b){this.streamContinue_(new jstestdriver.Response(jstestdriver.RESPONSE_TYPES.LOG,jstestdriver.JSON.stringify(this.createLog_("started tests.")),this.getBrowserInfo_()));var c=jsonParse('{"expressions":'+b[0]+"}").expressions;var a=b[1];this.debug_=Boolean(b[2]);this.runTestCases_(this.testCaseManager_.getTestRunsConfigurationFor(c),a=="true"?true:false,false)};jstestdriver.StandAloneRunTestsCommand.prototype.runTestCases_=function(a,b){this.reporter_.startTests(this.now_());this.totaltestruns_=a.length;this.testRunner_.runTests(a,this.boundOnTestDone_,this.boundOnComplete_,b)};jstestdriver.StandAloneRunTestsCommand.prototype.onTestDone_=function(a){this.reporter_.updateIsSuccess(a.result==jstestdriver.TestResult.RESULT.PASSED);this.addTestResult(a)};jstestdriver.StandAloneRunTestsCommand.prototype.onComplete=function(){var a=jstestdriver.JSON.stringify(this.testsDone_);this.streamContinue_(new jstestdriver.Response(jstestdriver.RESPONSE_TYPES.TEST_RESULT,a,this.getBrowserInfo_()));this.reporter_.setReport(a);this.testsDone_=[];this.reporter_.finishTests(this.now_());this.reporter_.setIsFinished(true);this.streamStop_(new jstestdriver.Response(jstestdriver.RESPONSE_TYPES.LOG,jstestdriver.JSON.stringify(this.createLog_("testing complete, isSuccess:"+this.reporter_.isSuccess()+", isFinished:"+this.reporter_.isFinished())),this.getBrowserInfo_()))};jstestdriver.StandAloneRunTestsCommand.prototype.addTestResult=function(a){this.reporter_.addTestResult(a);this.pluginRegistrar_.processTestResult(a);this.testsDone_.push(a)};jstestdriver.NoopCommand=function(a,b){this.streamStop_=a;this.streamStop_=a;this.getBrowserInfo_=b};jstestdriver.NoopCommand.prototype.sendNoop=function(){this.streamStop_(new jstestdriver.Response(jstestdriver.RESPONSE_TYPES.NOOP,"{}",this.getBrowserInfo_()))};jstestdriver.VisualTestReporter=function(b,d,a,c){this.finished_=false;this.success_=1;this.report_="";this.filesLoaded_=[];this.testResults_=[];this.createNode_=b;this.appendToBody_=d;this.jQuery_=a;this.parseJson_=c;this.passed_=0;this.testTime_=new jstestdriver.VisualTestReporter.Interval();this.loadTime_=new jstestdriver.VisualTestReporter.Interval()};jstestdriver.VisualTestReporter.prototype.isFinished=function(){return this.finished_};jstestdriver.VisualTestReporter.prototype.getReport=function(){return this.report_};jstestdriver.VisualTestReporter.prototype.getNumFilesLoaded=function(){return this.filesLoaded_.length};jstestdriver.VisualTestReporter.prototype.setIsFinished=function(h){this.finished_=h;if(h){var b=this.createNode_("div");this.jQuery_(b).attr("id","JsTDVisualResults");b.className="results";var e=this.createNode_("div");e.className="details";var f={};for(var d=0,a=this.testResults_[d];a=this.testResults_[d];d++){if(!f[a.testCaseName]||(f[a.testCaseName]==jstestdriver.TestResult.RESULT.PASSED)){f[a.testCaseName]=a.result}this.renderResult(a,e)}var g=[];for(caseName in f){g.push(jstestdriver.formatString('<div class="%s">%s [%s]</div>',f[caseName],caseName,f[caseName].toUpperCase()))}g.sort();var c=b.appendChild(this.createNode_("div"));c.className="summary";c.innerHTML=jstestdriver.formatString('<h2>Summary:</h2><div class="cases">%s</div><p>%s out of %s tests passed in %ds.</p><h2>Details:</h2>',g.join(""),this.passed_,this.testResults_.length,this.testTime_.toSeconds());this.renderFilesLoaded(b);b.appendChild(e);this.appendToBody_(b)}};jstestdriver.VisualTestReporter.prototype.renderFilesLoaded=function(b){var a=b.appendChild(this.createNode_("div"));a.className="load";a.innerHTML=jstestdriver.formatString("%s files loaded in %ds",this.filesLoaded_.length,this.loadTime_.toSeconds())};jstestdriver.VisualTestReporter.prototype.renderResult=function(j,h){var a=this.createNode_("div");a.className=j.result;var c=[jstestdriver.formatString("%s.%s [%s] in %d ms",j.testCaseName,j.testName,j.result.toUpperCase(),j.time)];var g=j.message.length?this.parseJson_(j.message):[];while(g.length){var e=g.pop();c.push('<div class="message">'+e.message+"</div>");if(e.stack){var d=e.stack.split("\n");var f=[];for(var b=0;d[b];b++){if(d[b].indexOf("/test/")!=-1){f.push(d[b])}}c.push('<div class="stack">'+f.join("\n")+"</div>")}}if(j.result!=jstestdriver.TestResult.RESULT.PASSED){c.push('<div class="log">'+j.log+"</div>")}a.innerHTML=c.join("");h.appendChild(a)};jstestdriver.VisualTestReporter.prototype.setIsSuccess=function(a){this.success_=a};jstestdriver.VisualTestReporter.prototype.addTestResult=function(a){this.testResults_.push(a)};jstestdriver.VisualTestReporter.prototype.isSuccess=function(){return !!this.success_};jstestdriver.VisualTestReporter.prototype.updateIsSuccess=function(a){this.passed_+=Number(a);this.success_=a&this.success_};jstestdriver.VisualTestReporter.prototype.setReport=function(a){this.report_=a};jstestdriver.VisualTestReporter.prototype.addLoadedFileResults=function(a){this.filesLoaded_=this.filesLoaded_.concat(a)};jstestdriver.VisualTestReporter.prototype.startLoading=function(a){this.loadTime_.start=a};jstestdriver.VisualTestReporter.prototype.finishLoading=function(a){this.loadTime_.stop=a};jstestdriver.VisualTestReporter.prototype.finishTests=function(a){this.testTime_.stop=a};jstestdriver.VisualTestReporter.prototype.startTests=function(a){this.testTime_.start=a};jstestdriver.VisualTestReporter.prototype.toString=function(){return"VisualTestReporter(success=["+this.success_+"], finished=["+this.finished_+"], lastTestResult=["+this.lastTestResult_+"], filesLoaded=["+this.filesLoaded_+"])"};jstestdriver.VisualTestReporter.Interval=function(){this.start=0;this.stop=0};jstestdriver.VisualTestReporter.Interval.prototype.toSeconds=function(){return(this.stop-this.start)/1000};jstestdriver.testBreather=function(c,a){var d=new Date();function b(f){var e=new Date();if((e-d)>a){c(f,1);d=e}else{f()}}return b};jstestdriver.TIMEOUT=500;jstestdriver.NOOP_COMMAND={command:"noop",parameters:[]};jstestdriver.CommandExecutor=function(b,g,f,a,c,d,e){this.streamingService_=b;this.__testCaseManager=g;this.__testRunner=f;this.__pluginRegistrar=a;this.__boundExecuteCommand=jstestdriver.bind(this,this.executeCommand);this.__boundExecute=jstestdriver.bind(this,this.execute);this.__boundEvaluateCommand=jstestdriver.bind(this,this.evaluateCommand);this.boundCleanTestManager=jstestdriver.bind(this,this.cleanTestManager);this.boundOnFileLoaded_=jstestdriver.bind(this,this.onFileLoaded);this.boundOnFileLoadedRunnerMode_=jstestdriver.bind(this,this.onFileLoadedRunnerMode);this.boundOnTestDone=jstestdriver.bind(this,this.onTestDone_);this.boundOnComplete=jstestdriver.bind(this,this.onComplete_);this.boundOnTestDoneRunnerMode=jstestdriver.bind(this,this.onTestDoneRunnerMode_);this.boundOnCompleteRunnerMode=jstestdriver.bind(this,this.onCompleteRunnerMode_);this.boundSendTestResults=jstestdriver.bind(this,this.sendTestResults);this.commandMap_={};this.testsDone_=[];this.debug_=false;this.now_=c;this.lastTestResultsSent_=0;this.getBrowserInfo=d;this.currentActionSignal_=e};jstestdriver.CommandExecutor.prototype.executeCommand=function(b){var f;if(b&&b.length){f=jsonParse(b)}else{f=jstestdriver.NOOP_COMMAND}try{this.commandMap_[f.command](f.parameters)}catch(d){var c="Exception "+d.name+": "+d.message+"\n"+d.fileName+"("+d.lineNumber+"):\n"+d.stack;var a=new jstestdriver.Response(jstestdriver.RESPONSE_TYPES.LOG,jstestdriver.JSON.stringify(new jstestdriver.BrowserLog(1000,"jstestdriver.CommandExecutor",c,this.getBrowserInfo())),this.getBrowserInfo());if(top.console&&top.console.log){top.console.log(c)}this.streamingService_.close(a,this.__boundExecuteCommand);throw d}};jstestdriver.CommandExecutor.prototype.execute=function(b){var a=new jstestdriver.Response(jstestdriver.RESPONSE_TYPES.COMMAND_RESULT,JSON.stringify(this.__boundEvaluateCommand(b)),this.getBrowserInfo());this.streamingService_.close(a,this.__boundExecuteCommand)};jstestdriver.CommandExecutor.prototype.evaluateCommand=function(cmd){var res="";try{var evaluatedCmd=eval("("+cmd+")");if(evaluatedCmd){res=evaluatedCmd.toString()}}catch(e){res="Exception "+e.name+": "+e.message+"\n"+e.fileName+"("+e.lineNumber+"):\n"+e.stack}return res};jstestdriver.CommandExecutor.prototype.registerCommand=function(a,b,c){this.commandMap_[a]=jstestdriver.bind(b,c)};jstestdriver.CommandExecutor.prototype.registerTracedCommand=function(a,b,d){var c=jstestdriver.bind(b,d);var e=this.currentActionSignal_;this.commandMap_[a]=function(){e.set(a);return c.apply(null,arguments)}};jstestdriver.CommandExecutor.prototype.dryRun=function(){var a=new jstestdriver.Response(jstestdriver.RESPONSE_TYPES.TEST_QUERY_RESULT,JSON.stringify(this.__testCaseManager.getCurrentlyLoadedTest()),this.getBrowserInfo());this.streamingService_.close(a,this.__boundExecuteCommand)};jstestdriver.CommandExecutor.prototype.dryRunFor=function(b){var d=jsonParse('{"expressions":'+b[0]+"}").expressions;var c=JSON.stringify(this.__testCaseManager.getCurrentlyLoadedTestFor(d));var a=new jstestdriver.Response(jstestdriver.RESPONSE_TYPES.TEST_QUERY_RESULT,c,this.getBrowserInfo());this.streamingService_.close(a,this.__boundExecuteCommand)};jstestdriver.CommandExecutor.prototype.listen=function(){var a;if(window.location.href.search("\\?refresh")!=-1){a=new jstestdriver.Response(jstestdriver.RESPONSE_TYPES.RESET_RESULT,"Runner reset.",this.getBrowserInfo(),true);jstestdriver.log("Runner reset: "+window.location.href)}else{a=new jstestdriver.Response(jstestdriver.RESPONSE_TYPES.BROWSER_READY,null,this.getBrowserInfo(),true)}this.streamingService_.close(a,this.__boundExecuteCommand)};jstestdriver.config=(function(b){var a=b||{};a.startRunner=function(d,g){var e=g||jstestdriver.plugins.defaultRunTestLoop;jstestdriver.log("using runTestLoop:"+e);jstestdriver.pluginRegistrar=new jstestdriver.PluginRegistrar();jstestdriver.testCaseManager=new jstestdriver.TestCaseManager(jstestdriver.pluginRegistrar);jstestdriver.testRunner=new jstestdriver.TestRunner(jstestdriver.pluginRegistrar);jstestdriver.testCaseBuilder=new jstestdriver.TestCaseBuilder(jstestdriver.testCaseManager);jstestdriver.global.TestCase=jstestdriver.bind(jstestdriver.testCaseBuilder,jstestdriver.testCaseBuilder.TestCase);jstestdriver.global.AsyncTestCase=jstestdriver.bind(jstestdriver.testCaseBuilder,jstestdriver.testCaseBuilder.AsyncTestCase);jstestdriver.global.ConditionalTestCase=jstestdriver.bind(jstestdriver.testCaseBuilder,jstestdriver.testCaseBuilder.ConditionalTestCase);jstestdriver.global.ConditionalAsyncTestCase=jstestdriver.bind(jstestdriver.testCaseBuilder,jstestdriver.testCaseBuilder.ConditionalAsyncTestCase);var i=new jstestdriver.plugins.ScriptLoader(window,document,jstestdriver.testCaseManager,jstestdriver.now);var h=new jstestdriver.plugins.StylesheetLoader(window,document,jstestdriver.jQuery.browser.mozilla||jstestdriver.jQuery.browser.safari);var f=new jstestdriver.plugins.FileLoaderPlugin(i,h,jstestdriver.now);var c=new jstestdriver.plugins.TestRunnerPlugin(Date,function(){jstestdriver.log(jstestdriver.jQuery("body")[0].innerHTML);jstestdriver.jQuery("body").children().remove();jstestdriver.jQuery(document).unbind();jstestdriver.jQuery(document).die()},e);jstestdriver.pluginRegistrar.register(new jstestdriver.plugins.DefaultPlugin(f,c,new jstestdriver.plugins.AssertsPlugin(),new jstestdriver.plugins.TestCaseManagerPlugin()));jstestdriver.pluginRegistrar.register(new jstestdriver.plugins.async.AsyncTestRunnerPlugin(Date,function(){jstestdriver.jQuery("body").children().remove();jstestdriver.jQuery(document).unbind();jstestdriver.jQuery(document).die()}));jstestdriver.testCaseManager.TestCase=jstestdriver.global.TestCase;jstestdriver.executor=d(jstestdriver.testCaseManager,jstestdriver.testRunner,jstestdriver.pluginRegistrar,jstestdriver.now,window.location.toString());jstestdriver.executor.listen()};a.createExecutor=function(d,t,k,f,c){var r=parseInt(jstestdriver.extractId(c));var g=jstestdriver.createPath(top.location.toString(),jstestdriver.SERVER_URL+r);var p=new jstestdriver.StreamingService(g,f,jstestdriver.convertToJson(jstestdriver.jQuery.post),jstestdriver.createSynchPost(jstestdriver.jQuery));function u(){return new jstestdriver.BrowserInfo(r)}var e=new jstestdriver.CommandExecutor(p,d,t,k,f,u);var j=new jstestdriver.Signal(null);var s=jstestdriver.bind(e,e.executeCommand);function h(x){p.close(x,s)}function m(x){p.stream(x,s)}var w=new jstestdriver.LoadTestsCommand(jsonParse,k,u,h);var v=new jstestdriver.RunTestsCommand(d,t,k,u,jstestdriver.now,jsonParse,m,h);var n=new jstestdriver.Signal(false);var i=new jstestdriver.ResetCommand(window.location,n,jstestdriver.now);var q=new jstestdriver.NoopCommand(h,u);e.registerCommand("execute",e,e.execute);e.registerCommand("noop",q,q.sendNoop);e.registerCommand("runAllTests",v,v.runAllTests);e.registerCommand("runTests",v,v.runTests);e.registerCommand("loadTest",w,w.loadTest);e.registerCommand("reset",i,i.reset);e.registerCommand("dryRun",e,e.dryRun);e.registerCommand("dryRunFor",e,e.dryRunFor);e.registerCommand("unknownBrowser",null,function(){});e.registerCommand("stop",null,function(){if(window.console&&window.console.log){window.console.log("Stopping executor by server request.")}});e.registerCommand("streamAcknowledged",p,p.streamAcknowledged);function l(){return j.get()}var o=new jstestdriver.PageUnloadHandler(p,u,l,n);jstestdriver.jQuery(window).bind("unload",jstestdriver.bind(o,o.onUnload));jstestdriver.jQuery(window).bind("beforeunload",jstestdriver.bind(o,o.onUnload));window.onbeforeunload=jstestdriver.bind(o,o.onUnload);return e};a.createVisualExecutor=function(g,f,d,e,c){return a.createStandAloneExecutorWithReporter(g,f,d,e,c,new jstestdriver.VisualTestReporter(function(h){return document.createElement(h)},function(h){return document.body.appendChild(h)},jstestdriver.jQuery,JSON.parse))};a.createStandAloneExecutor=function(g,f,d,e,c){return a.createStandAloneExecutorWithReporter(g,f,d,e,c,new jstestdriver.StandAloneTestReporter())};a.createStandAloneExecutorWithReporter=function(o,m,p,g,q,k){var f=parseInt(jstestdriver.extractId(q));var d=jstestdriver.createPath(top.location.toString(),jstestdriver.SERVER_URL+f);var h=new jstestdriver.StreamingService(d,g,jstestdriver.convertToJson(jstestdriver.jQuery.post));function s(){return new jstestdriver.BrowserInfo(f)}window.top.G_testRunner=k;var i=new jstestdriver.Signal(null);var j=new jstestdriver.CommandExecutor(h,o,m,p,g,s,i);var n=jstestdriver.bind(j,j.executeCommand);function e(t){h.close(t,n)}function c(t){h.stream(t,n)}var r=new jstestdriver.StandAloneLoadTestsCommand(jsonParse,p,s,e,k,jstestdriver.now);var l=new jstestdriver.StandAloneRunTestsCommand(o,m,p,s,k,g,jsonParse,c,e);j.registerTracedCommand("execute",j,j.execute);j.registerTracedCommand("noop",null,e);j.registerTracedCommand("runAllTests",l,l.runAllTests);j.registerTracedCommand("runTests",l,l.runTests);j.registerTracedCommand("loadTest",r,r.loadTest);j.registerTracedCommand("reset",j,j.reset);j.registerTracedCommand("dryRun",j,j.dryRun);j.registerTracedCommand("dryRunFor",j,j.dryRunFor);j.registerCommand("streamAcknowledged",h,h.streamAcknowledged);j.registerCommand("unknownBrowser",null,function(){});j.registerCommand("stop",null,function(){if(window.console&&window.console.log){window.console.log("Stopping executor by server request.")}});return j};return a})(jstestdriver.config);/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

/**
 * @fileoverview Defines the FiniteUseCallback class, which decorates a
 * Javascript function by notifying the test runner about any exceptions thrown
 * when the function executes.
 *
 * @author rdionne@google.com (Robert Dionne)
 */


/**
 * Constructs a CatchingCallback.
 *
 * @param testCase the testCase to use as 'this' when calling the wrapped function.
 * @param pool the pool to which this callback belongs.
 * @param wrapped the wrapped callback function.
 */
jstestdriver.plugins.async.CatchingCallback = function(testCase, pool, wrapped) {
  this.testCase_ = testCase;
  this.pool_ = pool;
  this.callback_ = wrapped;
};


/**
 * Invokes the wrapped callback, catching any exceptions and reporting the status
 * to the pool.
 */
jstestdriver.plugins.async.CatchingCallback.prototype.invoke = function() {
  var result;
  var message;
  try {
    result = this.callback_.apply(this.testCase_, arguments);
    message = 'success.';
    return result;
  } catch (e) {
    this.pool_.onError(e);
    message = 'failure: ' + e;
    throw e;
  } finally {
    this.pool_.remove(message);
  }
};
/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */


/**
 * @fileoverview Defines the ExpiringCallback class, which decorates a
 * Javascript function by restricting the length of time the asynchronous system
 * may delay before calling the function.
 * 
 * @author rdionne@google.com (Robert Dionne)
 */


/**
 * Constructs an ExpiringCallback.
 *
 * @param pool the pool to which this callback belongs.
 * @param callback a FiniteUseCallback.
 * @param timeout a Timeout object.
 */
jstestdriver.plugins.async.ExpiringCallback = function(pool, callback, timeout) {
  this.pool_ = pool;
  this.callback_ = callback;
  this.timeout_ = timeout;
};


/**
 * Arms this callback to expire after the given delay.
 * 
 * @param delay the amount of time before this callback expires.
 */
jstestdriver.plugins.async.ExpiringCallback.prototype.arm = function(delay) {
  var callback = this;
  this.timeout_.arm(function() {
    callback.pool_.onError(new Error('expired.'));
    callback.pool_.remove('expired.', callback.callback_.getRemainingUses());
    callback.callback_.deplete();
  }, delay);
};


/**
 * Invokes this callback.
 */
jstestdriver.plugins.async.ExpiringCallback.prototype.invoke = function() {
  return this.callback_.invoke.apply(this.callback_, arguments);
};

/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */


/**
 * @fileoverview Defines the FiniteUseCallback class, which decorates a
 * Javascript function by restricting the number of times the asynchronous
 * system may call it.
 *
 * @author rdionne@google.com (Robert Dionne)
 */


/**
 * Constructs a FiniteUseCallback.
 *
 * @param callback a CatchingCallback.
 * @param onDepleted a function to execute when this FiniteUseCallback depletes.
 * @param opt_remainingUses the number of permitted uses remaining; defaults to
 * one.
 */
jstestdriver.plugins.async.FiniteUseCallback = function(callback, onDepleted, opt_remainingUses) {
  this.callback_ = callback;
  this.onDepleted_ = onDepleted;
  this.remainingUses_ = opt_remainingUses || 1;
};


/**
 * Depletes the remaining permitted uses.  Calls onDepleted.
 */
jstestdriver.plugins.async.FiniteUseCallback.prototype.deplete = function() {
  this.remainingUses_ = 0;
  if (this.onDepleted_) {
    this.onDepleted_.apply();
  }
};


/**
 * Returns the number of remaining permitted uses.
 */
jstestdriver.plugins.async.FiniteUseCallback.prototype.getRemainingUses = function() {
  return this.remainingUses_;
};


/**
 * Invokes this callback if it is usable. Calls onDepleted if invoking this
 * callback depletes its remaining permitted uses.
 */
jstestdriver.plugins.async.FiniteUseCallback.prototype.invoke = function(var_args) {
  if (this.isUsable()) {
    try {
      this.remainingUses_ -= 1;
      return this.callback_.invoke.apply(this.callback_, arguments);
    } finally {
      if (this.onDepleted_ && !this.isUsable()) {
        this.onDepleted_.apply();
      }
    }
  } /*else {
    console.log('Warning. Attempted to call unusable callback.');
  }*/
};


/**
 * Returns true if any permitted uses remain.
 */
jstestdriver.plugins.async.FiniteUseCallback.prototype.isUsable = function() {
  return this.remainingUses_ > 0;
};
/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */


/**
 * @fileoverview Defines the Timeout class.  The arm() method is equivalent to
 * window.setTimeout() and maybeDisarm() is equivalent to window.clearTimeout().
 *  
 * @author rdionne@google.com (Robert Dionne)
 */


/**
 * Constructs a Timeout. Accepts alternate implementations of setTimeout and
 * clearTimeout.
 *
 * @param setTimeout the global setTimeout function to use.
 * @param clearTimeout the global clearTimeout function to use.
 */
jstestdriver.plugins.async.Timeout = function(setTimeout, clearTimeout) {
  this.setTimeout_ = setTimeout;
  this.clearTimeout_ = clearTimeout;
  this.handle_ = null;
};


/**
 * Arms this Timeout to fire after the specified delay.
 *
 * @param callback the callback to call after the delay passes.
 * @param delay the timeout delay in milliseconds.
 */
jstestdriver.plugins.async.Timeout.prototype.arm = function(callback, delay) {
  var self = this;
  this.handle_ = this.setTimeout_(function() {
    self.maybeDisarm();
    return callback.apply(null, arguments);
  }, delay);
};

/**
 * Explicitly disarms the timeout.
 */
jstestdriver.plugins.async.Timeout.prototype.disarm_ = function() {
  this.clearTimeout_(this.handle_);
  this.handle_ = null;
};


/**
 * Returns true if the timeout is armed.
 */
jstestdriver.plugins.async.Timeout.prototype.isArmed = function() {
  return this.handle_ != null;
};


/**
 * Disarms the timeout if it is armed.
 */
jstestdriver.plugins.async.Timeout.prototype.maybeDisarm = function() {
  if (this.isArmed()) {
    this.disarm_();
  }
};
/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */


/**
 * @fileoverview Defines the TestSafeCallbackBuilder class, which decorates a
 * Javascript function with several safeguards so that it may be safely executed
 * asynchronously within a test. The safeguards include:
 * 
 *   1) notifying the test runner about any exceptions thrown when the function
 *      executes
 *   2) restricting the number of times the asynchronous system may call the
 *      function
 *   3) restricting the length of time the asynchronous system may delay before
 *      calling the function
 *
 * @author rdionne@google.com (Robert Dionne)
 */


/**
 * Constructs a TestSafeCallbackBuilder.
 * 
 * @param opt_setTimeout the global setTimeout function to use.
 * @param opt_clearTimeout the global clearTimeout function to use.
 * @param opt_timeoutConstructor a constructor for obtaining new the Timeouts.
 */
jstestdriver.plugins.async.TestSafeCallbackBuilder = function(
    opt_setTimeout, opt_clearTimeout, opt_timeoutConstructor) {
  this.setTimeout_ = opt_setTimeout || jstestdriver.setTimeout;
  this.clearTimeout_ = opt_clearTimeout || jstestdriver.clearTimeout;
  this.timeoutConstructor_ = opt_timeoutConstructor || jstestdriver.plugins.async.Timeout;
  this.pool_ = null;
  this.remainingUses_ = null;
  this.testCase_ = null;
  this.wrapped_ = null;
};


/**
 * Returns the original function decorated with safeguards.
 */
jstestdriver.plugins.async.TestSafeCallbackBuilder.prototype.build = function() {
  var catchingCallback = new jstestdriver.plugins.async.CatchingCallback(this.testCase_, this.pool_, this.wrapped_);
  var timeout = new (this.timeoutConstructor_)(this.setTimeout_, this.clearTimeout_);
  var onDepleted = function() {
    timeout.maybeDisarm();
  };
  var finiteUseCallback = new jstestdriver.plugins.async.FiniteUseCallback(catchingCallback, onDepleted, this.remainingUses_);
  return new jstestdriver.plugins.async.ExpiringCallback(this.pool_, finiteUseCallback, timeout);
};


/**
 * @param pool the CallbackPool to contain the callback.
 */
jstestdriver.plugins.async.TestSafeCallbackBuilder.prototype.setPool = function(pool) {
  this.pool_ = pool;
  return this;
};


/**
 * @param remainingUses the remaining number of permitted calls.
 */
jstestdriver.plugins.async.TestSafeCallbackBuilder.prototype.setRemainingUses = function(remainingUses) {
  this.remainingUses_ = remainingUses;
  return this;
};


/**
 * @param testCase the test case instance available as 'this' within the functions scope.
 */
jstestdriver.plugins.async.TestSafeCallbackBuilder.prototype.setTestCase = function(testCase) {
  this.testCase_ = testCase;
  return this;
};


/**
 * @param wrapped the function wrapped by the above safeguards.
 */
jstestdriver.plugins.async.TestSafeCallbackBuilder.prototype.setWrapped = function(wrapped) {
  this.wrapped_ = wrapped;
  return this;
};
/*
 * Copyright 2011 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */


/**
 * @fileoverview Defines the CallbackPool class, which decorates given callback
 * functions with safeguards and tracks them until they execute or expire.
 *
 * @author rdionne@google.com (Robert Dionne)
 */


/**
 * Constructs a CallbackPool.
 *
 * @param setTimeout the global setTimeout function.
 * @param testCase the test case instance.
 * @param onPoolComplete a function to call when the pool empties.
 */
jstestdriver.plugins.async.CallbackPool = function(setTimeout, testCase, onPoolComplete) {
  this.setTimeout_ = setTimeout;
  this.testCase_ = testCase;
  this.onPoolComplete_ = onPoolComplete;
  this.errors_ = [];
  this.count_ = 0;
  this.active_ = false;
};


/**
 * The number of milliseconds to wait before expiring a delinquent callback.
 */
jstestdriver.plugins.async.CallbackPool.TIMEOUT = 30000;


/**
 * Calls onPoolComplete if the pool is active and empty.
 */
jstestdriver.plugins.async.CallbackPool.prototype.maybeComplete = function() {
  if (this.active_ && this.count_ == 0 && this.onPoolComplete_) {
    var pool = this;
    this.setTimeout_(function() {
      pool.onPoolComplete_(pool.errors_);
    }, 0);
  }
};


/**
 * Activates the pool and calls maybeComplete.
 */
jstestdriver.plugins.async.CallbackPool.prototype.activate = function() {
    this.active_ = true;
    this.maybeComplete();
};


/**
 * Returns the number of outstanding callbacks in the pool.
 */
jstestdriver.plugins.async.CallbackPool.prototype.count = function() {
  return this.count_;
};


/**
 * Accepts errors to later report them to the test runner via onPoolComplete.
 * @param error the error to report
 */
jstestdriver.plugins.async.CallbackPool.prototype.onError = function(error) {
  this.errors_.push(error);
};


/**
 * Adds a callback function to the pool, optionally more than once.
 *
 * @param wrapped the callback function to decorate with safeguards and to add
 * to the pool.
 * @param opt_n the number of permitted uses of the given callback; defaults to one.
 */
jstestdriver.plugins.async.CallbackPool.prototype.addCallback = function(wrapped, opt_n) {
  this.count_ += opt_n || 1;
  //console.log('adding. (' + this.count_ + ' in pool)');
  var callback = new jstestdriver.plugins.async.TestSafeCallbackBuilder()
      .setPool(this)
      .setRemainingUses(opt_n)
      .setTestCase(this.testCase_)
      .setWrapped(wrapped)
      .build();
  callback.arm(jstestdriver.plugins.async.CallbackPool.TIMEOUT);
  return function() {
    return callback.invoke.apply(callback, arguments);
  };
};


/**
 * Adds a callback function to the pool, optionally more than once.
 *
 * @param wrapped the callback function to decorate with safeguards and to add
 * to the pool.
 * @param opt_n the number of permitted uses of the given callback; defaults to one.
 * @deprecated
 */
jstestdriver.plugins.async.CallbackPool.prototype.add =
    jstestdriver.plugins.async.CallbackPool.prototype.addCallback;


/**
 * @return {Function} An errback function to attach to an asynchronous system so
 *     that the test runner can be notified in the event of error.
 * @param {string} message A message to report to the user upon error.
 */
jstestdriver.plugins.async.CallbackPool.prototype.addErrback = function(message) {
  var pool = this;
  return function() {
    pool.onError(new Error(
        'Errback ' + message + ' called with arguments: ' +
            Array.prototype.slice.call(arguments)));
    pool.count_ = 0;
    pool.maybeComplete();
  };
};


/**
 * Removes a callback from the pool, optionally more than one.
 *
 * @param message a message to pass to the pool for logging purposes; usually the
 * reason that the callback was removed from the pool.
 * @param opt_n the number of callbacks to remove from the pool.
 */
jstestdriver.plugins.async.CallbackPool.prototype.remove = function(message, opt_n) {
  if (this.count_ > 0) {
    this.count_ -= opt_n || 1;
    /*if (message) {
      console.log(message + ' (' + this.count_ + ' in pool)');
    }*/
    this.maybeComplete();
  }
};
/*
 * Copyright 2011 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */


/**
 * @fileoverview Defines the CallbackPoolArmor class. Encapsulates a CallbackPool
 * behind a narrower interface. Also, validates arguments.
 *
 * @author rdionne@google.com (Robert Dionne)
 */


/**
 * Constructs a CallbackPoolArmor.
 * @constructor
 */
jstestdriver.plugins.async.CallbackPoolArmor = function(pool) {
  this.pool_ = pool;
};


/**
 * Adds a callback to the pool.
 * @param {Function} callback The callback to wrap.
 * @param {Number} opt_n An optional number of times to wait for the callback to
 *     be called.
 */
jstestdriver.plugins.async.CallbackPoolArmor.prototype.addCallback = function(callback, opt_n) {
  if (callback) {
    return this.pool_.addCallback(callback, opt_n);
  }
};


/**
 * @return {Function} An errback function to attach to an asynchronous system so
 *     that the test runner can be notified in the event of error.
 * @param {string} message A message to report to the user upon error.
 */
jstestdriver.plugins.async.CallbackPoolArmor.prototype.addErrback = function(message) {
  return this.pool_.addErrback(message);
};


/**
 * Adds a callback to the pool.
 * @param {Function} callback The callback to wrap.
 * @param {Number} opt_n An optional number of times to wait for the callback to
 *     be called.
 * @deprecated
 */
jstestdriver.plugins.async.CallbackPoolArmor.prototype.add =
    jstestdriver.plugins.async.CallbackPoolArmor.prototype.addCallback;


/**
 * A no-op callback that's useful for waiting until an asynchronous operation
 * completes without performing any action.
 * @param {Number} opt_n An optional number of times to wait for the callback to
 *     be called.
 */
jstestdriver.plugins.async.CallbackPoolArmor.prototype.noop = function(opt_n) {
  return this.pool_.addCallback(jstestdriver.EMPTY_FUNC, opt_n);
};
/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */


/**
 * @fileoverview Defines the DeferredQueue class.
 *
 * @author rdionne@google.com (Robert Dionne)
 */


/**
 * Constructs a DeferredQueue.
 */
jstestdriver.plugins.async.DeferredQueue = function(setTimeout, testCase, onQueueComplete, armor,
    opt_queueConstructor, opt_queueArmorConstructor, opt_poolConstructor, opt_poolArmorConstructor) {
  this.setTimeout_ = setTimeout;
  this.testCase_ = testCase;
  this.onQueueComplete_ = onQueueComplete;
  this.armor_ = armor;
  this.queueConstructor_ = opt_queueConstructor || jstestdriver.plugins.async.DeferredQueue;
  this.queueArmorConstructor_ = opt_queueArmorConstructor || jstestdriver.plugins.async.DeferredQueueArmor;
  this.poolConstructor_ = opt_poolConstructor || jstestdriver.plugins.async.CallbackPool;
  this.poolArmorConstructor_ = opt_poolArmorConstructor || jstestdriver.plugins.async.CallbackPoolArmor;
  this.descriptions_ = [];
  this.operations_ = [];
  this.errors_ = [];
};


jstestdriver.plugins.async.DeferredQueue.prototype.execute_ = function(operation, onQueueComplete) {
  var queue = new (this.queueConstructor_)(this.setTimeout_, this.testCase_, onQueueComplete, this.armor_);
  this.armor_.setQueue(queue);

  var onPoolComplete = function(errors) {
    queue.finishStep_(errors);
  };
  var pool = new (this.poolConstructor_)(this.setTimeout_, this.testCase_, onPoolComplete);
  var poolArmor = new (this.poolArmorConstructor_)(pool);

  if (operation) {
    try {
      operation.call(this.testCase_, poolArmor, this.armor_);
    } catch (e) {
      this.errors_.push(e);
    }
  }

  pool.activate();
};


jstestdriver.plugins.async.DeferredQueue.prototype.defer = function(description, operation) {
  this.descriptions_.push(description);
  this.operations_.push(operation);
};


jstestdriver.plugins.async.DeferredQueue.prototype.startStep = function() {
  var nextDescription = this.descriptions_.shift();
  var nextOp = this.operations_.shift();
  if (nextOp) {
    //console.log('Starting step: \'' + nextDescription + '\'');
    var q = this;
    this.execute_(nextOp, function(errors) {
      q.finishStep_(errors);
    });
  } else {
    this.onQueueComplete_([]);
  }
};


jstestdriver.plugins.async.DeferredQueue.prototype.finishStep_ = function(errors) {
  this.errors_ = this.errors_.concat(errors);
  if (this.errors_.length) {
    this.onQueueComplete_(this.errors_);
  } else {
    this.startStep();
  }
};
/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */


/**
 * @fileoverview Defines the DeferredQueueArmor class. Encapsulates a DeferredQueue
 * behind a narrower interface. Also, validates arguments.
 *
 * @author rdionne@google.com (Robert Dionne)
 */


/**
 * Constructs a DeferredQueueArmor.
 * @constructor
 */
jstestdriver.plugins.async.DeferredQueueArmor = function() {
  this.q_ = null;
  this.step_ = 1;
};


/**
 * Sets the current queue instance.
 * @param {jstestdriver.plugins.async.DeferredQueue} queue The queue.
 */
jstestdriver.plugins.async.DeferredQueueArmor.prototype.setQueue = function(queue) {
  this.q_ = queue;
};


/**
 * Adds a function to the queue to call later.
 * @param {string|Function} description The description or function.
 * @param {Function=} operation The function.
 */
jstestdriver.plugins.async.DeferredQueueArmor.prototype.call = function(description, operation) {
  if (!this.q_) {
    throw new Error('Queue undefined!');
  }

  if (typeof description == 'function') {
    operation = description;
    description = 'Step ' + this.step_;
  }

  if (operation) {
    this.q_.defer(description, operation);
    this.step_ += 1;
  }

  return this;
};


/**
 * Adds a function to the queue to call later.
 * @param {string|Function} description The description or function.
 * @param {Function=} operation The function.
 * @deprecated
 */
jstestdriver.plugins.async.DeferredQueueArmor.prototype.defer =
    jstestdriver.plugins.async.DeferredQueueArmor.prototype.call;
/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */


/**
 * @fileoverview Defines the TestStage class.
 * @author rdionne@google.com (Robert Dionne)
 */


/**
 * Constructs a TestStage.
 *
 * A TestStage is an executable portion of a test, such as setUp, tearDown, or
 * the test method.
 *
 * @param {Function} onError An error handler.
 * @param {Function} onStageComplete A callback for stage completion.
 * @param {Object} testCase The test case that owns this test stage.
 * @param {Function} testMethod The test method this stage represents.
 * @param {Function} opt_armorConstructor The constructor of DeferredQueueArmor.
 * @param {Function} opt_queueConstructor The constructor of DeferredQueue.
 * @param {Function} opt_setTimeout The setTimeout function or suitable
 *     replacement.
 * @constructor
 */
jstestdriver.plugins.async.TestStage = function(
    onError, onStageComplete, testCase, testMethod, opt_argument,
    opt_armorConstructor, opt_queueConstructor, opt_setTimeout) {
  this.onError_ = onError;
  this.onStageComplete_ = onStageComplete;
  this.testCase_ = testCase;
  this.testMethod_ = testMethod;
  this.argument_ = opt_argument;
  this.armorConstructor_ = opt_armorConstructor ||
      jstestdriver.plugins.async.DeferredQueueArmor;
  this.queueConstructor_ = opt_queueConstructor ||
      jstestdriver.plugins.async.DeferredQueue;
  this.setTimeout_ = opt_setTimeout || jstestdriver.setTimeout;
};


/**
 * Executes this TestStage.
 */
jstestdriver.plugins.async.TestStage.prototype.execute = function() {
  var armor = new (this.armorConstructor_)();
  var queue = new (this.queueConstructor_)(
      this.setTimeout_, this.testCase_, this.onStageComplete_, armor);
  armor.setQueue(queue);

  if (this.testMethod_) {
    try {
      this.testMethod_.call(this.testCase_, armor, this.argument_);
    } catch (e) {
      this.onError_(e);
    }
  }

  queue.startStep();
};
/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
jstestdriver.plugins.ScriptLoader = function(win, dom, testCaseManager, now) {
  this.win_ = win;
  this.dom_ = dom;
  this.testCaseManager_ = testCaseManager;
  this.now_ = now;
};


jstestdriver.plugins.ScriptLoader.prototype.load = function(file, callback) {
  this.testCaseManager_.removeTestCaseForFilename(file.fileSrc);
  this.fileResult_ = null;
  var head = this.dom_.getElementsByTagName('head')[0];
  var script = this.dom_.createElement('script');
  var start = this.now_();

  if (!jstestdriver.jQuery.browser.opera) {
    script.onload = jstestdriver.bind(this, function() {
      this.cleanCallBacks(script)
      this.onLoad_(file, callback, start);
    });
  }
  script.onreadystatechange = jstestdriver.bind(this, function() {
    if (script.readyState === "loaded" || script.readyState === "complete") {
      this.cleanCallBacks(script)
      this.onLoad_(file, callback, start);
    }
  });

  var handleError = jstestdriver.bind(this, function(msg, url, line) {
    var loadMsg = 'error loading file: ' + file.fileSrc;

    if (line != undefined && line != null) {
      loadMsg += ':' + line;
    }
    if (msg != undefined && msg != null) {
      loadMsg += ': ' + msg;
    }
    this.cleanCallBacks(script)
    callback(new jstestdriver.FileResult(file, false, loadMsg));
  });
  this.win_.onerror = handleError; 
  script.onerror = handleError;

  script.type = "text/javascript";
  script.src = file.fileSrc;
  head.appendChild(script);

};

jstestdriver.plugins.ScriptLoader.prototype.cleanCallBacks = function(script) {
  script.onerror = jstestdriver.EMPTY_FUNC;
  script.onload = jstestdriver.EMPTY_FUNC;
  script.onreadystatechange = jstestdriver.EMPTY_FUNC;
  this.win_.onerror = jstestdriver.EMPTY_FUNC;
};


jstestdriver.plugins.ScriptLoader.prototype.onLoad_ =
    function(file, callback, start) {
  this.testCaseManager_.updateLatestTestCase(file.fileSrc);
  var result = new jstestdriver.FileResult(file, true, '', this.now_() - start);
  this.win_.onerror = jstestdriver.EMPTY_FUNC;
  callback(result);
};


jstestdriver.plugins.ScriptLoader.prototype.updateResult_ = function(fileResult) {
  if (this.fileResult_ == null) {
    this.fileResult_ = fileResult;
  }
};
/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
jstestdriver.plugins.StylesheetLoader = function(win, dom, synchronousCallback) {
  this.win_ = win;
  this.dom_ = dom;
  this.synchronousCallback_ = synchronousCallback;
};


jstestdriver.plugins.StylesheetLoader.prototype.load = function(file, callback) {
  this.fileResult_ = null;
  var head = this.dom_.getElementsByTagName('head')[0];
  var link = this.dom_.createElement('link');
  var handleError = jstestdriver.bind(this, function(msg, url, line) {
    var loadMsg = 'error loading file: ' + file.fileSrc;

    if (line != undefined && line != null) {
      loadMsg += ':' + line;
    }
    if (msg != undefined && msg != null) {
      loadMsg += ': ' + msg;
    }
    this.updateResult_(new jstestdriver.FileResult(file, false, loadMsg));
  });

  this.win_.onerror = handleError;
  link.onerror = handleError;
  if (!jstestdriver.jQuery.browser.opera) {
    link.onload = jstestdriver.bind(this, function() {
      this.onLoad_(file, callback);
    });
  }
  link.onreadystatechange = jstestdriver.bind(this, function() {
    if (link.readyState == 'loaded') {
      this.onLoad_(file, callback);
    }
  });
  link.type = "text/css";
  link.rel = "stylesheet";
  link.href = file.fileSrc;
  head.appendChild(link);

  // Firefox and Safari don't seem to support onload or onreadystatechange for link
  if (this.synchronousCallback_) {
    this.onLoad_(file, callback);
  }
};


jstestdriver.plugins.StylesheetLoader.prototype.onLoad_ = function(file, callback) {
  this.updateResult_(new jstestdriver.FileResult(file, true, ''));
  this.win_.onerror = jstestdriver.EMPTY_FUNC;
  callback(this.fileResult_);  
};


jstestdriver.plugins.StylesheetLoader.prototype.updateResult_ = function(fileResult) {
  if (this.fileResult_ == null) {
    this.fileResult_ = fileResult;
  }
};
/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
jstestdriver.plugins.FileLoaderPlugin = function(scriptLoader, stylesheetLoader) {
  this.scriptLoader_ = scriptLoader;
  this.stylesheetLoader_ = stylesheetLoader;
};


jstestdriver.plugins.FileLoaderPlugin.prototype.loadSource = function(file, onSourceLoaded) {
  if (file.fileSrc.match(/\.css$/)) {
    this.stylesheetLoader_.load(file, onSourceLoaded);
  } else {
    this.scriptLoader_.load(file, onSourceLoaded);
  }
};
/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
jstestdriver.plugins.TestRunnerPlugin = function(dateObj, clearBody, opt_runTestLoop) {
  this.dateObj_ = dateObj;
  this.clearBody_ = clearBody;
  this.boundRunTest_ = jstestdriver.bind(this, this.runTest);
  this.runTestLoop_ = opt_runTestLoop || jstestdriver.plugins.defaultRunTestLoop;
};


jstestdriver.plugins.createPausingRunTestLoop =
    function (interval, now, setTimeout) {
  var lastPause;
  function pausingRunTestLoop(testCaseName,
                              template,
                              tests,
                              runTest,
                              onTest,
                              onComplete) {
    var i = 0;
    lastPause = now();
    function nextTest() {
      if (tests[i]) {
        var test = tests[i++];
        jstestdriver.log("running " + testCaseName + '.' + test);
        onTest(runTest(testCaseName, template, test));
        if (now() - lastPause >= interval) {
          jstestdriver.log("pausing after " + testCaseName + '.' + test);
          lastPause = now();
          setTimeout(nextTest, 1);
        } else {
          nextTest();
        }
      } else {
        onComplete();
      }
    }
    nextTest();
  }
  return pausingRunTestLoop;
};


jstestdriver.plugins.pausingRunTestLoop =
    jstestdriver.plugins.createPausingRunTestLoop(
        0,
        jstestdriver.now,
        jstestdriver.setTimeout);


jstestdriver.plugins.defaultRunTestLoop =
    function(testCaseName, template, tests, runTest, onTest, onComplete) {
  for (var i = 0; tests[i]; i++) {
    onTest(runTest(testCaseName, template, tests[i]));
  }
  onComplete();
};


jstestdriver.plugins.TestRunnerPlugin.prototype.runTestConfiguration =
    function(testRunConfiguration, onTestDone, onTestRunConfigurationComplete) {
  var testCaseInfo = testRunConfiguration.getTestCaseInfo();
  var tests = testRunConfiguration.getTests();
  var size = tests.length;

  if (testCaseInfo.getType() != jstestdriver.TestCaseInfo.DEFAULT_TYPE) {
    for (var i = 0; tests[i]; i++) {
      onTestDone(new jstestdriver.TestResult(
          testCaseName,
          tests[i],
          'error',
          testCaseInfo.getTestCaseName() +
            ' is an unhandled test case: ' +
            testCaseInfo.getType(),
          '',
          0));
    }
    onTestRunConfigurationComplete();
    return;
  }

  this.runTestLoop_(testCaseInfo.getTestCaseName(),
                    testCaseInfo.getTemplate(),
                    tests,
                    this.boundRunTest_,
                    onTestDone,
                    onTestRunConfigurationComplete)
};


jstestdriver.plugins.TestRunnerPlugin.prototype.runTest =
    function(testCaseName, testCase, testName) {
  var testCaseInstance;
  var errors = [];
  try {
    try {
      testCaseInstance = new testCase();
    } catch (e) {
      return new jstestdriver.TestResult(
          testCaseName,
          testName,
          jstestdriver.TestResult.RESULT.ERROR,
          testCaseName + ' is not a test case',
          '',
          0);
    }
    var start = new this.dateObj_().getTime();
  
    jstestdriver.expectedAssertCount = -1;
    jstestdriver.assertCount = 0;
    var res = jstestdriver.TestResult.RESULT.PASSED;
    try {
      if (testCaseInstance.setUp) {
        testCaseInstance.setUp();
      }
      if (!(testName in testCaseInstance)) {
        var err = new Error(testName + ' not found in ' + testCaseName);
        err.name = 'AssertError';
        throw err;
      }
      testCaseInstance[testName]();
      if (jstestdriver.expectedAssertCount != -1 &&
          jstestdriver.expectedAssertCount != jstestdriver.assertCount) {
        var err = new Error("Expected '" +
            jstestdriver.expectedAssertCount +
            "' asserts but '" +
            jstestdriver.assertCount +
            "' encountered.");
  
        err.name = 'AssertError';
        throw err;
      }
    } catch (e) {
      // We use the global here because of a circular dependency. The isFailure plugin should be
      // refactored.
      res = jstestdriver.pluginRegistrar.isFailure(e) ?
          jstestdriver.TestResult.RESULT.FAILED :
            jstestdriver.TestResult.RESULT.ERROR;
      errors.push(e);
    }
    try {
      if (testCaseInstance.tearDown) {
        testCaseInstance.tearDown();
      }
      this.clearBody_();
    } catch (e) {
      if (res == jstestdriver.TestResult.RESULT.PASSED) {
        res = jstestdriver.TestResult.RESULT.ERROR;
      }
      errors.push(e);
    }
    var end = new this.dateObj_().getTime();
    msg = this.serializeError(errors);
    return new jstestdriver.TestResult(testCaseName, testName, res, msg,
            jstestdriver.console.getAndResetLog(), end - start);
  } catch (e) {
    errors.push(e);
    return new jstestdriver.TestResult(testCaseName, testName,
            'error', 'Unexpected runner error: ' + this.serializeError(errors),
            jstestdriver.console.getAndResetLog(), 0);
  }
};

/**
 *@param {Error} e
 */
jstestdriver.plugins.TestRunnerPlugin.prototype.serializeError = function(e) {
  return jstestdriver.angular.toJson(e);
};
/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */


/**
 * @fileoverview Defines the AsyncTestRunnerPlugin class, which executes
 * asynchronous test cases within JsTestDriver.
 *
 *     +----------------------------- more tests? ------------ nextTest() <--------------+
 *     |                                                                                 |
 *     v                                                                                 |
 * startSetUp() ---- execute ---> finishSetUp(errors)                                    |
 *                                     |                                                 |
 * startTestMethod() <--- no errors ---+---- errors ----+                                |
 *        |                                             |                                |
 *     execute                                          |                                |
 *        |                                             |                                |
 *        v                                             v                                |
 * finishTestMethod(errors) -- errors or no errors -> startTearDown() -- execute -> finishTearDown(errors)
 *
 * @author rdionne@google.com (Robert Dionne)
 */


/**
 * Constructs an AsyncTestRunnerPlugin.
 *
 * @param dateObj the date object constructor
 * @param clearBody a function to call to clear the document body.
 * @param opt_setTimeout window.setTimeout replacement.
 * @param opt_queueConstructor a constructor for obtaining new DeferredQueues.
 * @param opt_armorConstructor a constructor for obtaining new DeferredQueueArmors.
 */
jstestdriver.plugins.async.AsyncTestRunnerPlugin = function(
    dateObj, clearBody, opt_setTimeout, opt_queueConstructor, opt_armorConstructor) {
  this.name = "AsyncTestRunnerPlugin";
  this.dateObj_ = dateObj;
  this.clearBody_ = clearBody;
  this.setTimeout_ = opt_setTimeout || jstestdriver.setTimeout;
  this.queueConstructor_ = opt_queueConstructor || jstestdriver.plugins.async.DeferredQueue;
  this.armorConstructor_ = opt_armorConstructor || jstestdriver.plugins.async.DeferredQueueArmor;
  this.testRunConfiguration_ = null;
  this.testCaseInfo_ = null;
  this.onTestDone_ = null;
  this.onTestRunConfigurationComplete_ = null;
  this.testIndex_ = 0;
  this.testCase_ = null;
  this.testName_ = null;
  this.start_ = null;
  this.errors_ = null;
};

/**
 * Runs a test case.
 *
 * @param testRunConfiguration the test case configuration
 * @param onTestDone the function to call to report a test is complete
 * @param onTestRunConfigurationComplete the function to call to report a test
 * case is complete 
 */
jstestdriver.plugins.async.AsyncTestRunnerPlugin.prototype.runTestConfiguration = function(
    testRunConfiguration, onTestDone, onTestRunConfigurationComplete) {
  if (testRunConfiguration.getTestCaseInfo().getType() == jstestdriver.TestCaseInfo.ASYNC_TYPE) {
    this.testRunConfiguration_ = testRunConfiguration;
    this.testCaseInfo_ = testRunConfiguration.getTestCaseInfo();
    this.onTestDone_ = onTestDone;
    this.onTestRunConfigurationComplete_ = onTestRunConfigurationComplete;
    this.testIndex_ = 0;
    this.nextTest();
    return true;
  }

  return false;
};

/**
 * Runs the next test in the current test case.
 */
jstestdriver.plugins.async.AsyncTestRunnerPlugin.prototype.nextTest = function() {
  this.start_ = new this.dateObj_().getTime();
  if (this.testIndex_ < this.testRunConfiguration_.getTests().length) {
    jstestdriver.expectedAssertCount = -1;
    jstestdriver.assertCount = 0;
    this.testCase_ = new (this.testCaseInfo_.getTemplate());
    this.testName_ = this.testRunConfiguration_.getTests()[this.testIndex_];
    this.errors_ = [];
    this.startSetUp();
  } else {
    this.testRunConfiguration_ = null;
    this.testCaseInfo_ = null;
    this.onTestDone_ = null;
    this.testIndex_ = 0;
    this.testCase_ = null;
    this.testName_ = null;
    this.start_ = null;
    this.errors_ = null;

    // Unset this callback before running it because the next callback may be
    // set by the code run by the callback.
    var onTestRunConfigurationComplete = this.onTestRunConfigurationComplete_;
    this.onTestRunConfigurationComplete_ = null;
    onTestRunConfigurationComplete.call(this);
  }
};


/**
 * Starts the next phase of the current test in the current test case. Creates a
 * DeferredQueue to manage the steps of this phase, executes the phase
 * catching any exceptions, and then hands the control over to the queue to
 * call onQueueComplete when it empties.
 */
jstestdriver.plugins.async.AsyncTestRunnerPlugin.prototype.execute_ = function(
    onStageComplete, invokeMethod) {
  var runner = this;
  var onError = function(error) {runner.errors_.push(error);};
  var stage = new jstestdriver.plugins.async.TestStage(
      onError, onStageComplete, this.testCase_, invokeMethod, null,
      this.armorConstructor_, this.queueConstructor_, this.setTimeout_);
  stage.execute();
};


/**
 * Starts the setUp phase.
 */
jstestdriver.plugins.async.AsyncTestRunnerPlugin.prototype.startSetUp = function() {
  var runner = this;
  this.execute_(function(errors) {
    runner.finishSetUp(errors);
  }, this.testCase_.setUp);
};

/**
 * Finishes the setUp phase and reports any errors. If there are errors it
 * initiates the tearDown phase, otherwise initiates the testMethod phase.
 *
 * @param errors errors caught during the current asynchronous phase.
 */
jstestdriver.plugins.async.AsyncTestRunnerPlugin.prototype.finishSetUp = function(errors) {
  this.errors_ = this.errors_.concat(errors);
  if (this.errors_.length) {
    this.startTearDown();
  } else {
    this.startTestMethod();
  }
};

/**
 * Starts the testMethod phase.
 */
jstestdriver.plugins.async.AsyncTestRunnerPlugin.prototype.startTestMethod = function() {
  var runner = this;
  this.execute_(function(errors) {
    runner.finishTestMethod(errors);
  }, this.testCase_[this.testName_]);
};

/**
 * Finishes the testMethod phase and reports any errors. Continues with the
 * tearDown phase.
 *
 * @param errors errors caught during the current asynchronous phase.
 */
jstestdriver.plugins.async.AsyncTestRunnerPlugin.prototype.finishTestMethod = function(errors) {
  this.errors_ = this.errors_.concat(errors);
  this.startTearDown();
};


/**
 * Start the tearDown phase.
 */
jstestdriver.plugins.async.AsyncTestRunnerPlugin.prototype.startTearDown = function() {
  var runner = this;
  this.execute_(function(errors){
    runner.finishTearDown(errors);
  }, this.testCase_.tearDown);
};


/**
 * Finishes the tearDown phase and reports any errors. Submits the test results
 * to the test runner. Continues with the next test.
 *
 * @param errors errors caught during the current asynchronous phase.
 */
jstestdriver.plugins.async.AsyncTestRunnerPlugin.prototype.finishTearDown = function(errors) {
  this.errors_ = this.errors_.concat(errors);
  this.clearBody_();
  this.onTestDone_(this.buildResult());
  this.testIndex_ += 1;
  this.nextTest();
};

/**
 * Builds a test result.
 */
jstestdriver.plugins.async.AsyncTestRunnerPlugin.prototype.buildResult = function() {
  var end = new this.dateObj_().getTime();
  var result = 'passed';
  var message = '';
  if (this.errors_.length) {
    result = 'failed';
    message = jstestdriver.angular.toJson(this.errors_);
  } else if (jstestdriver.expectedAssertCount != -1 &&
             jstestdriver.expectedAssertCount != jstestdriver.assertCount) {
    result = 'failed';
    message = jstestdriver.angular.toJson([new Error("Expected '" +
        jstestdriver.expectedAssertCount +
        "' asserts but '" +
        jstestdriver.assertCount +
        "' encountered.")]);
  }
  return new jstestdriver.TestResult(
      this.testCaseInfo_.getTestCaseName(), this.testName_, result, message,
      jstestdriver.console.getAndResetLog(), end - this.start_);
};
/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
jstestdriver.plugins.DefaultPlugin = function(fileLoaderPlugin,
                                              testRunnerPlugin,
                                              assertsPlugin,
                                              testCaseManagerPlugin) {
  this.fileLoaderPlugin_ = fileLoaderPlugin;
  this.testRunnerPlugin_ = testRunnerPlugin;
  this.assertsPlugin_ = assertsPlugin;
  this.testCaseManagerPlugin_ = testCaseManagerPlugin;
};


jstestdriver.plugins.DefaultPlugin.prototype.name = 'defaultPlugin';


jstestdriver.plugins.DefaultPlugin.prototype.loadSource = function(file, onSourceLoaded) {
  return this.fileLoaderPlugin_.loadSource(file, onSourceLoaded);
};


jstestdriver.plugins.DefaultPlugin.prototype.runTestConfiguration = function(testRunConfiguration,
    onTestDone, onTestRunConfigurationComplete) {
  return this.testRunnerPlugin_.runTestConfiguration(testRunConfiguration, onTestDone,
      onTestRunConfigurationComplete);
};


jstestdriver.plugins.DefaultPlugin.prototype.isFailure = function(exception) {
  return this.assertsPlugin_.isFailure(exception);
};


jstestdriver.plugins.DefaultPlugin.prototype.getTestRunsConfigurationFor =
    function(testCaseInfos, expressions, testRunsConfiguration) {
  return this.testCaseManagerPlugin_.getTestRunsConfigurationFor(testCaseInfos,
                                                                expressions,
                                                                testRunsConfiguration);
};


jstestdriver.plugins.DefaultPlugin.prototype.onTestsStart =
    jstestdriver.EMPTY_FUNC;


jstestdriver.plugins.DefaultPlugin.prototype.onTestsFinish =
  jstestdriver.EMPTY_FUNC;
/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
jstestdriver.plugins.AssertsPlugin = function() {
};


jstestdriver.plugins.AssertsPlugin.prototype.isFailure = function(e) {
  return e.name == 'AssertError';
};
/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */


/**
 * Plugin that handles the default behavior for the TestCaseManager.
 * @author corysmith@google.com (Cory Smith)
 */
jstestdriver.plugins.TestCaseManagerPlugin = function() {};


/**
 * Write testRunconfigurations retrieved from testCaseInfos defined by expressions.
 * @param {Array.<jstestdriver.TestCaseInfo>} testCaseInfos The loaded test case infos.
 * @param {Array.<String>} The expressions that define the TestRunConfigurations
 * @parma {Array.<jstestdriver.TestRunConfiguration>} The resultant array of configurations.
 */
jstestdriver.plugins.TestCaseManagerPlugin.prototype.getTestRunsConfigurationFor =
    function(testCaseInfos, expressions, testRunsConfiguration) {
  var size = testCaseInfos.length;
  for (var i = 0; i < size; i++) {
    var testCaseInfo = testCaseInfos[i];
    var testRunConfiguration = testCaseInfo.getTestRunConfigurationFor(expressions);

    if (testRunConfiguration != null) {
      testRunsConfiguration.push(testRunConfiguration);
    }
  }
  return true;
};
