table knownMore
"Lots of auxiliary info about a known gene"
    (
    string name;        "The name displayed in the browser: OMIM, gbGeneName, or transId"
    string transId;     "Transcript ID. Genie-generated ID"
    string geneId;      "Gene (not transcript) Genie ID"
    uint gbGeneName;      "Connect to geneName table. GenBank gene name"
    uint gbProductName;   "Connects to productName table. GenBank product name"
    string gbProteinAcc;  "GenBank accession of protein"
    string gbNgi;         "GenBank gi of nucleotide seq"
    string gbPgi;         "GenBank gi of protein seq"
    uint omimId;          "OMIM ID or 0 if none"
    string omimName;	  "OMIM primary name"
    uint hugoId;          "HUGO Gene Nomenclature Committee (HGNC) ID, or 0 if none"
    string hugoSymbol;    "HGNC short name"
    string hugoName;	  "HGNC descriptive name"
    string hugoMap;       "HGNC map position"
    uint pmId1;           "Unknown - included in HUGO nomeids.txt"
    uint pmId2;           "Unknown - included in HUGO nomeids.txt"
    string refSeqAcc;	  "Accession of RefSeq mRNA"
    string aliases;	  "Aliases, if any. Comma- and space-separated list"
    uint locusLinkId;     "LocusLink ID"
    string gdbId;	  "NCBI GDB database ID"
    )
