table trackDb
"This describes an annotation track."
(
string track; 	"Symbolic ID of Track"
string shortLabel; "Short label displayed on left"
string type;      "Track type: bed, psl, genePred, etc."
string longLabel; "Long label displayed in middle"
ubyte visibility; "0=hide, 1=dense, 2=full, 3=pack, 4=squish"
float priority;   "0-100 - where to position.  0 is top"
ubyte colorR;	  "Color red component 0-255"
ubyte colorG;	  "Color green component 0-255"
ubyte colorB;	  "Color blue component 0-255"
ubyte altColorR;  "Light color red component 0-255"
ubyte altColorG;  "Light color green component 0-255"
ubyte altColorB;  "Light color blue component 0-255"
ubyte useScore;   "1 if use score, 0 if not"
ubyte private;	  "1 if only want to show it on test site"
int restrictCount;	"Number of chromosomes this is on (0=all though!)"
string[restrictCount] restrictList; "List of chromosomes this is on"
lstring url;	"URL to link to when they click on an item"
lstring html;   "Some html to display when they click on an item"
string grp;   "Which group track belongs to"
ubyte canPack; "1 if can pack track display, 0 otherwise"
lstring settings; "Name/value pairs for track-specific stuff"
)
