/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.tabfolder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.tabfolder.IPageMoveListener;

public class PageMoveHelper
implements Listener {
    private static final int INSERTION_MARK_WIDTH = 5;
    private static final int W = 15;
    private static final int H = 14;
    private static final int[] SHAPE;
    private static final int[] BORDER;
    private CTabFolder tabFolder;
    private CTabItem sourceItem = null;
    private int insertionMarkIndex = -1;
    private List<IPageMoveListener> listeners = null;
    private Shell arrow = null;
    private Region arrowShape = null;

    static {
        int[] nArray = new int[14];
        nArray[0] = 4;
        nArray[2] = 11;
        nArray[4] = 11;
        nArray[5] = 6;
        nArray[6] = 14;
        nArray[7] = 6;
        nArray[8] = 7;
        nArray[9] = 14;
        nArray[11] = 6;
        nArray[12] = 4;
        nArray[13] = 6;
        SHAPE = nArray;
        int[] nArray2 = new int[14];
        nArray2[0] = 4;
        nArray2[2] = 10;
        nArray2[4] = 10;
        nArray2[5] = 6;
        nArray2[6] = 13;
        nArray2[7] = 6;
        nArray2[8] = 7;
        nArray2[9] = 12;
        nArray2[10] = 1;
        nArray2[11] = 6;
        nArray2[12] = 4;
        nArray2[13] = 6;
        BORDER = nArray2;
    }

    public PageMoveHelper(CTabFolder tabFolder) {
        this.tabFolder = tabFolder;
        this.hookTabFolder();
    }

    private void hookTabFolder() {
        this.tabFolder.addListener(9, (Listener)this);
        this.tabFolder.addListener(3, (Listener)this);
        this.tabFolder.addListener(4, (Listener)this);
        this.tabFolder.addListener(5, (Listener)this);
    }

    private int findInsertionMarkIndex(int x, int y) {
        int resultIndex = -1;
        CTabItem item = this.tabFolder.getItem(new Point(x, y));
        if (item != null) {
            resultIndex = this.tabFolder.indexOf(item);
            int division = this.calculateDivision(item, y);
            if (x >= division) {
                ++resultIndex;
            }
        } else if (this.tabFolder.getItemCount() > 0) {
            int division = this.calculateDivision(0, y);
            if (division >= 0 && x < division) {
                resultIndex = 0;
            } else {
                int lastIndex = this.tabFolder.getItemCount() - 1;
                division = this.calculateDivision(lastIndex, y);
                if (division >= 0 && x > division) {
                    resultIndex = lastIndex + 1;
                }
            }
        }
        return resultIndex;
    }

    private int calculateDivision(int index, int y) {
        return this.calculateDivision(this.tabFolder.getItem(index), y);
    }

    private int calculateDivision(CTabItem item, int y) {
        Rectangle r = item.getBounds();
        if (y >= r.y && y < r.y + r.width) {
            return r.x + r.width * 2 / 3;
        }
        return -1;
    }

    private void cancel() {
        this.disposeArrow();
        this.tabFolder.setCursor(null);
        this.sourceItem = null;
        this.insertionMarkIndex = -1;
    }

    public void addListener(IPageMoveListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IPageMoveListener>();
        }
        this.listeners.add(l);
    }

    public void removeListener(IPageMoveListener l) {
        this.listeners.remove(l);
    }

    protected void firePageMoved(final int fromIndex, final int toIndex) {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object l = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IPageMoveListener)l).pageMoved(fromIndex, toIndex);
                }
            });
            ++n2;
        }
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 9: {
                this.handlePaint(event);
                break;
            }
            case 3: {
                this.handleMouseDown(event);
                break;
            }
            case 4: {
                this.handleMouseUp(event);
                break;
            }
            case 5: {
                this.handleMouseMove(event);
                break;
            }
            case 12: {
                this.handleDispose(event);
            }
        }
    }

    private void handlePaint(Event e) {
        if (this.insertionMarkIndex >= 0) {
            this.paintInsertionMarkAtIndex(this.insertionMarkIndex, e.gc, e.display);
        }
    }

    private Point calcInsertionLocation(int insertIndex, boolean toDisplay) {
        int lastIndex = this.tabFolder.getItemCount() - 1;
        if (insertIndex >= 0 && insertIndex <= lastIndex) {
            CTabItem item = this.tabFolder.getItem(insertIndex);
            Rectangle r = item.getBounds();
            if (toDisplay) {
                return this.tabFolder.toDisplay(r.x, r.y);
            }
            return new Point(r.x, r.y);
        }
        if (insertIndex > lastIndex) {
            CTabItem item = this.tabFolder.getItem(lastIndex);
            Rectangle r = item.getBounds();
            if (toDisplay) {
                return this.tabFolder.toDisplay(r.x + r.width - 1, r.y);
            }
            return new Point(r.x + r.width - 1, r.y);
        }
        return null;
    }

    private void paintInsertionMarkAtIndex(int insertIndex, GC gc, Display display) {
        Point loc = this.calcInsertionLocation(insertIndex, false);
        if (loc != null) {
            this.paintInsertionMarkAt(loc.x, loc.y, this.tabFolder.getTabHeight(), gc, display);
        }
    }

    private void paintInsertionMarkAt(int x, int y, int height, GC gc, Display display) {
        gc.setAlpha(208);
        gc.setBackground(ColorUtils.getColor("#0060d0"));
        gc.fillRectangle(x - 2, y, 5, height);
    }

    private void handleMouseDown(Event e) {
        this.sourceItem = this.tabFolder.getItem(new Point(e.x, e.y));
    }

    private void handleMouseUp(Event e) {
        if (this.sourceItem != null && this.insertionMarkIndex >= 0) {
            int from = this.tabFolder.indexOf(this.sourceItem);
            int to = this.insertionMarkIndex;
            if (this.insertionMarkIndex > this.tabFolder.getSelectionIndex()) {
                --to;
            }
            if (from != to) {
                this.firePageMoved(from, to);
            }
            this.tabFolder.setSelection(to);
            this.tabFolder.redraw();
        }
        this.cancel();
    }

    private void handleMouseMove(Event e) {
        if ((e.stateMask & SWT.BUTTON_MASK) != 0 && this.sourceItem != null) {
            this.tabFolder.setCursor(Display.getCurrent().getSystemCursor(21));
            int oldInsertIndex = this.insertionMarkIndex;
            int newInsertIndex = this.findInsertionMarkIndex(e.x, e.y);
            if (newInsertIndex != oldInsertIndex) {
                this.insertionMarkIndex = newInsertIndex;
                this.updateArrow(this.insertionMarkIndex);
                this.tabFolder.redraw();
            }
        } else {
            this.cancel();
        }
    }

    private void handleDispose(Event e) {
        this.disposeArrow();
        this.disposeArrowShape();
    }

    private void updateArrow(int insertIndex) {
        this.createArrow();
        Point loc = this.calcInsertionLocation(insertIndex, true);
        if (loc != null) {
            this.arrow.setVisible(true);
            this.arrow.setLocation(loc.x - 7, loc.y - 14 - 3);
        } else {
            this.arrow.setVisible(false);
        }
    }

    private void createArrow() {
        if (this.arrow != null && !this.arrow.isDisposed()) {
            return;
        }
        this.arrow = new Shell(this.tabFolder.getShell(), 16392);
        this.arrow.setRegion(this.getArrowShape());
        this.arrow.setBackground(ColorUtils.getColor("#4088ff"));
        this.arrow.setSize(16, 15);
        this.arrow.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                GC gc = event.gc;
                gc.setForeground(ColorUtils.getColor("#000080"));
                gc.setLineStyle(1);
                gc.setLineWidth(1);
                gc.drawPolygon(BORDER);
            }
        });
    }

    private Region getArrowShape() {
        if (this.arrowShape == null || this.arrowShape.isDisposed()) {
            this.arrowShape = new Region((Device)this.tabFolder.getDisplay());
            this.arrowShape.add(SHAPE);
        }
        return this.arrowShape;
    }

    private void disposeArrow() {
        if (this.arrow != null) {
            this.arrow.dispose();
            this.arrow = null;
        }
    }

    private void disposeArrowShape() {
        if (this.arrowShape != null) {
            this.arrowShape.dispose();
            this.arrowShape = null;
        }
    }
}

