/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.security;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;

public class BlockCipherInputStream
extends FilterInputStream {
    private final BufferedBlockCipher cipher;
    private byte[] outBuffer;
    private int outOffset;
    private final boolean isStream;
    private boolean eof;
    private int lastRead = -1;

    public BlockCipherInputStream(InputStream in, BufferedBlockCipher cipher) {
        super(in);
        this.cipher = cipher;
        this.isStream = cipher.getBlockSize() == 1;
        this.eof = false;
    }

    public int available() throws IOException {
        if (this.isStream) {
            return super.available();
        }
        if (this.outBuffer == null || this.outOffset >= this.outBuffer.length) {
            this.nextBlock();
        }
        return this.outBuffer.length - this.outOffset;
    }

    public synchronized void close() throws IOException {
        super.close();
    }

    public synchronized int read() throws IOException {
        if (this.isStream) {
            byte[] buf = new byte[1];
            int in = super.read();
            if (in == -1) {
                return -1;
            }
            buf[0] = (byte)in;
            try {
                this.cipher.processBytes(buf, 0, 1, buf, 0);
            }
            catch (DataLengthException e) {
                throw new IOException(e.getMessage());
            }
            return buf[0] & 0xFF;
        }
        if (this.outBuffer == null || this.outOffset >= this.outBuffer.length) {
            if (this.eof) {
                return -1;
            }
            this.nextBlock();
        }
        if (this.outBuffer == null || this.outOffset >= this.outBuffer.length) {
            return -1;
        }
        return this.outBuffer[this.outOffset++] & 0xFF;
    }

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            return (int)this.skip(len);
        }
        if (this.isStream) {
            if ((len = super.read(buf, off, len)) > 0) {
                try {
                    this.cipher.processBytes(buf, off, len, buf, off);
                }
                catch (DataLengthException shouldNotHappen) {
                    IOException ioe = new IOException("Short buffer for stream cipher -- this should not happen");
                    ioe.initCause(shouldNotHappen);
                    throw ioe;
                }
            }
            return len;
        }
        int count = 0;
        while (count < len) {
            if (this.outBuffer == null || this.outOffset >= this.outBuffer.length) {
                if (this.eof) {
                    if (count != 0) break;
                    count = -1;
                    break;
                }
                this.nextBlock();
            }
            if (this.outBuffer == null || this.outOffset >= this.outBuffer.length) {
                if (count != 0) break;
                count = -1;
                break;
            }
            int l = Math.min(this.outBuffer.length - this.outOffset, len - count);
            System.arraycopy(this.outBuffer, this.outOffset, buf, count + off, l);
            count += l;
            this.outOffset += l;
        }
        return count;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public long skip(long bytes) throws IOException {
        if (this.isStream) {
            return super.skip(bytes);
        }
        long ret = 0L;
        if (bytes > 0L && this.outBuffer != null && this.outOffset >= this.outBuffer.length) {
            ret = this.outBuffer.length - this.outOffset;
            this.outOffset = this.outBuffer.length;
        }
        return ret;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int mark) {
    }

    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    private void nextBlock() throws IOException {
        byte[] buf = new byte[this.cipher.getBlockSize()];
        byte[] out = new byte[this.cipher.getOutputSize(buf.length)];
        try {
            this.outBuffer = null;
            this.outOffset = 0;
            while (this.outBuffer == null) {
                int num;
                int len = this.in.read(buf);
                if (len == -1) {
                    if (this.lastRead > 0 && (num = this.cipher.doFinal(out, 0)) > 0) {
                        this.outBuffer = new byte[num];
                        System.arraycopy(out, 0, this.outBuffer, this.outOffset, num);
                    }
                    this.eof = true;
                    return;
                }
                this.lastRead = len;
                this.outOffset = 0;
                num = this.cipher.processBytes(buf, 0, len, out, 0);
                if (num <= 0) continue;
                this.outBuffer = new byte[num];
                System.arraycopy(out, 0, this.outBuffer, this.outOffset, num);
            }
        }
        catch (DataLengthException bpe) {
            IOException ioe = new IOException("illegal block size");
            ioe.initCause(bpe);
            throw ioe;
        }
        catch (InvalidCipherTextException ibse) {
            IOException ioe = new IOException("bad padding");
            ioe.initCause(ibse);
            throw ioe;
        }
    }
}

