/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.exports.outline.print;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.IContributedContentsView;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.exports.outline.print.OutlinePrintClient;
import org.xmind.ui.internal.exports.outline.print.OutlinePrintSetupDialog;

public class OutlinePrintHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IDialogSettings settings;
        PrintDialog printDialog;
        PrinterData data;
        final IEditorPart editor = this.findMindMapEditor(event);
        if (editor == null) {
            return null;
        }
        Shell parentShell = editor.getSite().getShell();
        if (parentShell == null || parentShell.isDisposed()) {
            return null;
        }
        OutlinePrintSetupDialog setupDialog = new OutlinePrintSetupDialog(parentShell, editor);
        do {
            int open;
            if ((open = setupDialog.open()) == 1) {
                return null;
            }
            settings = setupDialog.getSettings();
            data = new PrinterData();
            try {
                data.orientation = settings.getInt("orientation");
            }
            catch (NumberFormatException numberFormatException) {
                data.orientation = 2;
            }
            printDialog = new PrintDialog(parentShell);
            printDialog.setPrinterData(data);
        } while ((data = printDialog.open()) == null);
        final OutlinePrintClient client = new OutlinePrintClient(this.getJobName(editor), data, settings, setupDialog.getDatas());
        try {
            BusyIndicator.showWhile((Display)parentShell.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    if (settings.getBoolean("contentWholeWorkbook")) {
                        IWorkbook workbook = (IWorkbook)MindMapUIPlugin.getAdapter((Object)editor, IWorkbook.class);
                        if (workbook != null) {
                            client.print(workbook);
                        }
                    } else {
                        Object selectedPage;
                        ISheet sheet;
                        IPageChangeProvider pageProvider = (IPageChangeProvider)MindMapUIPlugin.getAdapter((Object)editor, IPageChangeProvider.class);
                        if (pageProvider != null && (sheet = (ISheet)MindMapUIPlugin.getAdapter((Object)(selectedPage = pageProvider.getSelectedPage()), ISheet.class)) != null) {
                            client.print(sheet);
                        }
                    }
                }
            });
            return null;
        }
        finally {
            client.dispose();
        }
    }

    private String getJobName(IEditorPart mme) {
        return ((IWorkbook)MindMapUIPlugin.getAdapter((Object)mme, IWorkbook.class)).getPrimarySheet().getTitleText();
    }

    private IEditorPart findMindMapEditor(ExecutionEvent event) {
        IEditorPart editor;
        IWorkbenchPage page;
        IWorkbenchWindow window;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part == null) {
            return null;
        }
        if ("org.xmind.ui.MindMapEditor".equals(part.getSite().getId()) && part instanceof IEditorPart) {
            return (IEditorPart)part;
        }
        IContributedContentsView iccv = (IContributedContentsView)part.getAdapter(IContributedContentsView.class);
        if (iccv != null && "org.xmind.ui.MindMapEditor".equals((part = iccv.getContributingPart()).getSite().getId()) && part instanceof IEditorPart) {
            return (IEditorPart)part;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null && (editor = page.getActiveEditor()) != null && "org.xmind.ui.MindMapEditor".equals(editor.getSite().getId())) {
            return editor;
        }
        return null;
    }
}

