/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.ui.internal.protocols.FilePathParser;
import org.xmind.ui.internal.protocols.FileProtocol;
import org.xmind.ui.internal.views.InspectorContentSection;
import org.xmind.ui.internal.views.Messages;
import org.xmind.ui.mindmap.MindMapUI;

public class ExternalFilesInspectorSection
extends InspectorContentSection
implements ICoreEventListener {
    private ICoreEventRegister register;
    private List<ITopic> topicsWithExternalFile;
    private List<ITopic> allTopics;

    public ExternalFilesInspectorSection() {
        this.setTitle(NLS.bind((String)Messages.ExternalFilesInspectorSection_title, (Object)0));
    }

    @Override
    protected Object[] getAllPropertyContents(IGraphicalViewer viewer) {
        List<ITopic> topicsWithExternalFile = null;
        List<ITopic> allTopics = null;
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        if (sheet != null) {
            allTopics = this.getAllTopics();
            topicsWithExternalFile = this.getTopicwithAttachment(allTopics);
        }
        this.setLabelRef(topicsWithExternalFile, allTopics);
        if (topicsWithExternalFile != null) {
            return topicsWithExternalFile.toArray();
        }
        return new Object[0];
    }

    private void setLabelRef(List<ITopic> topicsWithExternalFile, List<ITopic> allTopics) {
        if (this.topicsWithExternalFile == topicsWithExternalFile && allTopics == this.allTopics) {
            return;
        }
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
        this.topicsWithExternalFile = topicsWithExternalFile;
        this.allTopics = allTopics;
        if (allTopics != null) {
            this.register = new CoreEventRegister((Object)this.getCurrentWorkbook(), (ICoreEventListener)this);
            this.register.register("modifyTime");
        }
    }

    private List<ITopic> getTopicwithAttachment(List<ITopic> all) {
        ArrayList<ITopic> topics = null;
        for (ITopic topic : all) {
            if (!this.hasExternalFile(topic)) continue;
            if (topics == null) {
                topics = new ArrayList<ITopic>();
            }
            topics.add(topic);
        }
        return topics;
    }

    private boolean hasExternalFile(ITopic topic) {
        return topic.getHyperlink() != null && topic.getHyperlink().startsWith("file:");
    }

    @Override
    protected Image getPropertyInspectorImage(Object element) {
        if (element instanceof ITopic) {
            String path = FilePathParser.toPath(((ITopic)element).getHyperlink());
            path = FileProtocol.getAbsolutePath(element, path);
            File file = new File(path);
            ImageDescriptor image = MindMapUI.getImages().getFileIcon(path, true);
            if (image == null) {
                image = file.isDirectory() ? MindMapUI.getImages().get("fldr_obj.gif", true) : MindMapUI.getImages().get("unknownfile.gif", true);
            }
            if (image != null) {
                return image.createImage();
            }
        }
        return super.getPropertyInspectorImage(element);
    }

    @Override
    protected String getPropertyInspectorText(Object element) {
        if (element instanceof ITopic) {
            String link = ((ITopic)element).getHyperlink();
            return link.substring(link.lastIndexOf("/") + 1, link.length()).replaceAll("%20", " ");
        }
        return null;
    }

    @Override
    protected void refreshList() {
        super.refreshList();
        if (this.topicsWithExternalFile != null) {
            this.setTitle(NLS.bind((String)Messages.ExternalFilesInspectorSection_title, (Object)this.topicsWithExternalFile.size()));
        } else {
            this.setTitle(NLS.bind((String)Messages.ExternalFilesInspectorSection_title, (Object)0));
        }
    }

    public void handleCoreEvent(final CoreEvent event) {
        Control c = this.getControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        c.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ExternalFilesInspectorSection.this.refreshList(event);
            }
        });
    }

    protected void refreshList(CoreEvent event) {
        this.refreshList();
        this.getControl().getParent().layout();
    }

    @Override
    protected void handleDispose() {
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
    }
}

