/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMAccountAliasListDriver;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.AccountAliasCreateRequest;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.CreateAccountAliasRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMAccountAliasCreateDriver
extends IAMDriver {
    private static final String ALIAS = "Alias: ";
    private static final String SIGNIN_LINK = "Direct Signin Link: ";
    private static final String SIGNIN_LINK_SUFFIX = ".signin.aws.amazon.com";
    private static final String SIGNIN_PROTOCOL = "https://";
    private static final Log LOG = LogFactory.getLog(IAMAccountAliasListDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof AccountAliasCreateRequest) {
            AccountAliasCreateRequest req = (AccountAliasCreateRequest)request;
            String alias = req.getAccountAlias();
            CreateAccountAliasRequest aliasRequest = new CreateAccountAliasRequest();
            aliasRequest.setAccountAlias(alias);
            this.getClient().createAccountAlias(aliasRequest);
            LOG.info((Object)(ALIAS + alias));
            LOG.info((Object)("Direct Signin Link: https://" + alias + SIGNIN_LINK_SUFFIX));
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

