/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.soap;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.AbstractBinding;
import org.codehaus.xfire.service.binding.DocumentBinding;
import org.codehaus.xfire.service.binding.MessageBinding;
import org.codehaus.xfire.service.binding.RPCBinding;
import org.codehaus.xfire.service.binding.WrappedBinding;
import org.codehaus.xfire.soap.SoapVersion;

public abstract class AbstractSoapBinding
extends Binding {
    private String style = "document";
    private String use = "literal";
    private Map op2action = new HashMap();
    private Map action2Op = new HashMap();

    public AbstractSoapBinding(QName name, String bindingId, Service serviceInfo) {
        super(name, bindingId, serviceInfo);
    }

    public abstract SoapVersion getSoapVersion();

    public String getStyle() {
        return this.style;
    }

    public String getStyle(OperationInfo operation) {
        return this.style;
    }

    public OperationInfo getOperationByAction(String action) {
        OperationInfo op = (OperationInfo)this.action2Op.get(action);
        if (op == null) {
            op = (OperationInfo)this.action2Op.get("*");
        }
        return op;
    }

    public String getSoapAction(OperationInfo operation) {
        String action = (String)this.op2action.get(operation);
        if (action == null) {
            action = "";
        }
        return action;
    }

    public void setSoapAction(OperationInfo operation, String action) {
        this.op2action.put(operation, action);
        this.action2Op.put(action, operation);
    }

    public String getUse() {
        return this.use;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public static AbstractBinding getSerializer(String style, String use) {
        if (style.equals("wrapped") && use.equals("literal")) {
            return new WrappedBinding();
        }
        if (style.equals("document") && use.equals("literal")) {
            return new DocumentBinding();
        }
        if (style.equals("rpc") && use.equals("literal")) {
            return new RPCBinding();
        }
        if (style.equals("rpc") && use.equals("encoded")) {
            return new RPCBinding();
        }
        if (style.equals("message") && use.equals("literal")) {
            return new MessageBinding();
        }
        throw new UnsupportedOperationException("Service style/use not supported: " + style + "/" + use);
    }
}

