# Spotify-NP
# Written by Aaron Blakely <aaron@ephasic.org>
# Date: 2/13/2016
# Updated for new HexChat Perl API: 6/05/2019
#
# Usage:
#   /np     - Prints current track info to current window in /me action.
#   /nplink - Prints current track URI into current window.
#
# Autoloading [Tested with HexChat 2.14.2 on Arch]
#  Put np.pl in ~/.config/HexChat/addons
#  Script should now be autoloaded when starting HexChat.
#  adapted for deadbeef

use warnings;

if ($^O eq "linux") {
        HexChat::register("Deadbeef-NP", "0.0.1", "Deadbbef Now-Playing Script", "Deadbeef Now-Playing Script");
        HexChat::hook_command("np", "do_spotnp");
        HexChat::hook_command("nplink", "do_spotnplink");
} else {
        HexChat::print("Warning: Spotify-NP is only compatible with linux enviornments.");
}

sub do_spotnp {
        my $album  = `dbus-send --print-reply --dest=org.mpris.MediaPlayer2.DeaDBeeF /org/mpris/MediaPlayer2 org.freedesktop.DBus.Properties.Get string:'org.mpris.MediaPlayer2.Player' string:'Metadata'|egrep -A 2 "album"|egrep -v "album"|egrep -v "array"|cut -b 44-|cut -d '"' -f 1|egrep -v ^\$`;
        my $artist = `dbus-send --print-reply --dest=org.mpris.MediaPlayer2.DeaDBeeF /org/mpris/MediaPlayer2 org.freedesktop.DBus.Properties.Get string:'org.mpris.MediaPlayer2.Player' string:'Metadata'|egrep -A 2 "artist"|egrep -v "artist"|egrep -v "array"|cut -b 27-|cut -d '"' -f 1|egrep -v ^\$`;
        my $song   = `dbus-send --print-reply --dest=org.mpris.MediaPlayer2.DeaDBeeF /org/mpris/MediaPlayer2 org.freedesktop.DBus.Properties.Get string:'org.mpris.MediaPlayer2.Player' string:'Metadata'|egrep -A 1 "title"|egrep -v "title"|cut -b 44-|cut -d '"' -f 1|egrep -v ^\$`; 
        chomp $album;
        chomp $artist;
        chomp $song;

        HexChat::command("me is listening to $song by $artist [Album: $album]");
}

sub do_spotnplink {
        my $link = `dbus-send --print-reply --dest=org.mpris.MediaPlayer2.DeaDBeeF /org/mpris/MediaPlayer2 org.freedesktop.DBus.Properties.Get string:'org.mpris.MediaPlayer2.Player' string:'Metadata'|egrep -A 1 "url"|egrep -v "url"|cut -b 44-|cut -d '"' -f 1|egrep -v ^\$`;
        chomp $link;
        
        HexChat::command("say $link");
}
